/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import junit.framework.Assert;
import org.apache.derbyTesting.junit.JDBC;

public final class JDBCClient {
    public static final JDBCClient EMBEDDED_30 = new JDBCClient("Embedded_30", "org.apache.derby.jdbc.EmbeddedDriver", "org.apache.derby.jdbc.EmbeddedDataSource", "org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource", "org.apache.derby.jdbc.EmbeddedXADataSource", "jdbc:derby:");
    static final JDBCClient EMBEDDED_40 = new JDBCClient("Embedded_40", "org.apache.derby.jdbc.EmbeddedDriver", JDBC.vmSupportsJNDI() ? "org.apache.derby.jdbc.EmbeddedDataSource" : "org.apache.derby.jdbc.BasicEmbeddedDataSource40", JDBC.vmSupportsJNDI() ? "org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource" : "org.apache.derby.jdbc.BasicEmbeddedConnectionPoolDataSource40", JDBC.vmSupportsJNDI() ? "org.apache.derby.jdbc.EmbeddedXADataSource" : "org.apache.derby.jdbc.BasicEmbeddedXADataSource40", "jdbc:derby:");
    public static final JDBCClient DERBYNETCLIENT = new JDBCClient("DerbyNetClient", "org.apache.derby.jdbc.ClientDriver", JDBC.vmSupportsJDBC4() ? (JDBC.vmSupportsJNDI() ? "org.apache.derby.jdbc.ClientDataSource40" : "org.apache.derby.jdbc.BasicClientDataSource40") : "org.apache.derby.jdbc.ClientDataSource", JDBC.vmSupportsJDBC4() ? (JDBC.vmSupportsJNDI() ? "org.apache.derby.jdbc.ClientConnectionPoolDataSource40" : "org.apache.derby.jdbc.BasicClientConnectionPoolDataSource40") : "org.apache.derby.jdbc.ClientConnectionPoolDataSource", JDBC.vmSupportsJDBC4() ? (JDBC.vmSupportsJNDI() ? "org.apache.derby.jdbc.ClientXADataSource40" : "org.apache.derby.jdbc.BasicClientXADataSource40") : "org.apache.derby.jdbc.ClientXADataSource", "jdbc:derby://");
    static final JDBCClient DERBYNETCLIENT_30 = new JDBCClient("DerbyNetClient", "org.apache.derby.jdbc.ClientDriver", "org.apache.derby.jdbc.ClientDataSource", "org.apache.derby.jdbc.ClientConnectionPoolDataSource", "org.apache.derby.jdbc.ClientXADataSource", "jdbc:derby://");
    static final JDBCClient DB2CLIENT = new JDBCClient("DB2Client", "com.ibm.db2.jcc.DB2Driver", null, null, null, "jdbc:derby:net://");
    private final String frameWork;
    private final String driverClassName;
    private final String dsClassName;
    private final String poolDsClassName;
    private final String xaDsClassName;
    private final String urlBase;

    static JDBCClient getDefaultEmbedded() {
        if (JDBC.vmSupportsJDBC4()) {
            return EMBEDDED_40;
        }
        if (JDBC.vmSupportsJDBC3()) {
            return EMBEDDED_30;
        }
        Assert.fail((String)"Unknown JVM environment");
        return null;
    }

    public boolean isEmbedded() {
        return this.getName().startsWith("Embedded");
    }

    public boolean isDerbyNetClient() {
        return this.getName().equals(DERBYNETCLIENT.getName());
    }

    public boolean isDB2Client() {
        return this.getName().equals(DB2CLIENT.getName());
    }

    public String getName() {
        return this.frameWork;
    }

    public String getJDBCDriverName() {
        return this.driverClassName;
    }

    public String getDataSourceClassName() {
        return this.dsClassName;
    }

    public String getConnectionPoolDataSourceClassName() {
        return this.poolDsClassName;
    }

    public String getXADataSourceClassName() {
        return this.xaDsClassName;
    }

    public String getUrlBase() {
        return this.urlBase;
    }

    public String toString() {
        return this.frameWork;
    }

    private JDBCClient(String string, String string2, String string3, String string4, String string5, String string6) {
        this.frameWork = string;
        this.driverClassName = string2;
        this.dsClassName = string3;
        this.poolDsClassName = string4;
        this.xaDsClassName = string5;
        this.urlBase = string6;
    }
}

