/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;
import org.apache.derby.impl.sql.catalog.XPLAINTableDescriptor;

public class XPLAINStatementTimingsDescriptor
extends XPLAINTableDescriptor {
    private UUID timing_id;
    private Long parse_time;
    private Long bind_time;
    private Long optimize_time;
    private Long generate_time;
    private Long compile_time;
    private Long execute_time;
    private Timestamp begin_comp_time;
    private Timestamp end_comp_time;
    private Timestamp begin_exe_time;
    private Timestamp end_exe_time;
    static final String TABLENAME_STRING = "SYSXPLAIN_STATEMENT_TIMINGS";
    private static final String[][] indexColumnNames = new String[][]{{"TIMING_ID"}};

    public XPLAINStatementTimingsDescriptor() {
    }

    public XPLAINStatementTimingsDescriptor(UUID timing_id, Long parse_time, Long bind_time, Long optimize_time, Long generate_time, Long compile_time, Long execute_time, Timestamp begin_comp_time, Timestamp end_comp_time, Timestamp begin_exe_time, Timestamp end_exe_time) {
        this.timing_id = timing_id;
        this.parse_time = parse_time;
        this.bind_time = bind_time;
        this.optimize_time = optimize_time;
        this.generate_time = generate_time;
        this.compile_time = compile_time;
        this.execute_time = execute_time;
        this.begin_comp_time = DataTypeUtilities.clone(begin_comp_time);
        this.end_comp_time = DataTypeUtilities.clone(end_comp_time);
        this.begin_exe_time = DataTypeUtilities.clone(begin_exe_time);
        this.end_exe_time = DataTypeUtilities.clone(end_exe_time);
    }

    public void setStatementParameters(PreparedStatement ps) throws SQLException {
        ps.setString(1, this.timing_id.toString());
        ps.setObject(2, (Object)this.parse_time, -5);
        ps.setObject(3, (Object)this.bind_time, -5);
        ps.setObject(4, (Object)this.optimize_time, -5);
        ps.setObject(5, (Object)this.generate_time, -5);
        ps.setObject(6, (Object)this.compile_time, -5);
        ps.setObject(7, (Object)this.execute_time, -5);
        ps.setTimestamp(8, this.begin_comp_time);
        ps.setTimestamp(9, this.end_comp_time);
        ps.setTimestamp(10, this.begin_exe_time);
        ps.setTimestamp(11, this.end_exe_time);
    }

    @Override
    public String getCatalogName() {
        return TABLENAME_STRING;
    }

    @Override
    public SystemColumn[] buildColumnList() {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("TIMING_ID", false), SystemColumnImpl.getColumn("PARSE_TIME", -5, false), SystemColumnImpl.getColumn("BIND_TIME", -5, false), SystemColumnImpl.getColumn("OPTIMIZE_TIME", -5, false), SystemColumnImpl.getColumn("GENERATE_TIME", -5, false), SystemColumnImpl.getColumn("COMPILE_TIME", -5, false), SystemColumnImpl.getColumn("EXECUTE_TIME", -5, false), SystemColumnImpl.getColumn("BEGIN_COMP_TIME", 93, false), SystemColumnImpl.getColumn("END_COMP_TIME", 93, false), SystemColumnImpl.getColumn("BEGIN_EXE_TIME", 93, false), SystemColumnImpl.getColumn("END_EXE_TIME", 93, false)};
    }
}

