/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.OutputStream;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.services.io.TypedFormat;
import org.apache.derby.iapi.services.monitor.DerbyObservable;
import org.apache.derby.iapi.services.monitor.DerbyObserver;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.AuxObject;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.LongColumnException;
import org.apache.derby.impl.store.raw.data.OverflowInputStream;
import org.apache.derby.impl.store.raw.data.RecordId;
import org.apache.derby.impl.store.raw.data.StoredRecordHeader;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

abstract class BasePage
implements Page,
DerbyObserver,
TypedFormat {
    private AuxObject auxObj;
    protected PageKey identity;
    private StoredRecordHeader[] headers;
    private int recordCount;
    protected BaseContainerHandle owner;
    private int nestedLatch;
    protected boolean inClean;
    protected boolean preLatch;
    private LogInstant lastLog;
    private long repositionNeededAfterVersion;
    private long pageVersion = 0L;
    private byte pageStatus;
    public static final byte VALID_PAGE = 1;
    public static final byte INVALID_PAGE = 2;
    public static final int INIT_PAGE_REUSE = 1;
    public static final int INIT_PAGE_OVERFLOW = 2;
    public static final int INIT_PAGE_REUSE_RECORDID = 4;
    public static final int LOG_RECORD_DEFAULT = 0;
    public static final int LOG_RECORD_FOR_UPDATE = 1;
    public static final int LOG_RECORD_FOR_PURGE = 2;
    private static final RecordHandle InvalidRecordHandle = new RecordId(new PageKey(new ContainerKey(0L, 0L), -1L), 0);

    protected BasePage() {
    }

    protected void initialize() {
        this.setAuxObject(null);
        this.identity = null;
        this.recordCount = 0;
        this.clearLastLogInstant();
        this.repositionNeededAfterVersion = 0L;
        if (this.nestedLatch != 0) {
            SanityManager.THROWASSERT("nestedLatch is non-zero in initialize - value =  " + this.nestedLatch);
        }
        if (this.inClean) {
            SanityManager.THROWASSERT("inClean is true in initialize");
        }
        if (this.preLatch) {
            SanityManager.THROWASSERT("preLatch is true in initialize");
        }
    }

    protected void initializeHeaders(int numRecords) {
        if (this.recordCount != 0) {
            SanityManager.THROWASSERT("record count = " + this.recordCount + " before initSlotTable is called");
        }
        this.headers = new StoredRecordHeader[numRecords];
    }

    protected void fillInIdentity(PageKey key) {
        SanityManager.ASSERT(this.identity == null);
        SanityManager.ASSERT(this.repositionNeededAfterVersion == 0L);
        this.identity = key;
        this.repositionNeededAfterVersion = this.pageVersion;
    }

    public void clearIdentity() {
        SanityManager.ASSERT(!this.isLatched());
        this.identity = null;
        this.cleanPageForReuse();
    }

    protected void cleanPageForReuse() {
        this.setAuxObject(null);
        this.recordCount = 0;
        this.repositionNeededAfterVersion = 0L;
    }

    public Object getIdentity() {
        return this.identity;
    }

    @Override
    public final RecordHandle getInvalidRecordHandle() {
        return InvalidRecordHandle;
    }

    public static final RecordHandle MakeRecordHandle(PageKey pkey, int recordHandleConstant) throws StandardException {
        if (recordHandleConstant >= 6) {
            throw StandardException.newException("XSDAE.S", recordHandleConstant);
        }
        return new RecordId(pkey, recordHandleConstant);
    }

    @Override
    public final RecordHandle makeRecordHandle(int recordHandleConstant) throws StandardException {
        return BasePage.MakeRecordHandle(this.getPageId(), recordHandleConstant);
    }

    @Override
    public final long getPageNumber() {
        SanityManager.ASSERT(this.isLatched(), "page is not latched.");
        SanityManager.ASSERT(this.identity != null, "identity is null.");
        return this.identity.getPageNumber();
    }

    @Override
    public final PageKey getPageKey() {
        SanityManager.ASSERT(this.isLatched(), "page is not latched.");
        SanityManager.ASSERT(this.identity != null, "identity is null.");
        return this.identity;
    }

    @Override
    public final RecordHandle getRecordHandle(int recordId) {
        SanityManager.ASSERT(this.isLatched());
        int slot = this.findRecordById(recordId, 0);
        if (slot < 0) {
            return null;
        }
        return this.getRecordHandleAtSlot(slot);
    }

    @Override
    public final RecordHandle getRecordHandleAtSlot(int slot) {
        return this.getHeaderAtSlot(slot).getHandle(this.getPageId(), slot);
    }

    @Override
    public final boolean recordExists(RecordHandle handle, boolean ignoreDelete) throws StandardException {
        SanityManager.ASSERT(this.isLatched());
        if (handle.getId() < 6) {
            throw StandardException.newException("XSDAF.S", handle);
        }
        if (handle.getPageNumber() != this.getPageNumber()) {
            return false;
        }
        int slot = this.findRecordById(handle.getId(), handle.getSlotNumberHint());
        return slot >= 0 && (ignoreDelete || !this.isDeletedAtSlot(slot));
    }

    @Override
    public RecordHandle fetchFromSlot(RecordHandle rh, int slot, Object[] row, FetchDescriptor fetchDesc, boolean ignoreDelete) throws StandardException {
        SanityManager.ASSERT(this.isLatched());
        if (rh != null) {
            SanityManager.ASSERT(this.getSlotNumber(rh) == slot);
        }
        this.checkSlotOnPage(slot);
        StoredRecordHeader recordHeader = this.getHeaderAtSlot(slot);
        if (rh == null) {
            rh = recordHeader.getHandle(this.getPageId(), slot);
        }
        if (!ignoreDelete && recordHeader.isDeleted()) {
            return null;
        }
        return this.restoreRecordFromSlot(slot, row, fetchDesc, rh, recordHeader, true) ? rh : null;
    }

    @Override
    public final RecordHandle fetchFieldFromSlot(int slot, int fieldId, Object column) throws StandardException {
        Object[] row = new Object[fieldId + 1];
        row[fieldId] = column;
        FetchDescriptor fetchDesc = new FetchDescriptor(fieldId + 1, fieldId);
        return this.fetchFromSlot(null, slot, row, fetchDesc, true);
    }

    @Override
    public final int getSlotNumber(RecordHandle handle) throws StandardException {
        SanityManager.ASSERT(this.isLatched());
        int slot = this.findRecordById(handle.getId(), handle.getSlotNumberHint());
        if (slot < 0) {
            throw StandardException.newException("XSRS9.S", handle);
        }
        return slot;
    }

    @Override
    public final int getNextSlotNumber(RecordHandle handle) throws StandardException {
        SanityManager.ASSERT(this.isLatched());
        int slot = this.findNextRecordById(handle.getId());
        return slot;
    }

    @Override
    public RecordHandle insertAtSlot(int slot, Object[] row, FormatableBitSet validColumns, LogicalUndo undo, byte insertFlag, int overflowThreshold) throws StandardException {
        if (overflowThreshold == 0) {
            SanityManager.THROWASSERT("overflowThreshold cannot be 0");
        }
        if ((insertFlag & 1) == 1) {
            return this.insertNoOverflow(slot, row, validColumns, undo, insertFlag, overflowThreshold);
        }
        if (undo != null) {
            SanityManager.THROWASSERT("logical undo with overflow allowed on insert " + undo.toString());
        }
        return this.insertAllowOverflow(slot, row, validColumns, 0, insertFlag, overflowThreshold, null);
    }

    protected RecordHandle insertNoOverflow(int slot, Object[] row, FormatableBitSet validColumns, LogicalUndo undo, byte insertFlag, int overflowThreshold) throws StandardException {
        int recordId;
        RecordId handle;
        SanityManager.ASSERT(this.isLatched());
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1", new Object[0]);
        }
        if (slot < 0 || slot > this.recordCount) {
            throw StandardException.newException("XSDA1.S", new Object[0]);
        }
        if (!this.allowInsert()) {
            return null;
        }
        RawTransaction t = this.owner.getTransaction();
        if (undo != null) {
            t.checkLogicalOperationOk();
        }
        do {
            recordId = this.newRecordIdAndBump();
            handle = new RecordId(this.getPageId(), recordId, slot);
        } while (!this.owner.getLockingPolicy().lockRecordForWrite(t, handle, true, false));
        this.owner.getActionSet().actionInsert(t, this, slot, recordId, row, validColumns, undo, insertFlag, 0, false, -1, null, -1, overflowThreshold);
        return handle;
    }

    @Override
    public final RecordHandle insert(Object[] row, FormatableBitSet validColumns, byte insertFlag, int overflowThreshold) throws StandardException {
        if (overflowThreshold == 0) {
            SanityManager.THROWASSERT("overflowThreshold much be greater than 0");
        }
        if ((insertFlag & 1) == 1) {
            return this.insertAtSlot(this.recordCount, row, validColumns, null, insertFlag, overflowThreshold);
        }
        return this.insertAllowOverflow(this.recordCount, row, validColumns, 0, insertFlag, overflowThreshold, null);
    }

    public RecordHandle insertAllowOverflow(int slot, Object[] row, FormatableBitSet validColumns, int startColumn, byte insertFlag, int overflowThreshold, RecordHandle nextPortionHandle) throws StandardException {
        BasePage curPage = this;
        if (!curPage.owner.updateOK()) {
            throw StandardException.newException("40XD1", new Object[0]);
        }
        RecordId headHandle = null;
        RecordId handleToUpdate = null;
        RawTransaction t = curPage.owner.getTransaction();
        while (true) {
            SanityManager.ASSERT(curPage.isLatched());
            if (!curPage.allowInsert()) {
                return null;
            }
            if (curPage != this) {
                slot = curPage.recordCount;
            }
            boolean isLongColumns = false;
            int realStartColumn = -1;
            int realSpaceOnPage = -1;
            DynamicByteArrayOutputStream logBuffer = null;
            int recordId = curPage.newRecordIdAndBump();
            RecordId handle = new RecordId(curPage.getPageId(), recordId, slot);
            if (curPage == this) {
                if (handleToUpdate == null) {
                    while (!this.owner.getLockingPolicy().lockRecordForWrite(t, handle, true, false)) {
                        recordId = curPage.newRecordIdAndBump();
                        handle = new RecordId(curPage.getPageId(), recordId, slot);
                    }
                }
                headHandle = handle;
            }
            do {
                try {
                    startColumn = this.owner.getActionSet().actionInsert(t, curPage, slot, recordId, row, validColumns, null, insertFlag, startColumn, false, realStartColumn, logBuffer, realSpaceOnPage, overflowThreshold);
                    isLongColumns = false;
                }
                catch (LongColumnException lce) {
                    logBuffer = new DynamicByteArrayOutputStream(lce.getLogBuffer());
                    RecordHandle longColumnHandle = this.insertLongColumn(curPage, lce, insertFlag);
                    int overflowFieldLen = 0;
                    try {
                    }
                    catch (IOException ioe) {
                        return null;
                    }
                    realStartColumn = lce.getNextColumn() + 1;
                    realSpaceOnPage = lce.getRealSpaceOnPage() - (overflowFieldLen += this.appendOverflowFieldHeader(logBuffer, longColumnHandle));
                    isLongColumns = true;
                }
            } while (isLongColumns);
            if (handleToUpdate != null) {
                this.updateOverflowDetails(handleToUpdate, handle);
            }
            if (startColumn == -1) {
                if (curPage != this) {
                    curPage.unlatch();
                }
                if (nextPortionHandle != null) {
                    this.updateOverflowDetails(handle, nextPortionHandle);
                }
                return headHandle;
            }
            handleToUpdate = handle;
            BasePage nextPage = curPage.getOverflowPageForInsert(slot, row, validColumns, startColumn);
            if (curPage != this) {
                curPage.unlatch();
            }
            curPage = nextPage;
        }
    }

    protected RecordHandle insertLongColumn(BasePage mainChainPage, LongColumnException lce, byte insertFlag) throws StandardException {
        Object[] row = new Object[]{lce.getColumn()};
        RecordId firstHandle = null;
        RecordId handle = null;
        RecordId prevHandle = null;
        BasePage curPage = mainChainPage;
        BasePage prevPage = null;
        boolean isFirstPage = true;
        byte after_first_page_insertFlag = (byte)(insertFlag | 2);
        int startColumn = 0;
        RawTransaction t = curPage.owner.getTransaction();
        do {
            if (!isFirstPage) {
                prevPage = curPage;
                prevHandle = handle;
            }
            curPage = this.getNewOverflowPage();
            SanityManager.ASSERT(curPage.isLatched());
            SanityManager.ASSERT(curPage.allowInsert());
            int slot = curPage.recordCount;
            int recordId = curPage.newRecordId();
            handle = new RecordId(curPage.getPageId(), recordId, slot);
            if (isFirstPage) {
                firstHandle = handle;
            }
            startColumn = this.owner.getActionSet().actionInsert(t, curPage, slot, recordId, row, null, null, isFirstPage ? insertFlag : after_first_page_insertFlag, startColumn, true, -1, null, -1, 100);
            if (!isFirstPage) {
                prevPage.updateFieldOverflowDetails(prevHandle, handle);
                prevPage.unlatch();
                prevPage = null;
                continue;
            }
            isFirstPage = false;
        } while (startColumn != -1);
        if (curPage != null) {
            curPage.unlatch();
            curPage = null;
        }
        return firstHandle;
    }

    public abstract void preDirty();

    public abstract void updateOverflowDetails(RecordHandle var1, RecordHandle var2) throws StandardException;

    public abstract void updateFieldOverflowDetails(RecordHandle var1, RecordHandle var2) throws StandardException;

    public abstract int appendOverflowFieldHeader(DynamicByteArrayOutputStream var1, RecordHandle var2) throws StandardException, IOException;

    public abstract BasePage getOverflowPageForInsert(int var1, Object[] var2, FormatableBitSet var3, int var4) throws StandardException;

    protected abstract BasePage getNewOverflowPage() throws StandardException;

    @Override
    public final RecordHandle updateAtSlot(int slot, Object[] row, FormatableBitSet validColumns) throws StandardException {
        SanityManager.ASSERT(this.isLatched());
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1", new Object[0]);
        }
        if (this.isDeletedAtSlot(slot)) {
            throw StandardException.newException("XSDA2.S", new Object[0]);
        }
        RecordHandle handle = this.getRecordHandleAtSlot(slot);
        RawTransaction t = this.owner.getTransaction();
        this.doUpdateAtSlot(t, slot, handle.getId(), row, validColumns);
        return handle;
    }

    public abstract void doUpdateAtSlot(RawTransaction var1, int var2, int var3, Object[] var4, FormatableBitSet var5) throws StandardException;

    @Override
    public RecordHandle updateFieldAtSlot(int slot, int fieldId, Object newValue, LogicalUndo undo) throws StandardException {
        SanityManager.ASSERT(this.isLatched());
        SanityManager.ASSERT(newValue != null);
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1", new Object[0]);
        }
        if (this.isDeletedAtSlot(slot)) {
            throw StandardException.newException("XSDA2.S", new Object[0]);
        }
        RawTransaction t = this.owner.getTransaction();
        RecordHandle handle = this.getRecordHandleAtSlot(slot);
        this.owner.getActionSet().actionUpdateField(t, this, slot, handle.getId(), fieldId, newValue, undo);
        return handle;
    }

    @Override
    public final int fetchNumFields(RecordHandle handle) throws StandardException {
        SanityManager.ASSERT(this.isLatched());
        return this.fetchNumFieldsAtSlot(this.getSlotNumber(handle));
    }

    @Override
    public int fetchNumFieldsAtSlot(int slot) throws StandardException {
        SanityManager.ASSERT(this.isLatched());
        return this.getHeaderAtSlot(slot).getNumberFields();
    }

    @Override
    public RecordHandle deleteAtSlot(int slot, boolean delete, LogicalUndo undo) throws StandardException {
        SanityManager.ASSERT(this.isLatched());
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1", new Object[0]);
        }
        if (delete) {
            if (this.isDeletedAtSlot(slot)) {
                throw StandardException.newException("XSDA2.S", new Object[0]);
            }
        } else if (!this.isDeletedAtSlot(slot)) {
            throw StandardException.newException("XSDA5.S", new Object[0]);
        }
        RawTransaction t = this.owner.getTransaction();
        if (undo != null) {
            t.checkLogicalOperationOk();
        }
        RecordHandle handle = this.getRecordHandleAtSlot(slot);
        this.owner.getActionSet().actionDelete(t, this, slot, handle.getId(), delete, undo);
        return handle;
    }

    @Override
    public void purgeAtSlot(int slot, int numpurges, boolean needDataLogged) throws StandardException {
        SanityManager.ASSERT(this.isLatched());
        if (this.isOverflowPage()) {
            SanityManager.THROWASSERT("purge committed deletes on an overflow page.  Page = " + String.valueOf(this));
        }
        if (numpurges <= 0) {
            return;
        }
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1", new Object[0]);
        }
        if (slot < 0 || slot + numpurges > this.recordCount) {
            throw StandardException.newException("XSDA1.S", new Object[0]);
        }
        RawTransaction t = this.owner.getTransaction();
        int[] recordIds = new int[numpurges];
        PageKey pageId = this.getPageId();
        for (int i = 0; i < numpurges; ++i) {
            recordIds[i] = this.getHeaderAtSlot(slot + i).getId();
            RecordHandle handle = this.getRecordHandleAtSlot(slot);
            this.owner.getLockingPolicy().lockRecordForWrite(t, handle, false, true);
            if (this.owner.isTemporaryContainer() || this.entireRecordOnPage(slot + i)) continue;
            RecordHandle headRowHandle = this.getHeaderAtSlot(slot + i).getHandle(pageId, slot + i);
            this.purgeRowPieces(t, slot + i, headRowHandle, needDataLogged);
        }
        this.owner.getActionSet().actionPurge(t, this, slot, numpurges, recordIds, needDataLogged);
    }

    protected abstract void purgeRowPieces(RawTransaction var1, int var2, RecordHandle var3, boolean var4) throws StandardException;

    @Override
    public void copyAndPurge(Page destPage, int src_slot, int num_rows, int dest_slot) throws StandardException {
        SanityManager.ASSERT(this.isLatched());
        if (num_rows <= 0) {
            throw StandardException.newException("XSDAD.S", new Object[0]);
        }
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1", new Object[0]);
        }
        if (src_slot < 0 || src_slot + num_rows > this.recordCount) {
            throw StandardException.newException("XSDA1.S", new Object[0]);
        }
        SanityManager.ASSERT(destPage instanceof BasePage, "must copy from BasePage to BasePage");
        BasePage dpage = (BasePage)destPage;
        PageKey pageId = this.getPageId();
        if (!pageId.getContainerId().equals(dpage.getPageId().getContainerId())) {
            throw StandardException.newException("XSDAC.S", pageId.getContainerId(), dpage.getPageId().getContainerId());
        }
        int[] recordIds = new int[num_rows];
        RawTransaction t = this.owner.getTransaction();
        for (int i = 0; i < num_rows; ++i) {
            RecordHandle handle = this.getRecordHandleAtSlot(src_slot + i);
            this.owner.getLockingPolicy().lockRecordForWrite(t, handle, false, true);
            recordIds[i] = this.getHeaderAtSlot(src_slot + i).getId();
        }
        dpage.copyInto(this, src_slot, num_rows, dest_slot);
        this.owner.getActionSet().actionPurge(t, this, src_slot, num_rows, recordIds, true);
    }

    @Override
    public void unlatch() {
        SanityManager.ASSERT(this.isLatched(), "unlatch() attempted on page that is not latched.");
        this.releaseExclusive();
    }

    @Override
    public final synchronized boolean isLatched() {
        SanityManager.ASSERT(this.identity != null);
        return this.owner != null;
    }

    @Override
    public final int recordCount() {
        SanityManager.ASSERT(this.isLatched(), "page not latched on call to recordCount()");
        return this.recordCount;
    }

    protected abstract int internalDeletedRecordCount();

    protected int internalNonDeletedRecordCount() {
        if (this.pageStatus != 1) {
            return 0;
        }
        int deletedCount = this.internalDeletedRecordCount();
        if (deletedCount == -1) {
            int count = 0;
            int maxSlot = this.recordCount;
            for (int slot = 0; slot < maxSlot; ++slot) {
                if (this.isDeletedOnPage(slot)) continue;
                ++count;
            }
            return count;
        }
        int delCount = 0;
        int maxSlot = this.recordCount;
        for (int slot = 0; slot < maxSlot; ++slot) {
            if (!this.recordHeaderOnDemand(slot).isDeleted()) continue;
            ++delCount;
        }
        if (delCount != deletedCount) {
            SanityManager.THROWASSERT("incorrect deleted row count.  Should be: " + delCount + ", instead got: " + deletedCount + ", maxSlot = " + maxSlot + ", recordCount = " + this.recordCount + "\npage = " + String.valueOf(this));
        }
        return this.recordCount - deletedCount;
    }

    @Override
    public int nonDeletedRecordCount() {
        SanityManager.ASSERT(this.isLatched());
        return this.internalNonDeletedRecordCount();
    }

    @Override
    public boolean shouldReclaimSpace(int num_non_deleted_rows, int slot_just_deleted) throws StandardException {
        SanityManager.ASSERT(this.isLatched());
        boolean ret_val = false;
        if (!this.isOverflowPage()) {
            if (this.internalNonDeletedRecordCount() <= num_non_deleted_rows) {
                ret_val = true;
            } else if (!this.entireRecordOnPage(slot_just_deleted)) {
                ret_val = true;
            }
        }
        return ret_val;
    }

    protected final boolean isDeletedOnPage(int slot) {
        return this.getHeaderAtSlot(slot).isDeleted();
    }

    @Override
    public boolean isDeletedAtSlot(int slot) throws StandardException {
        SanityManager.ASSERT(this.isLatched());
        this.checkSlotOnPage(slot);
        return this.isDeletedOnPage(slot);
    }

    @Override
    public void setAuxObject(AuxObject obj) {
        SanityManager.ASSERT(this.identity == null || this.isLatched());
        if (this.auxObj != null) {
            this.auxObj.auxObjectInvalidated();
        }
        this.auxObj = obj;
    }

    @Override
    public AuxObject getAuxObject() {
        SanityManager.ASSERT(this.isLatched());
        return this.auxObj;
    }

    @Override
    public void setRepositionNeeded() {
        SanityManager.ASSERT(this.isLatched());
        this.repositionNeededAfterVersion = this.getPageVersion();
    }

    @Override
    public boolean isRepositionNeeded(long version) {
        SanityManager.ASSERT(this.isLatched());
        return this.repositionNeededAfterVersion > version;
    }

    @Override
    public void update(DerbyObservable obj, Object arg) {
        SanityManager.ASSERT(this.isLatched());
        SanityManager.ASSERT(obj == this.owner);
        this.releaseExclusive();
    }

    public final PageKey getPageId() {
        SanityManager.ASSERT(this.identity != null);
        return this.identity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setExclusive(BaseContainerHandle requester) throws StandardException {
        RawTransaction t = requester.getTransaction();
        BasePage basePage = this;
        synchronized (basePage) {
            if (this.owner != null && t == this.owner.getTransaction()) {
                if (t.inAbort()) {
                    ++this.nestedLatch;
                    return;
                }
                throw StandardException.newException("XSDAO.S", this.identity);
            }
            while (this.owner != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    InterruptStatus.setInterrupted();
                }
            }
            this.preLatch(requester);
            SanityManager.ASSERT(this.isLatched(), "page not latched");
            while (this.inClean) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    InterruptStatus.setInterrupted();
                }
            }
            this.preLatch = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setExclusiveNoWait(BaseContainerHandle requester) throws StandardException {
        RawTransaction t = requester.getTransaction();
        BasePage basePage = this;
        synchronized (basePage) {
            if (this.owner != null && t == this.owner.getTransaction() && t.inAbort()) {
                ++this.nestedLatch;
                return true;
            }
            if (this.owner == null) {
                this.preLatch(requester);
            } else {
                return false;
            }
            while (this.inClean) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    InterruptStatus.setInterrupted();
                }
            }
            this.preLatch = false;
        }
        SanityManager.ASSERT(this.isLatched(), "page not latched");
        return true;
    }

    protected synchronized void releaseExclusive() {
        if (!this.isLatched()) {
            SanityManager.THROWASSERT("releaseExclusive failed, nestedLatch = " + this.nestedLatch);
        }
        if (this.nestedLatch > 0) {
            --this.nestedLatch;
            return;
        }
        this.owner.deleteObserver(this);
        this.owner = null;
        this.notifyAll();
    }

    private void preLatch(BaseContainerHandle requester) {
        SanityManager.ASSERT(!this.isLatched(), "Attempted to pre-latch a latched page");
        this.owner = requester;
        requester.addObserver(this);
        this.preLatch = true;
    }

    protected final void setHeaderAtSlot(int slot, StoredRecordHeader rh) {
        if (slot < this.headers.length) {
            if (rh != null) {
                this.headers[slot] = rh;
            }
        } else {
            StoredRecordHeader[] new_headers = new StoredRecordHeader[slot + 1];
            System.arraycopy(this.headers, 0, new_headers, 0, this.headers.length);
            this.headers = new_headers;
            this.headers[slot] = rh;
        }
    }

    protected final void bumpRecordCount(int number) {
        this.recordCount += number;
    }

    public final StoredRecordHeader getHeaderAtSlot(int slot) {
        if (slot < this.headers.length) {
            StoredRecordHeader rh = this.headers[slot];
            return rh != null ? rh : this.recordHeaderOnDemand(slot);
        }
        return this.recordHeaderOnDemand(slot);
    }

    public abstract boolean entireRecordOnPage(int var1) throws StandardException;

    public abstract StoredRecordHeader recordHeaderOnDemand(int var1);

    private final void checkSlotOnPage(int slot) throws StandardException {
        SanityManager.ASSERT(this.isLatched());
        if (slot >= 0 && slot < this.recordCount) {
            return;
        }
        throw StandardException.newException("XSDA1.S", new Object[0]);
    }

    public int setDeleteStatus(int slot, boolean delete) throws StandardException, IOException {
        this.checkSlotOnPage(slot);
        return this.getHeaderAtSlot(slot).setDeleted(delete);
    }

    public void deallocatePage() throws StandardException {
        SanityManager.ASSERT(this.isLatched());
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1", new Object[0]);
        }
        RawTransaction t = this.owner.getTransaction();
        this.owner.getActionSet().actionInvalidatePage(t, this);
    }

    public void initPage(int initFlag, long pageOffset) throws StandardException {
        SanityManager.ASSERT(this.isLatched());
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1", new Object[0]);
        }
        RawTransaction t = this.owner.getTransaction();
        this.owner.getActionSet().actionInitPage(t, this, initFlag, this.getTypeFormatId(), pageOffset);
    }

    public int findRecordById(int recordId, int slotHint) {
        SanityManager.ASSERT(this.isLatched());
        if (slotHint == 0) {
            slotHint = recordId - 6;
        }
        int maxSlot = this.recordCount();
        if (slotHint > 0 && slotHint < maxSlot && recordId == this.getHeaderAtSlot(slotHint).getId()) {
            return slotHint;
        }
        for (int slot = 0; slot < maxSlot; ++slot) {
            if (recordId != this.getHeaderAtSlot(slot).getId()) continue;
            return slot;
        }
        return -1;
    }

    private int findNextRecordById(int recordId) {
        SanityManager.ASSERT(this.isLatched());
        int maxSlot = this.recordCount();
        for (int slot = 0; slot < maxSlot; ++slot) {
            if (this.getHeaderAtSlot(slot).getId() <= recordId) continue;
            return slot;
        }
        return -1;
    }

    private void copyInto(BasePage srcPage, int src_slot, int num_rows, int dest_slot) throws StandardException {
        if (dest_slot < 0 || dest_slot > this.recordCount) {
            throw StandardException.newException("XSDA1.S", new Object[0]);
        }
        RawTransaction t = this.owner.getTransaction();
        int[] recordIds = new int[num_rows];
        PageKey pageId = this.getPageId();
        for (int i = 0; i < num_rows; ++i) {
            recordIds[i] = i == 0 ? this.newRecordId() : this.newRecordId(recordIds[i - 1]);
            RecordId handle = new RecordId(pageId, recordIds[i], i);
            this.owner.getLockingPolicy().lockRecordForWrite(t, handle, false, true);
        }
        this.owner.getActionSet().actionCopyRows(t, this, srcPage, dest_slot, num_rows, src_slot, recordIds);
    }

    protected void removeAndShiftDown(int slot) {
        SanityManager.ASSERT(this.isLatched());
        SanityManager.ASSERT(slot >= 0 && slot < this.recordCount);
        System.arraycopy(this.headers, slot + 1, this.headers, slot, this.headers.length - (slot + 1));
        this.headers[this.headers.length - 1] = null;
        --this.recordCount;
    }

    protected StoredRecordHeader shiftUp(int low) {
        SanityManager.ASSERT(this.isLatched());
        if (low < 0 || low > this.recordCount) {
            SanityManager.THROWASSERT("shiftUp failed, low must be between 0 and recordCount.  low = " + low + ", recordCount = " + this.recordCount + "\n page = " + String.valueOf(this));
        }
        if (low < this.headers.length) {
            System.arraycopy(this.headers, low, this.headers, low + 1, this.headers.length - (low + 1));
            this.headers[low] = null;
        }
        return null;
    }

    public void compactRecord(RecordHandle handle) throws StandardException {
        SanityManager.ASSERT(this.isLatched());
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1", new Object[0]);
        }
        if (handle.getId() < 6) {
            throw StandardException.newException("XSDAF.S", handle);
        }
        if (handle.getPageNumber() != this.getPageNumber()) {
            throw StandardException.newException("XSDAK.S", handle);
        }
        if (this.isOverflowPage()) {
            throw StandardException.newException("XSDAL.S", handle);
        }
        int slot = this.findRecordById(handle.getId(), handle.getSlotNumberHint());
        if (slot >= 0) {
            this.compactRecord(this.owner.getTransaction(), slot, handle.getId());
        }
    }

    public final LogInstant getLastLogInstant() {
        return this.lastLog;
    }

    protected final void clearLastLogInstant() {
        this.lastLog = null;
    }

    protected final void updateLastLogInstant(LogInstant instant) {
        SanityManager.ASSERT(this.isLatched());
        if (instant != null) {
            this.lastLog = instant;
        }
    }

    @Override
    public final long getPageVersion() {
        return this.pageVersion;
    }

    protected final long bumpPageVersion() {
        SanityManager.ASSERT(this.isLatched());
        return ++this.pageVersion;
    }

    public final void setPageVersion(long v) {
        this.pageVersion = v;
    }

    protected void setPageStatus(byte status) {
        this.pageStatus = status;
    }

    public byte getPageStatus() {
        return this.pageStatus;
    }

    protected abstract boolean restoreRecordFromSlot(int var1, Object[] var2, FetchDescriptor var3, RecordHandle var4, StoredRecordHeader var5, boolean var6) throws StandardException;

    protected abstract void restorePortionLongColumn(OverflowInputStream var1) throws StandardException, IOException;

    public abstract int newRecordId() throws StandardException;

    public abstract int newRecordIdAndBump() throws StandardException;

    protected abstract int newRecordId(int var1) throws StandardException;

    public abstract boolean spaceForCopy(int var1, int[] var2) throws StandardException;

    public abstract int getTotalSpace(int var1) throws StandardException;

    public abstract int getReservedCount(int var1) throws IOException;

    public abstract int getRecordLength(int var1) throws IOException;

    public abstract void restoreRecordFromStream(LimitObjectInput var1, Object[] var2) throws StandardException, IOException;

    public abstract void logRecord(int var1, int var2, int var3, FormatableBitSet var4, OutputStream var5, RecordHandle var6) throws StandardException, IOException;

    public abstract int logRow(int var1, boolean var2, int var3, Object[] var4, FormatableBitSet var5, DynamicByteArrayOutputStream var6, int var7, byte var8, int var9, int var10, int var11) throws StandardException, IOException;

    public abstract void logField(int var1, int var2, OutputStream var3) throws StandardException, IOException;

    public abstract void logColumn(int var1, int var2, Object var3, DynamicByteArrayOutputStream var4, int var5) throws StandardException, IOException;

    public abstract int logLongColumn(int var1, int var2, Object var3, DynamicByteArrayOutputStream var4) throws StandardException, IOException;

    public abstract void storeRecord(LogInstant var1, int var2, boolean var3, ObjectInput var4) throws StandardException, IOException;

    public abstract void storeField(LogInstant var1, int var2, int var3, ObjectInput var4) throws StandardException, IOException;

    public abstract void reserveSpaceForSlot(LogInstant var1, int var2, int var3) throws StandardException, IOException;

    public abstract void skipField(ObjectInput var1) throws StandardException, IOException;

    public abstract void skipRecord(ObjectInput var1) throws StandardException, IOException;

    public abstract void setDeleteStatus(LogInstant var1, int var2, boolean var3) throws StandardException, IOException;

    public abstract void purgeRecord(LogInstant var1, int var2, int var3) throws StandardException, IOException;

    protected abstract void compactRecord(RawTransaction var1, int var2, int var3) throws StandardException;

    public abstract void setPageStatus(LogInstant var1, byte var2) throws StandardException;

    public abstract void initPage(LogInstant var1, byte var2, int var3, boolean var4, boolean var5) throws StandardException;

    public abstract void setReservedSpace(LogInstant var1, int var2, int var3) throws StandardException, IOException;

    public abstract boolean isOverflowPage();

    public abstract boolean allowInsert();

    public abstract boolean unfilled();

    public abstract void setContainerRowCount(long var1);

    protected abstract byte[] getPageArray() throws StandardException;

    protected String slotTableToString() {
        Object str = null;
        str = "";
        for (int slot = 0; slot < this.recordCount; ++slot) {
            StoredRecordHeader rh = this.getHeaderAtSlot(slot);
            str = rh != null ? (String)str + "Slot " + slot + " recordId " + rh.getId() : (String)str + "Slot " + slot + " null record";
            str = (String)str + "\n";
        }
        return str;
    }
}

