/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Derby5158Test
extends BaseJDBCTestCase {
    public Derby5158Test(String name) {
        super(name);
    }

    protected static Test makeSuite(String name) {
        BaseTestSuite suite = new BaseTestSuite(name);
        Test cst = TestConfiguration.defaultSuite(Derby5158Test.class);
        suite.addTest(cst);
        return suite;
    }

    public static Test suite() {
        String testName = "Derby5158Repro";
        return Derby5158Test.makeSuite(testName);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.setAutoCommit(false);
    }

    public void testCommitRollbackAfterShutdown() throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("select 1 from sys.systables");
        rs.close();
        s.close();
        TestConfiguration.getCurrent().shutdownDatabase();
        try {
            this.commit();
        }
        catch (SQLException e) {
            if (Derby5158Test.usingEmbedded()) {
                Derby5158Test.assertSQLState("08003", e);
            }
            Derby5158Test.assertSQLState("08006", e);
        }
        s = this.createStatement();
        rs = s.executeQuery("select 1 from sys.systables");
        rs.close();
        s.close();
        TestConfiguration.getCurrent().shutdownDatabase();
        try {
            this.rollback();
        }
        catch (SQLException e) {
            if (Derby5158Test.usingEmbedded()) {
                Derby5158Test.assertSQLState("08003", e);
            }
            Derby5158Test.assertSQLState("08006", e);
        }
    }
}

