/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.derby.vti.RestrictedVTI;
import org.apache.derby.vti.Restriction;
import org.apache.derby.vti.VTITemplate;

public class RestrictedTableVTI
extends VTITemplate
implements RestrictedVTI {
    private String _schemaName;
    private String _tableName;
    private Connection _connection;
    private String[] _columnNames;
    private Restriction _restriction;
    private int[] _columnNumberMap;
    private PreparedStatement _preparedStatement;
    private ResultSet _resultSet;
    private static String _lastQuery;

    protected RestrictedTableVTI(String schemaName, String tableName) throws Exception {
        this._schemaName = schemaName;
        this._tableName = tableName;
        this._connection = RestrictedTableVTI.getDerbyConnection();
    }

    public static RestrictedTableVTI readTable(String schemaName, String tableName) throws Exception {
        return new RestrictedTableVTI(schemaName, tableName);
    }

    public static String getLastQuery() {
        return _lastQuery;
    }

    public void close() throws SQLException {
        if (!this.isClosed()) {
            this._schemaName = null;
            this._tableName = null;
            this._connection = null;
            this._columnNames = null;
            this._restriction = null;
            this._columnNumberMap = null;
            if (this._resultSet != null) {
                this._resultSet.close();
            }
            if (this._preparedStatement != null) {
                this._preparedStatement.close();
            }
            this._resultSet = null;
            this._preparedStatement = null;
        }
    }

    public boolean next() throws SQLException {
        if (!this.isClosed() && this._resultSet == null) {
            this._preparedStatement = RestrictedTableVTI.prepareStatement(this._connection, this.makeQuery());
            this._resultSet = this._preparedStatement.executeQuery();
        }
        return this._resultSet.next();
    }

    public boolean isClosed() {
        return this._connection == null;
    }

    public boolean wasNull() throws SQLException {
        return this._resultSet.wasNull();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this._resultSet.getMetaData();
    }

    public InputStream getAsciiStream(int i) throws SQLException {
        return this._resultSet.getAsciiStream(this.mapColumnNumber(i));
    }

    public BigDecimal getBigDecimal(int i) throws SQLException {
        return this._resultSet.getBigDecimal(this.mapColumnNumber(i));
    }

    @Deprecated
    public BigDecimal getBigDecimal(int i, int scale) throws SQLException {
        return this._resultSet.getBigDecimal(this.mapColumnNumber(i), scale);
    }

    public InputStream getBinaryStream(int i) throws SQLException {
        return this._resultSet.getBinaryStream(this.mapColumnNumber(i));
    }

    public Blob getBlob(int i) throws SQLException {
        return this._resultSet.getBlob(this.mapColumnNumber(i));
    }

    public boolean getBoolean(int i) throws SQLException {
        return this._resultSet.getBoolean(this.mapColumnNumber(i));
    }

    public byte getByte(int i) throws SQLException {
        return this._resultSet.getByte(this.mapColumnNumber(i));
    }

    public byte[] getBytes(int i) throws SQLException {
        return this._resultSet.getBytes(this.mapColumnNumber(i));
    }

    public Reader getCharacterStream(int i) throws SQLException {
        return this._resultSet.getCharacterStream(this.mapColumnNumber(i));
    }

    public Clob getClob(int i) throws SQLException {
        return this._resultSet.getClob(this.mapColumnNumber(i));
    }

    public Date getDate(int i) throws SQLException {
        return this._resultSet.getDate(this.mapColumnNumber(i));
    }

    public Date getDate(int i, Calendar cal) throws SQLException {
        return this._resultSet.getDate(this.mapColumnNumber(i), cal);
    }

    public double getDouble(int i) throws SQLException {
        return this._resultSet.getDouble(this.mapColumnNumber(i));
    }

    public float getFloat(int i) throws SQLException {
        return this._resultSet.getFloat(this.mapColumnNumber(i));
    }

    public int getInt(int i) throws SQLException {
        return this._resultSet.getInt(this.mapColumnNumber(i));
    }

    public long getLong(int i) throws SQLException {
        return this._resultSet.getLong(this.mapColumnNumber(i));
    }

    public Object getObject(int i) throws SQLException {
        return this._resultSet.getObject(this.mapColumnNumber(i));
    }

    public short getShort(int i) throws SQLException {
        return this._resultSet.getShort(this.mapColumnNumber(i));
    }

    public String getString(int i) throws SQLException {
        return this._resultSet.getString(this.mapColumnNumber(i));
    }

    public Time getTime(int i) throws SQLException {
        return this._resultSet.getTime(this.mapColumnNumber(i));
    }

    public Time getTime(int i, Calendar cal) throws SQLException {
        return this._resultSet.getTime(this.mapColumnNumber(i), cal);
    }

    public Timestamp getTimestamp(int i) throws SQLException {
        return this._resultSet.getTimestamp(this.mapColumnNumber(i));
    }

    public Timestamp getTimestamp(int i, Calendar cal) throws SQLException {
        return this._resultSet.getTimestamp(this.mapColumnNumber(i), cal);
    }

    public void initScan(String[] columnNames, Restriction restriction) throws SQLException {
        this._columnNames = columnNames;
        this._restriction = restriction;
        int columnCount = this._columnNames.length;
        this._columnNumberMap = new int[columnCount];
        int foreignColumnID = 1;
        for (int i = 0; i < columnCount; ++i) {
            if (columnNames[i] == null) continue;
            this._columnNumberMap[i] = foreignColumnID++;
        }
    }

    private static Connection getDerbyConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:default:connection");
    }

    private String makeQuery() {
        String clause;
        StringBuffer buffer = new StringBuffer();
        buffer.append("select ");
        int possibleCount = this._columnNames.length;
        int actualCount = 0;
        for (int i = 0; i < possibleCount; ++i) {
            String rawName = this._columnNames[i];
            if (rawName == null) continue;
            if (actualCount > 0) {
                buffer.append(", ");
            }
            ++actualCount;
            buffer.append(RestrictedTableVTI.doubleQuote(rawName));
        }
        buffer.append("\nfrom ");
        buffer.append(RestrictedTableVTI.doubleQuote(this._schemaName));
        buffer.append('.');
        buffer.append(RestrictedTableVTI.doubleQuote(this._tableName));
        if (this._restriction != null && (clause = this._restriction.toSQL()) != null && (clause = clause.trim()).length() != 0) {
            buffer.append("\nwhere " + clause);
        }
        _lastQuery = buffer.toString();
        return _lastQuery;
    }

    private static String doubleQuote(String text) {
        return "\"" + text + "\"";
    }

    private static String singleQuote(String text) {
        return "'" + text + "'";
    }

    private static PreparedStatement prepareStatement(Connection conn, String text) throws SQLException {
        return conn.prepareStatement(text);
    }

    private int mapColumnNumber(int derbyNumber) {
        return this._columnNumberMap[derbyNumber - 1];
    }
}

