/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class SysDiagVTIMappingTest
extends BaseJDBCTestCase {
    private static final String testLogFile = "sys_vti_test_derby.tstlog";
    private static final String[] ALL_SPACE_TABLE_COLUMNS = new String[]{"CONGLOMERATENAME", "ISINDEX", "NUMALLOCATEDPAGES", "NUMFREEPAGES", "NUMUNFILLEDPAGES", "PAGESIZE", "ESTIMSPACESAVING", "TABLEID"};
    private static final String BAD_FROM_LIST_JOIN = "42ZB7";

    public SysDiagVTIMappingTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("Diagnostic VTI Table Mappings");
        Test defaultSetup = TestConfiguration.defaultSuite(SysDiagVTIMappingTest.class);
        Properties sysprops = new Properties();
        sysprops.put("derby.language.logStatementText", "true");
        SystemPropertyTestSetup verboseTest = new SystemPropertyTestSetup(defaultSetup, sysprops);
        suite.addTest((Test)verboseTest);
        return new SupportFilesSetup((Test)suite, new String[]{"functionTests/tests/lang/sys_vti_test_derby.tstlog"});
    }

    public void setUp() throws Exception {
        Statement stmt = this.createStatement();
        stmt.execute("create table app.t1 (i int, c varchar(10))");
        stmt.execute("insert into app.t1 values (1, 'one'), (2, 'two'), (4, 'four')");
        stmt.close();
    }

    @Override
    public void tearDown() throws Exception {
        Statement stmt = this.createStatement();
        stmt.execute("drop table app.t1");
        stmt.close();
        super.tearDown();
    }

    public void testSpaceTable() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("set schema APP");
        SysDiagVTIMappingTest.assertStatementError("42ZB4", st, "select * from TABLE(SPACE_TABLE('APP')) x");
        SysDiagVTIMappingTest.assertStatementError("42ZB4", st, "select * from TABLE(APP.SPACE_TABLE('APP', 'T1')) x");
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "select * from TABLE TABLE(SYSCS_DIAG.SPACE_TABLE('T1')) x");
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "select * from TABLE TABLE (select * from t1) x");
        SysDiagVTIMappingTest.assertStatementError("42Y07", st, "select * from TABLE(SYSCS_DIAG.SPACE_TABLE('T1', 'APP')) x");
        SysDiagVTIMappingTest.assertStatementError("42Y07", st, "select * from TABLE(SYSCS_DIAG.SPACE_TABLE('NOTTHERE', 'T1')) x");
        st.executeUpdate("set schema SYSCS_DIAG");
        SysDiagVTIMappingTest.assertStatementError("42ZB4", st, "select * from TABLE(APP.SPACE_TABLE('APP', 'T1')) x");
        st.executeUpdate("set schema APP");
        ResultSet rs1 = st.executeQuery("select t.tableid from sys.systables t, sys.sysschemas s\nwhere t.schemaid = s.schemaid\nand s.schemaname = 'APP'\nand t.tablename = 'T1'");
        rs1.next();
        String tableID = rs1.getString(1);
        rs1.close();
        ResultSet rs = st.executeQuery("select * from TABLE(SYSCS_DIAG.SPACE_TABLE('APP', 'T1')) x");
        String[] expColNames = ALL_SPACE_TABLE_COLUMNS;
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"T1", "0", "1", "0", "1", "4096", "0", tableID}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery(" select * from TABLE(SYSCS_DIAG.SPACE_TABLE('T1')) x");
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"T1", "0", "1", "0", "1", "4096", "0", tableID}};
        JDBC.assertFullResultSet(rs, expRS, true);
        PreparedStatement pSt = this.prepareStatement("select * from TABLE(SYSCS_DIAG.SPACE_TABLE(?, ?)) x");
        pSt.setString(1, "APP");
        pSt.setString(2, "T1");
        rs = pSt.executeQuery();
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"T1", "0", "1", "0", "1", "4096", "0", tableID}};
        JDBC.assertFullResultSet(rs, expRS, true);
        pSt = this.prepareStatement("select * from TABLE(SYSCS_DIAG.SPACE_TABLE(?)) x");
        pSt.setString(1, "T1");
        rs = pSt.executeQuery();
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"T1", "0", "1", "0", "1", "4096", "0", tableID}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from TABLE(SYSCS_DIAG.SPACE_TABLE('APP')) x");
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        rs = st.executeQuery("select * from TABLE(SYSCS_DIAG.SPACE_TABLE('APP', 'NOTTHERE')) x");
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        rs = st.executeQuery("select * from TABLE(SYSCS_DIAG.SPACE_TABLE('SYSCS_DIAG', 'NOTTHERE')) x");
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        rs = st.executeQuery("select * from TABLE(SYSCS_DIAG.SPACE_TABLE('SYSCS_DIAG', 'LOCK_TABLE')) x");
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        st.executeUpdate("set schema syscs_diag");
        pSt = this.prepareStatement("select * from TABLE(SPACE_TABLE(?, ?)) x");
        pSt.setString(1, "APP");
        pSt.setString(2, "T1");
        rs = pSt.executeQuery();
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"T1", "0", "1", "0", "1", "4096", "0", tableID}};
        JDBC.assertFullResultSet(rs, expRS, true);
        pSt = this.prepareStatement("select * from TABLE(SPACE_TABLE(?)) x");
        pSt.setString(1, "T1");
        rs = pSt.executeQuery();
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        rs = st.executeQuery("select * from TABLE(SPACE_TABLE('LOCK_TABLE')) x");
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        st.executeUpdate("set schema app");
        rs = st.executeQuery("select cast (conglomeratename as varchar(30)), t1.* from  TABLE(SYSCS_DIAG.SPACE_TABLE('APP', 'T1')) x,  t1 where x.conglomeratename is not null");
        expColNames = new String[]{"1", "I", "C"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"T1", "1", "one"}, {"T1", "2", "two"}, {"T1", "4", "four"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("set schema APP");
        rs = st.executeQuery("SELECT * FROM NEW org.apache.derby.diag.SpaceTable('T1') as x");
        JDBC.assertColumnNames(rs, ALL_SPACE_TABLE_COLUMNS);
        expRS = new String[][]{{"T1", "0", "1", "0", "1", "4096", "0", tableID}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("SELECT * FROM NEW org.apache.derby.diag.SpaceTable('APP', 'T1') as x");
        JDBC.assertColumnNames(rs, ALL_SPACE_TABLE_COLUMNS);
        expRS = new String[][]{{"T1", "0", "1", "0", "1", "4096", "0", tableID}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select t2.*\n    from\n        sys.systables systabs,\n        table (syscs_diag.space_table()) as t2\n    where systabs.tabletype = 'T'\n    and systabs.tableid = t2.tableid\n");
        JDBC.assertColumnNames(rs, ALL_SPACE_TABLE_COLUMNS);
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select t1.*\n    from\n        sys.systables systabs1,\n        table (syscs_diag.space_table( systabs1.tablename )) as t1\n    where systabs1.tabletype = 'T'\nunion\nselect t2.*\n    from\n        sys.systables systabs2,\n        table (syscs_diag.space_table( systabs2.tablename )) as t2\n    where systabs2.tabletype = 'T'\n");
        JDBC.assertColumnNames(rs, ALL_SPACE_TABLE_COLUMNS);
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select t2.*\n    from\n        sys.systables systabs,\n        table (syscs_diag.space_table(systabs.tablename)) as t2,\n        sys.sysconglomerates syscgs\n    where systabs.tabletype = 'T' and systabs.tableid = syscgs.tableid\n");
        JDBC.assertColumnNames(rs, ALL_SPACE_TABLE_COLUMNS);
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select t2.*\n    from\n        sys.sysconglomerates syscgs,\n        table (syscs_diag.space_table(systabs.tablename)) as t2,\n        sys.systables systabs\n    where systabs.tabletype = 'T' and systabs.tableid = syscgs.tableid\n");
        JDBC.assertColumnNames(rs, ALL_SPACE_TABLE_COLUMNS);
        JDBC.assertFullResultSet(rs, expRS, true);
        this.checkIllegalUses(st, "space_table", "SpaceTable", "('APP', 'T1')", "conglomeratename");
        this.getConnection().rollback();
        st.close();
    }

    public void testSpaceTable_0argConstructor() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = st.executeQuery("select conglomeratename, isindex, pagesize, tableid\nfrom table(syscs_diag.space_table()) x\nwhere conglomeratename like 'SYS%'\norder by conglomeratename");
        String[] columnNames = new String[]{"CONGLOMERATENAME", "ISINDEX", "PAGESIZE", "TABLEID"};
        JDBC.assertColumnNames(rs, columnNames);
        Object[][] expRS = new String[][]{{"SYSALIASES", "0", "4096", "c013800d-00d7-ddbd-08ce-000a0a411400"}, {"SYSALIASES_INDEX1", "1", "4096", "c013800d-00d7-ddbd-08ce-000a0a411400"}, {"SYSALIASES_INDEX2", "1", "4096", "c013800d-00d7-ddbd-08ce-000a0a411400"}, {"SYSALIASES_INDEX3", "1", "4096", "c013800d-00d7-ddbd-08ce-000a0a411400"}, {"SYSCHECKS", "0", "4096", "80000056-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSCHECKS_INDEX1", "1", "4096", "80000056-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSCOLPERMS", "0", "4096", "286cc01e-0103-0e39-b8e7-00000010f010"}, {"SYSCOLPERMS_INDEX1", "1", "4096", "286cc01e-0103-0e39-b8e7-00000010f010"}, {"SYSCOLPERMS_INDEX2", "1", "4096", "286cc01e-0103-0e39-b8e7-00000010f010"}, {"SYSCOLPERMS_INDEX3", "1", "4096", "286cc01e-0103-0e39-b8e7-00000010f010"}, {"SYSCOLUMNS", "0", "4096", "8000001e-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSCOLUMNS_INDEX1", "1", "4096", "8000001e-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSCOLUMNS_INDEX2", "1", "4096", "8000001e-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSCONGLOMERATES", "0", "4096", "80000010-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSCONGLOMERATES_INDEX1", "1", "4096", "80000010-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSCONGLOMERATES_INDEX2", "1", "4096", "80000010-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSCONGLOMERATES_INDEX3", "1", "4096", "80000010-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSCONSTRAINTS", "0", "4096", "8000002f-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSCONSTRAINTS_INDEX1", "1", "4096", "8000002f-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSCONSTRAINTS_INDEX2", "1", "4096", "8000002f-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSCONSTRAINTS_INDEX3", "1", "4096", "8000002f-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSDEPENDS", "0", "4096", "8000003e-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSDEPENDS_INDEX1", "1", "4096", "8000003e-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSDEPENDS_INDEX2", "1", "4096", "8000003e-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSDUMMY1", "0", "4096", "c013800d-00f8-5b70-bea3-00000019ed88"}, {"SYSFILES", "0", "4096", "80000000-00d3-e222-873f-000a0a0b1900"}, {"SYSFILES_INDEX1", "1", "4096", "80000000-00d3-e222-873f-000a0a0b1900"}, {"SYSFILES_INDEX2", "1", "4096", "80000000-00d3-e222-873f-000a0a0b1900"}, {"SYSFOREIGNKEYS", "0", "4096", "8000005b-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSFOREIGNKEYS_INDEX1", "1", "4096", "8000005b-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSFOREIGNKEYS_INDEX2", "1", "4096", "8000005b-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSKEYS", "0", "4096", "80000039-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSKEYS_INDEX1", "1", "4096", "80000039-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSPERMS", "0", "4096", "9810800c-0121-c5e1-a2f5-00000043e718"}, {"SYSPERMS_INDEX1", "1", "4096", "9810800c-0121-c5e1-a2f5-00000043e718"}, {"SYSPERMS_INDEX2", "1", "4096", "9810800c-0121-c5e1-a2f5-00000043e718"}, {"SYSPERMS_INDEX3", "1", "4096", "9810800c-0121-c5e1-a2f5-00000043e718"}, {"SYSROLES", "0", "4096", "e03f4017-0115-382c-08df-ffffe275b270"}, {"SYSROLES_INDEX1", "1", "4096", "e03f4017-0115-382c-08df-ffffe275b270"}, {"SYSROLES_INDEX2", "1", "4096", "e03f4017-0115-382c-08df-ffffe275b270"}, {"SYSROLES_INDEX3", "1", "4096", "e03f4017-0115-382c-08df-ffffe275b270"}, {"SYSROUTINEPERMS", "0", "4096", "2057c01b-0103-0e39-b8e7-00000010f010"}, {"SYSROUTINEPERMS_INDEX1", "1", "4096", "2057c01b-0103-0e39-b8e7-00000010f010"}, {"SYSROUTINEPERMS_INDEX2", "1", "4096", "2057c01b-0103-0e39-b8e7-00000010f010"}, {"SYSROUTINEPERMS_INDEX3", "1", "4096", "2057c01b-0103-0e39-b8e7-00000010f010"}, {"SYSSCHEMAS", "0", "4096", "80000022-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSSCHEMAS_INDEX1", "1", "4096", "80000022-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSSCHEMAS_INDEX2", "1", "4096", "80000022-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSSEQUENCES", "0", "4096", "9810800c-0121-c5e2-e794-00000043e718"}, {"SYSSEQUENCES_INDEX1", "1", "4096", "9810800c-0121-c5e2-e794-00000043e718"}, {"SYSSEQUENCES_INDEX2", "1", "4096", "9810800c-0121-c5e2-e794-00000043e718"}, {"SYSSTATEMENTS", "0", "4096", "80000000-00d1-15f7-ab70-000a0a0b1500"}, {"SYSSTATEMENTS_INDEX1", "1", "4096", "80000000-00d1-15f7-ab70-000a0a0b1500"}, {"SYSSTATEMENTS_INDEX2", "1", "4096", "80000000-00d1-15f7-ab70-000a0a0b1500"}, {"SYSSTATISTICS", "0", "4096", "f81e0010-00e3-6612-5a96-009e3a3b5e00"}, {"SYSSTATISTICS_INDEX1", "1", "4096", "f81e0010-00e3-6612-5a96-009e3a3b5e00"}, {"SYSTABLEPERMS", "0", "4096", "b8450018-0103-0e39-b8e7-00000010f010"}, {"SYSTABLEPERMS_INDEX1", "1", "4096", "b8450018-0103-0e39-b8e7-00000010f010"}, {"SYSTABLEPERMS_INDEX2", "1", "4096", "b8450018-0103-0e39-b8e7-00000010f010"}, {"SYSTABLEPERMS_INDEX3", "1", "4096", "b8450018-0103-0e39-b8e7-00000010f010"}, {"SYSTABLES", "0", "4096", "80000018-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSTABLES_INDEX1", "1", "4096", "80000018-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSTABLES_INDEX2", "1", "4096", "80000018-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSTRIGGERS", "0", "4096", "c013800d-00d7-c025-4809-000a0a411200"}, {"SYSTRIGGERS_INDEX1", "1", "4096", "c013800d-00d7-c025-4809-000a0a411200"}, {"SYSTRIGGERS_INDEX2", "1", "4096", "c013800d-00d7-c025-4809-000a0a411200"}, {"SYSTRIGGERS_INDEX3", "1", "4096", "c013800d-00d7-c025-4809-000a0a411200"}, {"SYSUSERS", "0", "4096", "9810800c-0134-14a5-40c1-000004f61f90"}, {"SYSUSERS_INDEX1", "1", "4096", "9810800c-0134-14a5-40c1-000004f61f90"}, {"SYSVIEWS", "0", "4096", "8000004d-00d0-fd77-3ed8-000a0a0b1900"}, {"SYSVIEWS_INDEX1", "1", "4096", "8000004d-00d0-fd77-3ed8-000a0a0b1900"}};
        JDBC.assertFullResultSet(rs, expRS, true);
    }

    public void test_vti2vtiJoinInFromList() throws Exception {
        Connection conn = this.getConnection();
        Statement st = this.createStatement();
        conn.prepareStatement("select t1.*\nfrom \n    sys.systables systabs,\n    table ( syscs_diag.space_table( systabs.tablename ) ) as t1\nwhere systabs.tabletype = 'T'\n");
        conn.prepareStatement("select t1.*\nfrom \n    table ( syscs_diag.space_table( systabs.tablename ) ) as t1,\n    sys.systables systabs\nwhere systabs.tabletype = 'T'\n");
        SysDiagVTIMappingTest.assertStatementError(BAD_FROM_LIST_JOIN, st, "select t1.*, t2.*\nfrom \n    sys.systables systabs,\n    table ( syscs_diag.space_table( systabs.tablename ) ) as t1,\n    table ( syscs_diag.space_table( t1.conglomeratename ) ) as t2\nwhere systabs.tabletype = 'T'\n");
        SysDiagVTIMappingTest.assertStatementError("42X04", st, "select t1.*, t2.*\nfrom \n    sys.systables systabs,\n    table ( syscs_diag.space_table( t1.conglomeratename ) ) as t2,\n    table ( syscs_diag.space_table( systabs.tablename ) ) as t1\nwhere systabs.tabletype = 'T'\n");
    }

    public void testStatementDuration() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("set schema APP");
        URL logURL = SupportFilesSetup.getReadOnlyURL(testLogFile);
        String vtiArg = "('" + logURL.getFile() + "')";
        ResultSet rs = st.executeQuery("select * from TABLE(SYSCS_DIAG.STATEMENT_DURATION" + vtiArg + ") x");
        String[] expColNames = new String[]{"TS", "THREADID", "XID", "LCCID", "LOGTEXT", "DURATION"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"2006-12-15 16:14:58.280 GMT", "main,5,main", "1111", "0", "(DATABASE = ugh), (DRDAID = null), Cleanup action starting", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("SELECT * FROM NEW org.apache.derby.diag.StatementDuration" + vtiArg + " as x");
        expColNames = new String[]{"TS", "THREADID", "XID", "LCCID", "LOGTEXT", "DURATION"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"2006-12-15 16:14:58.280 GMT", "main,5,main", "1111", "0", "(DATABASE = ugh), (DRDAID = null), Cleanup action starting", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        this.checkIllegalUses(st, "statement_duration", "StatementDuration", vtiArg, "logtext");
    }

    public void testErrorLogReader() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("set schema APP");
        URL logURL = SupportFilesSetup.getReadOnlyURL(testLogFile);
        String vtiArg = "('" + logURL.getFile() + "')";
        ResultSet rs = st.executeQuery(" select * from TABLE(SYSCS_DIAG.ERROR_LOG_READER" + vtiArg + ") x");
        String[] expColNames = new String[]{"TS", "THREADID", "XID", "LCCID", "DATABASE", "DRDAID", "LOGTEXT"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"2006-12-15 16:14:58.280 GMT", "main,5,main", "1111", "0", "ugh", "null", "Cleanup action starting"}, {"2006-12-15 16:14:58.280 GMT", "main,5,main", "1111", "0", "ugh", "null", "Failed Statement is: select * from oops"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("SELECT * FROM NEW org.apache.derby.diag.ErrorLogReader" + vtiArg + " as x");
        expColNames = new String[]{"TS", "THREADID", "XID", "LCCID", "DATABASE", "DRDAID", "LOGTEXT"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"2006-12-15 16:14:58.280 GMT", "main,5,main", "1111", "0", "ugh", "null", "Cleanup action starting"}, {"2006-12-15 16:14:58.280 GMT", "main,5,main", "1111", "0", "ugh", "null", "Failed Statement is: select * from oops"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        this.checkIllegalUses(st, "error_log_reader", "ErrorLogReader", vtiArg, "logtext");
    }

    public void testInvalidTableFunctions() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("set schema APP");
        ResultSet rs = st.executeQuery("select * from table (select * from t1) x");
        String[] expColNames = new String[]{"I", "C"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"1", "one"}, {"2", "two"}, {"4", "four"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery(" select * from table (values (1, 2), (2, 3)) x");
        expColNames = new String[]{"1", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "2"}, {"2", "3"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "select * from table (app.t1) x");
        SysDiagVTIMappingTest.assertStatementError("42ZB4", st, "select * from table (app.t1()) x");
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "select * from table (syscs_diag.lock_table) x");
        SysDiagVTIMappingTest.assertStatementError("42Y03", st, "select * from table (syscs_diag.lock_table()) x");
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "select * from table (syscs_diag.transaction_table) x");
        SysDiagVTIMappingTest.assertStatementError("42Y03", st, "select * from table (syscs_diag.transaction_table()) x");
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "select * from table (syscs_diag.statement_cache) x");
        SysDiagVTIMappingTest.assertStatementError("42Y03", st, "select * from table (syscs_diag.statement_cache()) x");
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "select * from table (syscs_diag.error_messages) x");
        SysDiagVTIMappingTest.assertStatementError("42Y03", st, "select * from table (syscs_diag.error_messages()) x");
        this.getConnection().rollback();
        st.close();
    }

    public void testOrderBy() throws SQLException {
        Statement st = this.createStatement();
        st.executeUpdate("set schema APP");
        st.execute("create table ob_t1 (i int, c char(250))");
        st.execute("create index i_ix on ob_t1 (i)");
        st.execute("create index c_ix on ob_t1 (c desc)");
        String[][] expRS = new String[][]{{"C_IX", "1", "0"}, {"I_IX", "1", "0"}, {"OB_T1", "0", "0"}};
        ResultSet rs = st.executeQuery("select CONGLOMERATENAME, ISINDEX, NUMFREEPAGES from table(syscs_diag.space_table('OB_T1')) X order by 1");
        JDBC.assertFullResultSet(rs, expRS);
        rs = st.executeQuery("select distinct CONGLOMERATENAME, ISINDEX, NUMFREEPAGES from table(syscs_diag.space_table('OB_T1')) X order by 1");
        JDBC.assertFullResultSet(rs, expRS);
        expRS = new String[][]{{"OB_T1", "0", "0"}, {"C_IX", "1", "0"}, {"I_IX", "1", "0"}};
        rs = st.executeQuery("select CONGLOMERATENAME, ISINDEX, NUMFREEPAGES from table(syscs_diag.space_table('OB_T1')) X order by 2, 1");
        JDBC.assertFullResultSet(rs, expRS);
        rs = st.executeQuery("select distinct CONGLOMERATENAME, ISINDEX, NUMFREEPAGES from table(syscs_diag.space_table('OB_T1')) X order by 2, 1");
        JDBC.assertFullResultSet(rs, expRS);
        expRS = new String[][]{{"OB_T1", "0", "0"}, {"I_IX", "1", "0"}, {"C_IX", "1", "0"}};
        rs = st.executeQuery("select CONGLOMERATENAME, ISINDEX, NUMFREEPAGES from table(syscs_diag.space_table('OB_T1')) X order by 2, 1 desc");
        JDBC.assertFullResultSet(rs, expRS);
        rs = st.executeQuery("select distinct CONGLOMERATENAME, ISINDEX, NUMFREEPAGES from table(syscs_diag.space_table('OB_T1')) X order by 2, 1 desc");
        JDBC.assertFullResultSet(rs, expRS);
        st.execute("drop table ob_t1");
        st.close();
    }

    public void testCorrelatedReferences() throws SQLException {
        Statement st = this.createStatement();
        String[][] expRS = new String[][]{};
        ResultSet rs = st.executeQuery("select s.schemaname, t.tableName\nfrom sys.sysschemas s, sys.systables t\nwhere t.schemaid=s.schemaid\nand exists\n(\n  select vti.*\n  from table( syscs_diag.space_table( s.schemaname, t.tableName ) ) as vti\n  where vti.numfreepages < -1\n)\n");
        JDBC.assertFullResultSet(rs, expRS);
        rs.close();
        st.close();
    }

    public void testContainedRoles() throws SQLException {
        Statement st = this.createStatement();
        ResultSet rs = st.executeQuery("select * from table(syscs_diag.contained_roles(null, 0))t");
        JDBC.assertEmpty(rs);
        rs = st.executeQuery("select * from table(syscs_diag.contained_roles(null))t");
        JDBC.assertEmpty(rs);
        rs.close();
        st.close();
    }

    public void test_5391() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs1 = st.executeQuery("select * from table (syscs_diag.error_log_reader( )) as t1");
        this.vetTimestamp(rs1);
        rs1.close();
        ResultSet rs2 = st.executeQuery("select * from table (syscs_diag.statement_duration()) as t1");
        this.vetTimestamp(rs2);
        rs2.close();
        st.close();
    }

    private void vetTimestamp(ResultSet rs) throws Exception {
        SysDiagVTIMappingTest.assertTrue((boolean)rs.next());
        String timestampString = rs.getString(1).trim();
        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
        Timestamp timestamp = new Timestamp(sdf.parse(timestampString).getTime());
        SysDiagVTIMappingTest.println(timestamp.toString());
    }

    private void checkIllegalUses(Statement st, String vtiTableName, String vtiMethodName, String args, String colName) throws SQLException {
        SysDiagVTIMappingTest.assertStatementError("42X05", st, "select * from syscs_diag." + vtiTableName);
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "select * from syscs_diag." + vtiTableName + args + " x");
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "select * from (syscs_diag." + vtiTableName + args + ") x");
        SysDiagVTIMappingTest.assertStatementError("42Y55", st, "drop table syscs_diag." + vtiTableName);
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "drop table syscs_diag." + vtiTableName + args);
        SysDiagVTIMappingTest.assertStatementError("42X62", st, "drop function syscs_diag." + vtiTableName);
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "drop function syscs_diag." + vtiTableName + args);
        SysDiagVTIMappingTest.assertStatementError("42X62", st, "alter table syscs_diag." + vtiTableName + " add column bad int");
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "alter table syscs_diag." + vtiTableName + args + " add column bad int");
        SysDiagVTIMappingTest.assertStatementError("42X05", st, "update syscs_diag." + vtiTableName + " set " + colName + " = NULL");
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "update syscs_diag." + vtiTableName + args + " set " + colName + "  = NULL");
        SysDiagVTIMappingTest.assertStatementError("42X05", st, "delete from syscs_diag." + vtiTableName + " where 1 = 1");
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "delete from syscs_diag." + vtiTableName + args + " where 1 = 1");
        SysDiagVTIMappingTest.assertStatementError("42X05", st, "insert into syscs_diag." + vtiTableName + " values('bad')");
        SysDiagVTIMappingTest.assertStatementError("42X05", st, "insert into syscs_diag." + vtiTableName + " (" + colName + ") values('bad')");
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "insert into syscs_diag." + vtiTableName + args + " values('bad')");
        CallableStatement cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_COMPRESS_TABLE(?, ?, 1)");
        cSt.setString(1, "SYSCS_DIAG");
        cSt.setString(2, vtiTableName.toUpperCase());
        SysDiagVTIMappingTest.assertStatementError("42X62", cSt);
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?, ?, 1, 1, 1)");
        cSt.setString(1, "SYSCS_DIAG");
        cSt.setString(2, vtiTableName.toUpperCase());
        SysDiagVTIMappingTest.assertStatementError("42Y55", cSt);
        SysDiagVTIMappingTest.assertStatementError("42X08", st, "update new org.apache.derby.diag." + vtiMethodName + args + " set " + colName + " = NULL");
        SysDiagVTIMappingTest.assertStatementError("42X08", st, "delete from new org.apache.derby.diag." + vtiMethodName + args + " where 1 = 0");
        st.execute("set schema syscs_diag");
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "select * from " + vtiTableName + args + " x");
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "select * from (" + vtiTableName + args + ") x");
        st.execute("set schema app");
    }
}

