/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memorydb;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;

public class MemoryDbManager {
    private static final String ATTR_CREATE = ";create=true";
    private static final String JDBC_PREFIX = "jdbc:derby:memory:";
    private static final MemoryDbManager DBM = new MemoryDbManager();
    private final ArrayList<Statement> STATEMENTS = new ArrayList();
    private final ArrayList<Connection> CONNECTIONS = new ArrayList();
    private final ArrayList<String> DATABASES = new ArrayList();

    public static MemoryDbManager getSharedInstance() {
        return DBM;
    }

    public Connection getConnection(String dbNameAndAttributes) throws SQLException {
        String url = JDBC_PREFIX + dbNameAndAttributes;
        try {
            DriverManager.getDriver(url);
        }
        catch (SQLException sqle) {
            new BaseJDBCTestCase(this, "dummy"){}.getConnection();
        }
        Connection con = DriverManager.getConnection(url);
        if (!this.CONNECTIONS.contains(con)) {
            this.CONNECTIONS.add(con);
        }
        return con;
    }

    public Statement createStatement(Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        this.STATEMENTS.add(stmt);
        if (!this.CONNECTIONS.contains(con)) {
            this.CONNECTIONS.add(con);
        }
        return stmt;
    }

    public PreparedStatement prepareStatement(Connection con, String sql) throws SQLException {
        PreparedStatement pStmt = con.prepareStatement(sql);
        this.STATEMENTS.add(pStmt);
        if (!this.CONNECTIONS.contains(con)) {
            this.CONNECTIONS.add(con);
        }
        return pStmt;
    }

    public void dropDatabase(String dbNameAndAttributes) throws SQLException {
        block2: {
            String url = JDBC_PREFIX + dbNameAndAttributes + ";drop=true";
            try {
                DriverManager.getConnection(url);
                BaseJDBCTestCase.fail((String)"Dropping database should raise exception.");
            }
            catch (SQLException sqle) {
                if (sqle.getSQLState().equals("08006") || sqle.getSQLState().equals("XJ004")) break block2;
                BaseJDBCTestCase.assertSQLState("Dropping database failed: (" + sqle.getSQLState() + ") " + sqle.getMessage(), "08006", sqle);
            }
        }
    }

    public Connection createDatabase(String dbName) throws SQLException {
        return this.createDatabase(dbName, null, null, null);
    }

    public Connection createDatabase(String dbName, String dbAttributes, String user, String password) throws SQLException {
        Connection con;
        Object userAttr = "";
        if (user != null) {
            userAttr = ";user=" + user;
        }
        if (password != null) {
            userAttr = (String)userAttr + ";password=" + password;
        }
        Object url = dbName;
        if (dbAttributes != null) {
            url = (String)url + ";" + dbAttributes;
        }
        if (!((String)userAttr).equals("")) {
            url = (String)url + (String)userAttr;
        }
        if (((String)url).indexOf(ATTR_CREATE) == -1) {
            url = (String)url + ATTR_CREATE;
        }
        if ((con = this.getConnection((String)url)).getWarnings() != null) {
            SQLWarning w = con.getWarnings();
            Object warnings = w.getMessage();
            while ((w = w.getNextWarning()) != null) {
                warnings = (String)warnings + " || " + w.getMessage();
            }
            BaseJDBCTestCase.fail((String)("Warning(s) when creating database: " + (String)warnings));
        }
        this.DATABASES.add(dbName + (String)userAttr);
        return con;
    }

    public void cleanUp() throws SQLException {
        int i;
        for (i = this.STATEMENTS.size() - 1; i >= 0; --i) {
            Statement stmt = this.STATEMENTS.remove(i);
            stmt.close();
        }
        for (i = this.CONNECTIONS.size() - 1; i >= 0; --i) {
            Connection con = this.CONNECTIONS.remove(i);
            try {
                con.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            con.close();
        }
        for (i = this.DATABASES.size() - 1; i >= 0; --i) {
            this.dropDatabase(this.DATABASES.remove(i));
        }
    }
}

