/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class BootLockTest
extends BaseJDBCTestCase {
    private static final String dbName = "BootLockTestDB";
    private static final String dbDir = "system" + File.separator + "BootLockTestDB";
    public static String minionCompleteFileName = dbDir + File.separator + "minionComplete";
    private static final String dbLockFile = dbDir + File.separator + "db.lck";
    private static final String dbExLockFile = dbDir + File.separator + "dbex.lck";
    private static final String servicePropertiesFileName = dbDir + File.separator + "service.properties";
    private static String[] cmd = new String[]{"org.apache.derbyTesting.functionTests.tests.store.BootLockMinion", "BootLockTestDB"};
    private static final String DATA_MULTIPLE_JBMS_ON_DB = "XSDB6";
    private static final String DATA_MULTIPLE_JBMS_FORCE_LOCK = "XSDB8";
    public static final int MINION_WAIT_MAX_MILLIS = 600000;

    public BootLockTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("BootLockTest");
        suite.addTest(BootLockTest.decorateTest());
        return suite;
    }

    private static Test decorateTest() {
        Object test = new BaseTestSuite(BootLockTest.class);
        if (JDBC.vmSupportsJSR169() && !BootLockTest.isJ9Platform()) {
            Properties props = new Properties();
            props.setProperty("derby.database.forceDatabaseLock", "true");
            test = new SystemPropertyTestSetup((Test)test, props, true);
        }
        test = TestConfiguration.singleUseDatabaseDecorator((Test)test, dbName);
        return test;
    }

    public void testBootLock() throws Exception {
        Process p = null;
        p = BootLockTest.execJavaCmd(cmd);
        this.waitForMinionBoot(p, 600000);
        try {
            Connection c = this.getConnection();
            BootLockTest.fail((String)"Dual boot not detected: check BootLockMinion.log");
        }
        catch (SQLException e) {
            if (JDBC.vmSupportsJSR169() && !BootLockTest.isJ9Platform()) {
                BootLockTest.assertSQLState("Dual boot not detected: check BootLockMinion.log", DATA_MULTIPLE_JBMS_FORCE_LOCK, e);
            } else {
                BootLockTest.assertSQLState("Dual boot not detected: check BootLockMinion.log", DATA_MULTIPLE_JBMS_ON_DB, e);
            }
        }
        finally {
            if (p != null) {
                p.destroy();
                p.waitFor();
            }
        }
        File minionLog = new File("system", "BootLockMinion.log");
        BootLockTest.assertTrue((boolean)minionLog.delete());
        if (JDBC.vmSupportsJSR169()) {
            File db_lockfile_name = new File(dbLockFile);
            File db_ex_lockfile_name = new File(dbExLockFile);
            db_lockfile_name.delete();
            db_ex_lockfile_name.delete();
        }
    }

    private void waitForMinionBoot(Process p, int waitmillis) throws InterruptedException {
        boolean minionComplete;
        StringBuffer failmsg = new StringBuffer();
        File lockFile = new File(dbLockFile);
        File servicePropertiesFile = new File(servicePropertiesFileName);
        BufferedReader minionSysErr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        String minionErrLine = null;
        File checkFile = new File(minionCompleteFileName);
        do {
            if (checkFile.exists()) {
                return;
            }
            waitmillis -= 1000;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                BootLockTest.fail((String)e.getMessage());
            }
        } while (waitmillis > 0);
        failmsg.append("Minion did not start or boot db in 600 seconds.\n");
        try {
            int minionExitValue = p.exitValue();
            minionComplete = true;
            failmsg.append("exitValue = " + minionExitValue);
        }
        catch (IllegalThreadStateException e) {
            minionComplete = false;
        }
        if (minionComplete) {
            failmsg.append("----Process exited. Minion's stderr:\n");
            do {
                try {
                    minionErrLine = minionSysErr.readLine();
                }
                catch (Exception ioe) {
                    failmsg.append("could not read minion's stderr");
                }
                if (minionErrLine == null) continue;
                failmsg.append(minionErrLine);
            } while (minionErrLine != null);
            failmsg.append("\n----Minion's stderr ended");
        }
        p.destroy();
        p.waitFor();
        BootLockTest.fail((String)failmsg.toString());
    }
}

