/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.PrintStream;
import java.sql.SQLException;
import org.apache.derby.tools.JDBCDisplayUtil;

public class JDBCTestDisplayUtil
extends JDBCDisplayUtil {
    public static void ShowCommonSQLException(PrintStream printStream, Throwable throwable) {
        if (throwable == null) {
            return;
        }
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            if (JDBCTestDisplayUtil.isDataConversionException(sQLException)) {
                printStream.println("Data Conversion SQLException");
            } else if (JDBCTestDisplayUtil.isResultSetClosedException(sQLException)) {
                printStream.println("Result Set Closed Exception");
            } else if (JDBCTestDisplayUtil.isNullSQLStringException(sQLException)) {
                printStream.println("Null SQL String Exception");
            } else if (JDBCTestDisplayUtil.isInvalidParameterException(sQLException)) {
                printStream.println("Invalid Parameter SQL Exception");
            } else if (JDBCTestDisplayUtil.isValidOnScrollCursorsException(sQLException)) {
                printStream.println("Method Only Valid On Scroll Cursors SQL Exception");
            } else if (JDBCTestDisplayUtil.isInvalidMethodReturnException(sQLException)) {
                printStream.println("Invalid Method Returning a ResultSet or Row Count SQL Exception");
            } else if (JDBCTestDisplayUtil.isTableDoesNotExistException(sQLException)) {
                printStream.println("Table Does Not Exist SQL Exception");
            } else if (JDBCTestDisplayUtil.isReturnsInvalidResultSetException(sQLException)) {
                printStream.println("Invalid Method Returning ResultSet SQL Exception");
            } else {
                JDBCTestDisplayUtil.ShowSQLException((PrintStream)printStream, (SQLException)sQLException);
            }
        } else {
            JDBCTestDisplayUtil.ShowException((PrintStream)printStream, (Throwable)throwable);
        }
    }

    private static boolean isDataConversionException(SQLException sQLException) {
        return sQLException.getMessage() != null && sQLException.getMessage().indexOf("Invalid data conversion") >= 0 || sQLException.getSQLState() != null && (sQLException.getSQLState().equals("22018") || sQLException.getSQLState().equals("22005") || sQLException.getSQLState().equals("22007"));
    }

    private static boolean isResultSetClosedException(SQLException sQLException) {
        return sQLException.getMessage() != null && sQLException.getMessage().indexOf("Invalid operation: result set closed") >= 0 || sQLException.getSQLState() != null && sQLException.getSQLState().equals("XCL16");
    }

    private static boolean isNullSQLStringException(SQLException sQLException) {
        return sQLException.getMessage() != null && sQLException.getMessage().indexOf("Null SQL string passed.") >= 0 || sQLException.getSQLState() != null && sQLException.getSQLState().equals("XJ067");
    }

    private static boolean isInvalidParameterException(SQLException sQLException) {
        return sQLException.getMessage() != null && sQLException.getMessage().indexOf("Invalid parameter value") >= 0 || sQLException.getMessage().indexOf("Invalid fetch size") >= 0 || sQLException.getMessage().indexOf("Invalid fetch direction") >= 0 || sQLException.getSQLState() != null && sQLException.getSQLState().equals("XJ066");
    }

    private static boolean isValidOnScrollCursorsException(SQLException sQLException) {
        return sQLException.getMessage() != null && sQLException.getMessage().indexOf("' method is only allowed on scroll cursors.") >= 0 || sQLException.getSQLState() != null && sQLException.getSQLState().equals("XJ061");
    }

    private static boolean isInvalidMethodReturnException(SQLException sQLException) {
        return sQLException.getMessage() != null && sQLException.getMessage().indexOf("executeQuery method cannot be used for update.") >= 0 || sQLException.getMessage().indexOf("executeUpdate method cannot be used for query.") >= 0 || sQLException.getSQLState() != null && (sQLException.getSQLState().equals("X0Y78") || sQLException.getSQLState().equals("X0Y79"));
    }

    private static boolean isTableDoesNotExistException(SQLException sQLException) {
        return sQLException.getSQLState() != null && sQLException.getSQLState().equals("42X05");
    }

    private static boolean isReturnsInvalidResultSetException(SQLException sQLException) {
        return sQLException.getMessage() != null && sQLException.getMessage().indexOf("cannot be called with a statement that returns a ResultSet.") >= 0 || sQLException.getSQLState() != null && sQLException.getSQLState().equals("X0Y79");
    }
}

