/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import org.apache.derby.iapi.services.io.Storable;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.shared.common.error.StandardException;

public class T_AccessRow {
    protected DataValueDescriptor[] column;

    public T_AccessRow(int n) {
        this.column = new DataValueDescriptor[n];
        for (int i = 0; i < n; ++i) {
            this.column[i] = new SQLInteger(0);
        }
    }

    public T_AccessRow(int n, int n2, int n3) {
        this.column = new DataValueDescriptor[3];
        this.column[0] = new SQLInteger(n);
        this.column[1] = new SQLInteger(n2);
        this.column[2] = new SQLInteger(n3);
    }

    public DataValueDescriptor getCol(int n) {
        if (n >= this.column.length) {
            return null;
        }
        return this.column[n];
    }

    public void setCol(int n, DataValueDescriptor dataValueDescriptor) {
        if (n >= this.column.length) {
            this.realloc(n + 1);
        }
        this.column[n] = dataValueDescriptor;
    }

    public boolean equals(T_AccessRow t_AccessRow) throws StandardException {
        if (t_AccessRow == null) {
            return false;
        }
        if (t_AccessRow.column.length != this.column.length) {
            return false;
        }
        for (int i = 0; i < this.column.length; ++i) {
            if (this.column[i].compare(t_AccessRow.column[i]) == 0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        Object object = "{ ";
        for (int i = 0; i < this.column.length; ++i) {
            object = (String)object + this.column[i].toString();
            if (i >= this.column.length - 1) continue;
            object = (String)object + ", ";
        }
        object = (String)object + " }";
        return object;
    }

    protected void realloc(int n) {
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[n];
        for (int i = 0; i < this.column.length; ++i) {
            dataValueDescriptorArray[i] = this.column[i];
        }
        this.column = dataValueDescriptorArray;
    }

    public Storable getStorableColumn(int n) {
        return this.column[n];
    }

    public void setStorableColumn(int n, Storable storable) {
        this.column[n] = (DataValueDescriptor)storable;
    }

    public int nColumns() {
        return this.column.length;
    }

    public DataValueDescriptor[] getRowArray() {
        return this.column;
    }

    public DataValueDescriptor[] getRowArrayClone() {
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[this.column.length];
        for (int i = 0; i < this.column.length; ++i) {
            dataValueDescriptorArray[i] = this.column[i].cloneValue(false);
        }
        return dataValueDescriptorArray;
    }
}

