/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.control.action;

import java.util.ArrayList;
import java.util.List;
import org.apache.torque.generator.GeneratorException;
import org.apache.torque.generator.configuration.outlet.OutletConfiguration;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.control.TokenReplacer;
import org.apache.torque.generator.control.action.MergepointAction;
import org.apache.torque.generator.outlet.Outlet;
import org.apache.torque.generator.outlet.OutletResult;
import org.apache.torque.generator.qname.Namespace;
import org.apache.torque.generator.qname.QualifiedName;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourcePath;

public class TraverseAllAction
implements MergepointAction {
    private final String elementsToTraverseName;
    private final String outletName;
    private boolean acceptEmpty = true;

    public TraverseAllAction(String elementsToTraverseName, String outletName, Boolean acceptEmpty) {
        if (elementsToTraverseName == null) {
            throw new IllegalArgumentException("TraverseAllAction: elementsToTraverseName must not be null");
        }
        this.elementsToTraverseName = elementsToTraverseName;
        if (outletName == null) {
            throw new IllegalArgumentException("TraverseAllAction: outletName must not be null");
        }
        this.outletName = outletName;
        if (acceptEmpty != null) {
            this.acceptEmpty = acceptEmpty;
        }
    }

    public OutletResult execute(ControllerState controllerState) throws GeneratorException {
        String detokenizedOutletName;
        QualifiedName outletQName;
        TokenReplacer tokenReplacer = new TokenReplacer(controllerState);
        OutletConfiguration outletConfiguration = controllerState.getUnitConfiguration().getOutletConfiguration();
        Outlet outlet = outletConfiguration.getOutlet(outletQName = new QualifiedName(detokenizedOutletName = tokenReplacer.process(this.outletName), Namespace.ROOT_NAMESPACE));
        if (outlet == null) {
            throw new GeneratorException("TraverseAllAction : The outlet " + this.outletName + " does not exist");
        }
        SourceElement currentElement = controllerState.getSourceElement();
        String detokenizedElementToTraverseName = tokenReplacer.process(this.elementsToTraverseName);
        List<SourceElement> selectedElements = SourcePath.getElements(currentElement, detokenizedElementToTraverseName);
        if (!this.acceptEmpty && selectedElements.isEmpty()) {
            throw new GeneratorException("TraverseAllAction : selected element " + this.elementsToTraverseName + " does not exist and acceptEmpty was set to false");
        }
        ArrayList<OutletResult> resultList = new ArrayList<OutletResult>(selectedElements.size());
        for (SourceElement sourceElement : selectedElements) {
            controllerState.setSourceElement(sourceElement);
            outlet.beforeExecute(controllerState);
            resultList.add(outlet.execute(controllerState));
            outlet.afterExecute(controllerState);
        }
        controllerState.setSourceElement(currentElement);
        if (resultList.isEmpty()) {
            return new OutletResult("");
        }
        return OutletResult.concatenate(resultList);
    }

    public String toString() {
        return "(TraverseAllAction: element = " + this.elementsToTraverseName + ", outlet = " + this.outletName + ", acceptEmpty = " + this.acceptEmpty + ")";
    }

    public int hashCode() {
        int prime = 31;
        int secondPrime = 1231;
        int thirdPrime = 1237;
        int result = 1;
        result = 31 * result + (this.acceptEmpty ? 1231 : 1237);
        result = 31 * result + this.elementsToTraverseName.hashCode();
        result = 31 * result + this.outletName.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TraverseAllAction other = (TraverseAllAction)obj;
        if (this.acceptEmpty != other.acceptEmpty) {
            return false;
        }
        if (!this.elementsToTraverseName.equals(other.elementsToTraverseName)) {
            return false;
        }
        return this.outletName.equals(other.outletName);
    }
}

