/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.component.token;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.render.FacesRenderer;
import jakarta.faces.render.Renderer;
import java.io.IOException;
import java.lang.annotation.Annotation;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.jsf.impl.token.PostRequestTokenManager;

@FacesRenderer(componentFamily="jakarta.faces.Input", rendererType="org.apache.deltaspike.PostRequestTokenHolder")
public class RequestTokenHtmlRenderer
extends Renderer {
    private static final String INPUT_ELEMENT = "input";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String INPUT_TYPE_HIDDEN = "hidden";
    private static final String ID_ATTRIBUTE = "id";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String VALUE_ATTRIBUTE = "value";
    private volatile PostRequestTokenManager postRequestTokenManager;

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement(INPUT_ELEMENT, component);
        writer.writeAttribute(TYPE_ATTRIBUTE, (Object)INPUT_TYPE_HIDDEN, null);
        String clientId = component.getClientId(facesContext);
        writer.writeAttribute(ID_ATTRIBUTE, (Object)clientId, null);
        writer.writeAttribute(NAME_ATTRIBUTE, (Object)clientId, null);
        String currentPostRequestToken = this.getPostRequestTokenManager().getCurrentToken();
        if (currentPostRequestToken != null) {
            writer.writeAttribute(VALUE_ATTRIBUTE, (Object)currentPostRequestToken, VALUE_ATTRIBUTE);
        }
        writer.endElement(INPUT_ELEMENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PostRequestTokenManager getPostRequestTokenManager() {
        if (this.postRequestTokenManager == null) {
            RequestTokenHtmlRenderer requestTokenHtmlRenderer = this;
            synchronized (requestTokenHtmlRenderer) {
                if (this.postRequestTokenManager == null) {
                    this.postRequestTokenManager = (PostRequestTokenManager)BeanProvider.getContextualReference(PostRequestTokenManager.class, (Annotation[])new Annotation[0]);
                }
            }
        }
        return this.postRequestTokenManager;
    }
}

