/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import java.util.concurrent.TimeUnit;
import org.apache.directory.api.ldap.model.cursor.ClosureMonitor;
import org.apache.directory.api.ldap.model.cursor.CursorClosedException;
import org.apache.directory.api.ldap.model.exception.LdapTimeLimitExceededException;
import org.apache.directory.server.i18n.I18n;

public class SearchTimeLimitingMonitor
implements ClosureMonitor {
    private final long startTime = System.currentTimeMillis();
    private final long millisToLive;
    private boolean closed;
    private Exception cause;

    public SearchTimeLimitingMonitor(long timeToLive, TimeUnit unit) {
        switch (unit) {
            case MICROSECONDS: {
                this.millisToLive = timeToLive / 1000L;
                break;
            }
            case MILLISECONDS: {
                this.millisToLive = timeToLive;
                break;
            }
            case SECONDS: {
                this.millisToLive = timeToLive * 1000L;
                break;
            }
            default: {
                throw new IllegalStateException(I18n.err(I18n.ERR_687, new Object[]{unit}));
            }
        }
    }

    @Override
    public void checkNotClosed() throws CursorClosedException {
        if (System.currentTimeMillis() > this.startTime + this.millisToLive && !this.closed) {
            this.cause = new LdapTimeLimitExceededException();
            this.closed = true;
        }
        if (this.closed) {
            throw new CursorClosedException(this.cause.getMessage(), this.cause);
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.cause = new CursorClosedException();
            this.closed = true;
        }
    }

    @Override
    public void close(String cause) {
        if (!this.closed) {
            this.cause = new CursorClosedException(cause);
            this.closed = true;
        }
    }

    @Override
    public void close(Exception cause) {
        if (!this.closed) {
            this.cause = cause;
            this.closed = true;
        }
    }

    @Override
    public Exception getCause() {
        return this.cause;
    }

    @Override
    public boolean isClosed() {
        if (System.currentTimeMillis() > this.startTime + this.millisToLive) {
            this.cause = new LdapTimeLimitExceededException();
            this.closed = true;
        }
        return this.closed;
    }
}

