/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.comparators;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.PrepareString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegerComparator
extends LdapComparator<Object>
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(IntegerComparator.class);

    public IntegerComparator(String oid) {
        super(oid);
    }

    @Override
    public int compare(Object v1, Object v2) {
        if (v1 instanceof String) {
            return this.compare((String)v1, (String)v2);
        }
        return this.compare((Long)v1, (Long)v2);
    }

    @Override
    private int compare(Long backendValue, Long assertValue) {
        LOG.debug("comparing Integer objects '{}' with '{}'", (Object)backendValue, (Object)assertValue);
        if (backendValue == assertValue) {
            return 0;
        }
        if (backendValue == null || assertValue == null) {
            return backendValue == null ? -1 : 1;
        }
        return backendValue.compareTo(assertValue);
    }

    @Override
    private int compare(String backendValue, String assertValue) {
        LOG.debug("comparing Integer objects '{}' with '{}'", (Object)backendValue, (Object)assertValue);
        if (backendValue == assertValue) {
            return 0;
        }
        if (backendValue == null || assertValue == null) {
            return backendValue == null ? -1 : 1;
        }
        try {
            backendValue = PrepareString.normalize(backendValue, PrepareString.StringType.NUMERIC_STRING);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_04224, (Object[])new Object[]{backendValue}), ioe);
        }
        try {
            assertValue = PrepareString.normalize(assertValue, PrepareString.StringType.NUMERIC_STRING);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_04224, (Object[])new Object[]{assertValue}), ioe);
        }
        BigInteger b1 = new BigInteger(backendValue);
        BigInteger b2 = new BigInteger(assertValue);
        return b1.compareTo(b2);
    }
}

