/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core;

import org.apache.commons.lang.StringUtils;
import org.apache.directory.fortress.core.AuditMgr;
import org.apache.directory.fortress.core.Manageable;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.AuditMgrImpl;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.rest.AuditMgrRestImpl;
import org.apache.directory.fortress.core.util.ClassUtil;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.VUtil;

public final class AuditMgrFactory {
    private static final String CLS_NM = AuditMgrFactory.class.getName();

    public static AuditMgr createInstance() throws SecurityException {
        return AuditMgrFactory.createInstance("HOME");
    }

    public static AuditMgr createInstance(String contextId) throws SecurityException {
        VUtil.assertNotNull(contextId, 101, CLS_NM + ".createInstance");
        String auditClassName = Config.getInstance().getProperty("auditmgr.implementation");
        Manageable auditMgr = StringUtils.isEmpty((String)auditClassName) ? (Config.getInstance().isRestEnabled() ? new AuditMgrRestImpl() : new AuditMgrImpl()) : (AuditMgr)ClassUtil.createInstance(auditClassName);
        auditMgr.setContextId(contextId);
        return auditMgr;
    }

    public static AuditMgr createInstance(Session adminSess) throws SecurityException {
        return AuditMgrFactory.createInstance("HOME", adminSess);
    }

    public static AuditMgr createInstance(String contextId, Session adminSess) throws SecurityException {
        AuditMgr auditMgr = AuditMgrFactory.createInstance(contextId);
        auditMgr.setAdmin(adminSess);
        return auditMgr;
    }
}

