/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;

public final class BooleanSyntaxChecker
extends SyntaxChecker {
    public static final BooleanSyntaxChecker INSTANCE = new BooleanSyntaxChecker("1.3.6.1.4.1.1466.115.121.1.7");

    private BooleanSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        boolean valid;
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_13210_SYNTAX_INVALID, (Object[])new Object[]{"null"}));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        if (strValue.length() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_13210_SYNTAX_INVALID, (Object[])new Object[]{strValue}));
            }
            return false;
        }
        boolean bl = valid = "TRUE".equalsIgnoreCase(strValue) || "FALSE".equalsIgnoreCase(strValue);
        if (LOG.isDebugEnabled()) {
            if (valid) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_13701_SYNTAX_VALID, (Object[])new Object[]{strValue}));
            } else {
                LOG.debug(I18n.err((I18n)I18n.ERR_13210_SYNTAX_INVALID, (Object[])new Object[]{strValue}));
            }
        }
        return valid;
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<BooleanSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.1466.115.121.1.7");
        }

        @Override
        public BooleanSyntaxChecker build() {
            return new BooleanSyntaxChecker(this.oid);
        }
    }
}

