/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.utils.core.plugins.finaliser.ni;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.felix.atomos.utils.api.Context;
import org.apache.felix.atomos.utils.api.FileType;
import org.apache.felix.atomos.utils.api.plugin.FinalPlugin;
import org.apache.felix.atomos.utils.core.plugins.finaliser.ni.NativeImageBuilderConfig;
import org.apache.felix.atomos.utils.substrate.api.NativeImageArguments;
import org.apache.felix.atomos.utils.substrate.api.NativeImageCli;
import org.apache.felix.atomos.utils.substrate.api.NativeImageConfigJsonProvider;
import org.apache.felix.atomos.utils.substrate.api.dynproxy.DynamicProxyConfiguration;
import org.apache.felix.atomos.utils.substrate.api.reflect.ReflectionConfiguration;
import org.apache.felix.atomos.utils.substrate.api.resource.ResourceConfiguration;

public class NativeImagePlugin
implements FinalPlugin<NativeImageBuilderConfig> {
    private NativeImageBuilderConfig config;

    public void doFinal(Context context) {
        try {
            Path native_image_build = this.config.nativeImageOutputDirectory().resolve("native_image_build");
            Files.createDirectories(native_image_build, new FileAttribute[0]);
            Path cpDir = native_image_build.resolve("cp");
            Files.createDirectories(cpDir, new FileAttribute[0]);
            Path cfgDir = native_image_build.resolve("cfg");
            Files.createDirectories(cfgDir, new FileAttribute[0]);
            Path binDir = native_image_build.resolve("bin");
            Files.createDirectories(binDir, new FileAttribute[0]);
            List<Path> classpath = context.getFiles(new FileType[]{FileType.ARTIFACT, FileType.INDEX_JAR}).collect(Collectors.toList());
            System.out.println(native_image_build);
            ArrayList copyOfClassPath = new ArrayList();
            classpath.forEach(p -> {
                try {
                    Path newPath = Files.copy(p, cpDir.resolve(p.getFileName()), new CopyOption[0]);
                    copyOfClassPath.add(newPath);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            DynamicProxyConfiguration dynPrC = context.getDynamicProxyConfig();
            String sDynPrC = NativeImageConfigJsonProvider.newInstance().json(dynPrC);
            Path pDynPrC = Files.write(cfgDir.resolve("DynamicProxyConfig.json"), sDynPrC.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            ReflectionConfiguration refCs = context.getReflectConfig();
            String sRefCs = NativeImageConfigJsonProvider.newInstance().json(refCs);
            Path pRefCs = Files.write(cfgDir.resolve("graal_reflect_config.json"), sRefCs.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            ResourceConfiguration resC = context.getResourceConfig();
            String sResC = NativeImageConfigJsonProvider.newInstance().json(resC);
            Path pResC = Files.write(cfgDir.resolve("graal_resource_config.json"), sResC.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            NativeImageArguments arguments = NativeImageArguments.builder().imageName(this.config.nativeImageApplicationName()).allowIncompleteClasspath(true).classPathFiles(Optional.ofNullable(copyOfClassPath)).debugAttach(false).dynamicProxyConfigurationFile(Optional.of(pDynPrC)).dynamicProxyConfigurationFiles(Optional.of(this.config.dynamicProxyConfigurationFiles())).initializeAtBuildTimePackages(Optional.of(resC.getResourcePackages())).initializeAtBuildTimePackages(Optional.ofNullable(this.config.nativeImageAdditionalInitializeAtBuildTime())).mainClass(this.config.nativeImageMainClass()).noFallback(Optional.ofNullable(this.config.noFallback()).orElse(true).booleanValue()).reflectionConfigurationFile(Optional.of(pRefCs)).reflectionConfigurationFiles(Optional.of(this.config.reflectionConfigurationFiles())).reportExceptionStackTraces(true).reportUnsupportedElementsAtRuntime(true).resourceConfigurationFile(Optional.of(pResC)).resourceConfigurationFiles(Optional.of(this.config.resourceConfigurationFiles())).vmFlags(Optional.ofNullable(this.config.nativeImageVmFlags())).vmSystemProperties(Optional.ofNullable(this.config.nativeImageVmSystemProperties())).printClassInitialization(true).build();
            Optional nOptional = NativeImageCli.newInstanceFindNativeImageExecutable((Path)this.config.nativeImageExecutable());
            nOptional.ifPresent(cli -> {
                try {
                    Path binFile = cli.execute(binDir, arguments);
                    context.addFile(binFile, FileType.NATIVE_IMAGE_BINARY);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void init(NativeImageBuilderConfig config) {
        this.config = config;
    }
}

