/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.abc.graph.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.flex.abc.graph.IBasicBlock;
import org.apache.flex.abc.graph.algorithms.DepthFirstPreorderIterator;

public class DominatorTree {
    private Map<IBasicBlock, Integer> semi = new HashMap<IBasicBlock, Integer>();
    private Map<IBasicBlock, IBasicBlock> parent = new HashMap<IBasicBlock, IBasicBlock>();
    private Multimap<IBasicBlock> pred = new Multimap();
    private ArrayList<IBasicBlock> vertex = new ArrayList();
    private Multimap<IBasicBlock> bucket = new Multimap();
    private Map<IBasicBlock, IBasicBlock> idom = new HashMap<IBasicBlock, IBasicBlock>();
    private Multimap<IBasicBlock> dominanceFrontiers = null;
    private Multimap<IBasicBlock> dominatorTree = null;
    private Map<IBasicBlock, IBasicBlock> ancestor = new HashMap<IBasicBlock, IBasicBlock>();
    private Map<IBasicBlock, IBasicBlock> label = new HashMap<IBasicBlock, IBasicBlock>();
    private LinkedList<IBasicBlock> topologicalTraversalImpl = null;

    public DominatorTree(IBasicBlock root) {
        ArrayList<IBasicBlock> roots = new ArrayList<IBasicBlock>();
        roots.add(root);
        this.dfs(roots);
        this.computeDominators();
    }

    public DominatorTree(Collection<? extends IBasicBlock> roots) {
        this.dfs(roots);
        this.computeDominators();
    }

    public Map<IBasicBlock, IBasicBlock> getIdoms() {
        return this.idom;
    }

    public Multimap<IBasicBlock> getDominatorTree() {
        if (this.dominatorTree == null) {
            this.dominatorTree = new Multimap();
            for (IBasicBlock node : this.idom.keySet()) {
                this.dominatorTree.get(this.idom.get(node)).add(node);
            }
        }
        return this.dominatorTree;
    }

    public Multimap<IBasicBlock> getDominanceFrontiers() {
        if (this.dominanceFrontiers == null) {
            this.dominanceFrontiers = new Multimap();
            this.getDominatorTree();
            for (IBasicBlock x : this.reverseTopologicalTraversal()) {
                Object dfx = this.dominanceFrontiers.get(x);
                for (IBasicBlock iBasicBlock : x.getSuccessors()) {
                    if (this.idom.get(iBasicBlock) == x) continue;
                    dfx.add(iBasicBlock);
                }
                Iterator<IBasicBlock> iterator = this.dominatorTree.get(x).iterator();
                while (iterator.hasNext()) {
                    IBasicBlock iBasicBlock = iterator.next();
                    Iterator iterator2 = this.dominanceFrontiers.get(iBasicBlock).iterator();
                    while (iterator2.hasNext()) {
                        IBasicBlock y = (IBasicBlock)iterator2.next();
                        if (this.idom.get(y) == x) continue;
                        dfx.add(y);
                    }
                }
            }
        }
        return this.dominanceFrontiers;
    }

    public List<IBasicBlock> topologicalTraversal() {
        return Collections.unmodifiableList(this.getToplogicalTraversalImplementation());
    }

    public Iterable<IBasicBlock> reverseTopologicalTraversal() {
        return new Iterable<IBasicBlock>(){

            @Override
            public Iterator<IBasicBlock> iterator() {
                return DominatorTree.this.getToplogicalTraversalImplementation().descendingIterator();
            }
        };
    }

    private void dfs(Collection<? extends IBasicBlock> roots) {
        DepthFirstPreorderIterator it = new DepthFirstPreorderIterator(roots);
        while (it.hasNext()) {
            IBasicBlock node = (IBasicBlock)it.next();
            if (this.semi.containsKey(node)) continue;
            this.vertex.add(node);
            this.semi.put(node, this.semi.size());
            this.label.put(node, node);
            for (IBasicBlock iBasicBlock : node.getSuccessors()) {
                this.pred.get(iBasicBlock).add(node);
                if (this.semi.containsKey(iBasicBlock)) continue;
                this.parent.put(iBasicBlock, node);
            }
        }
    }

    private void computeDominators() {
        IBasicBlock w;
        int lastSemiNumber;
        int i;
        for (i = lastSemiNumber = this.semi.size() - 1; i > 0; --i) {
            IBasicBlock v;
            w = this.vertex.get(i);
            IBasicBlock p = this.parent.get(w);
            int semidominator = this.semi.get(w);
            Iterator iterator = this.pred.get(w).iterator();
            while (iterator.hasNext()) {
                v = (IBasicBlock)iterator.next();
                semidominator = Math.min(semidominator, this.semi.get(this.eval(v)));
            }
            this.semi.put(w, semidominator);
            this.bucket.get(this.vertex.get(semidominator)).add(w);
            this.link(p, w);
            iterator = this.bucket.get(p).iterator();
            while (iterator.hasNext()) {
                v = (IBasicBlock)iterator.next();
                IBasicBlock u = this.eval(v);
                if (this.semi.get(u) < this.semi.get(v)) {
                    this.idom.put(v, u);
                    continue;
                }
                this.idom.put(v, p);
            }
            this.bucket.get(p).clear();
        }
        for (i = 1; i <= lastSemiNumber; ++i) {
            w = this.vertex.get(i);
            if (this.idom.get(w) == this.vertex.get(this.semi.get(w))) continue;
            this.idom.put(w, this.idom.get(this.idom.get(w)));
        }
    }

    private IBasicBlock eval(IBasicBlock v) {
        this.compress(v);
        return this.label.get(v);
    }

    private void compress(IBasicBlock v) {
        Stack<IBasicBlock> worklist = new Stack<IBasicBlock>();
        worklist.add(v);
        IBasicBlock a = this.ancestor.get(v);
        while (this.ancestor.containsKey(a)) {
            worklist.push(a);
            a = this.ancestor.get(a);
        }
        IBasicBlock ancestor = (IBasicBlock)worklist.pop();
        int leastSemi = this.semi.get(this.label.get(ancestor));
        while (!worklist.empty()) {
            IBasicBlock descendent = (IBasicBlock)worklist.pop();
            int currentSemi = this.semi.get(this.label.get(descendent));
            if (currentSemi > leastSemi) {
                this.label.put(descendent, this.label.get(ancestor));
            } else {
                leastSemi = currentSemi;
            }
            ancestor = descendent;
        }
    }

    private void link(IBasicBlock parent, IBasicBlock child) {
        this.ancestor.put(child, parent);
    }

    private LinkedList<IBasicBlock> getToplogicalTraversalImplementation() {
        if (this.topologicalTraversalImpl == null) {
            this.topologicalTraversalImpl = new LinkedList();
            for (IBasicBlock node : this.vertex) {
                int idx = this.topologicalTraversalImpl.indexOf(this.idom.get(node));
                if (idx != -1) {
                    this.topologicalTraversalImpl.add(idx + 1, node);
                    continue;
                }
                this.topologicalTraversalImpl.add(node);
            }
        }
        return this.topologicalTraversalImpl;
    }

    public static class Multimap<T>
    extends HashMap<T, Set<T>> {
        @Override
        public Set<T> get(Object key) {
            if (!this.containsKey(key)) {
                this.put(key, new HashSet());
            }
            return (Set)super.get(key);
        }
    }
}

