/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.sink;

import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.connector.sink.Committable;
import org.apache.flink.table.store.connector.sink.CommittableStateManager;
import org.apache.flink.table.store.connector.sink.Committer;
import org.apache.flink.table.store.connector.sink.FlinkSink;
import org.apache.flink.table.store.connector.sink.RestoreAndFailCommittableStateManager;
import org.apache.flink.table.store.connector.sink.StoreCommitter;
import org.apache.flink.table.store.connector.sink.StoreSinkWrite;
import org.apache.flink.table.store.connector.sink.StoreWriteOperator;
import org.apache.flink.table.store.file.manifest.ManifestCommittable;
import org.apache.flink.table.store.file.manifest.ManifestCommittableSerializer;
import org.apache.flink.table.store.file.operation.Lock;
import org.apache.flink.table.store.table.FileStoreTable;
import org.apache.flink.table.store.table.sink.LogSinkFunction;
import org.apache.flink.util.function.SerializableFunction;
import org.apache.flink.util.function.SerializableSupplier;

public class FileStoreSink
extends FlinkSink {
    private static final long serialVersionUID = 1L;
    private final Lock.Factory lockFactory;
    @Nullable
    private final Map<String, String> overwritePartition;
    @Nullable
    private final LogSinkFunction logSinkFunction;

    public FileStoreSink(FileStoreTable table, Lock.Factory lockFactory, @Nullable Map<String, String> overwritePartition, @Nullable LogSinkFunction logSinkFunction) {
        super(table, overwritePartition != null);
        this.lockFactory = lockFactory;
        this.overwritePartition = overwritePartition;
        this.logSinkFunction = logSinkFunction;
    }

    @Override
    protected OneInputStreamOperator<RowData, Committable> createWriteOperator(StoreSinkWrite.Provider writeProvider, boolean isStreaming) {
        return new StoreWriteOperator(this.table, this.logSinkFunction, writeProvider);
    }

    @Override
    protected SerializableFunction<String, Committer> createCommitterFactory(boolean streamingCheckpointEnabled) {
        return (SerializableFunction & Serializable)user -> new StoreCommitter(this.table.newCommit((String)user).withOverwritePartition(this.overwritePartition).withCreateEmptyCommit(streamingCheckpointEnabled).withLock(this.lockFactory.create()));
    }

    @Override
    protected CommittableStateManager createCommittableStateManager() {
        return new RestoreAndFailCommittableStateManager((SerializableSupplier<SimpleVersionedSerializer<ManifestCommittable>>)((SerializableSupplier & Serializable)ManifestCommittableSerializer::new));
    }
}

