/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.row;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.flink.table.data.DecimalDataUtils;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.utils.ParquetSchemaConverter;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.vector.reader.TimestampColumnReader;
import org.apache.flink.table.store.shaded.org.apache.parquet.io.api.Binary;
import org.apache.flink.table.store.shaded.org.apache.parquet.io.api.RecordConsumer;
import org.apache.flink.table.store.shaded.org.apache.parquet.schema.GroupType;
import org.apache.flink.table.store.shaded.org.apache.parquet.schema.Type;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.util.Preconditions;

public class ParquetRowDataWriter {
    private final RecordConsumer recordConsumer;
    private final boolean utcTimestamp;
    private final FieldWriter[] filedWriters;
    private final String[] fieldNames;

    public ParquetRowDataWriter(RecordConsumer recordConsumer, RowType rowType, GroupType schema, boolean utcTimestamp) {
        this.recordConsumer = recordConsumer;
        this.utcTimestamp = utcTimestamp;
        this.filedWriters = new FieldWriter[rowType.getFieldCount()];
        this.fieldNames = rowType.getFieldNames().toArray(new String[0]);
        for (int i = 0; i < rowType.getFieldCount(); ++i) {
            this.filedWriters[i] = this.createWriter(rowType.getTypeAt(i), schema.getType(i));
        }
    }

    public void write(RowData record) {
        this.recordConsumer.startMessage();
        for (int i = 0; i < this.filedWriters.length; ++i) {
            if (record.isNullAt(i)) continue;
            String fieldName = this.fieldNames[i];
            FieldWriter writer = this.filedWriters[i];
            this.recordConsumer.startField(fieldName, i);
            writer.write(record, i);
            this.recordConsumer.endField(fieldName, i);
        }
        this.recordConsumer.endMessage();
    }

    private FieldWriter createWriter(LogicalType t, Type type) {
        if (type.isPrimitive()) {
            switch (t.getTypeRoot()) {
                case CHAR: 
                case VARCHAR: {
                    return new StringWriter();
                }
                case BOOLEAN: {
                    return new BooleanWriter();
                }
                case BINARY: 
                case VARBINARY: {
                    return new BinaryWriter();
                }
                case DECIMAL: {
                    DecimalType decimalType = (DecimalType)t;
                    return this.createDecimalWriter(decimalType.getPrecision(), decimalType.getScale());
                }
                case TINYINT: {
                    return new ByteWriter();
                }
                case SMALLINT: {
                    return new ShortWriter();
                }
                case DATE: 
                case TIME_WITHOUT_TIME_ZONE: 
                case INTEGER: {
                    return new IntWriter();
                }
                case BIGINT: {
                    return new LongWriter();
                }
                case FLOAT: {
                    return new FloatWriter();
                }
                case DOUBLE: {
                    return new DoubleWriter();
                }
                case TIMESTAMP_WITHOUT_TIME_ZONE: {
                    TimestampType timestampType = (TimestampType)t;
                    return new TimestampWriter(timestampType.getPrecision());
                }
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                    LocalZonedTimestampType localZonedTimestampType = (LocalZonedTimestampType)t;
                    return new TimestampWriter(localZonedTimestampType.getPrecision());
                }
            }
            throw new UnsupportedOperationException("Unsupported type: " + type);
        }
        throw new IllegalArgumentException("Unsupported  data type: " + t);
    }

    private Binary timestampToInt96(TimestampData timestampData) {
        long nanosOfDay;
        int julianDay;
        if (this.utcTimestamp) {
            long mills = timestampData.getMillisecond();
            julianDay = (int)(mills / TimestampColumnReader.MILLIS_IN_DAY + 2440588L);
            nanosOfDay = mills % TimestampColumnReader.MILLIS_IN_DAY * TimestampColumnReader.NANOS_PER_MILLISECOND + (long)timestampData.getNanoOfMillisecond();
        } else {
            Timestamp timestamp = timestampData.toTimestamp();
            long mills = timestamp.getTime();
            julianDay = (int)(mills / TimestampColumnReader.MILLIS_IN_DAY + 2440588L);
            nanosOfDay = mills % TimestampColumnReader.MILLIS_IN_DAY / 1000L * TimestampColumnReader.NANOS_PER_SECOND + (long)timestamp.getNanos();
        }
        ByteBuffer buf = ByteBuffer.allocate(12);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putLong(nanosOfDay);
        buf.putInt(julianDay);
        buf.flip();
        return Binary.fromConstantByteBuffer(buf);
    }

    private FieldWriter createDecimalWriter(final int precision, final int scale) {
        Preconditions.checkArgument((precision <= 38 ? 1 : 0) != 0, (String)"Decimal precision %s exceeds max precision %s", (Object[])new Object[]{precision, 38});
        if (DecimalDataUtils.is32BitDecimal((int)precision) || DecimalDataUtils.is64BitDecimal((int)precision)) {
            class LongUnscaledBytesWriter
            implements FieldWriter {
                private final int numBytes;
                private final int initShift;
                private final byte[] decimalBuffer;

                LongUnscaledBytesWriter() {
                    this.numBytes = ParquetSchemaConverter.computeMinBytesForDecimalPrecision(precision);
                    this.initShift = 8 * (this.numBytes - 1);
                    this.decimalBuffer = new byte[this.numBytes];
                }

                @Override
                public void write(RowData row, int ordinal) {
                    long unscaledLong = row.getDecimal(ordinal, precision, scale).toUnscaledLong();
                    int i = 0;
                    int shift = this.initShift;
                    while (i < this.numBytes) {
                        this.decimalBuffer[i] = (byte)(unscaledLong >> shift);
                        ++i;
                        shift -= 8;
                    }
                    ParquetRowDataWriter.this.recordConsumer.addBinary(Binary.fromReusedByteArray(this.decimalBuffer, 0, this.numBytes));
                }
            }
            return new LongUnscaledBytesWriter();
        }
        class UnscaledBytesWriter
        implements FieldWriter {
            private final int numBytes;
            private final byte[] decimalBuffer;

            UnscaledBytesWriter() {
                this.numBytes = ParquetSchemaConverter.computeMinBytesForDecimalPrecision(precision);
                this.decimalBuffer = new byte[this.numBytes];
            }

            @Override
            public void write(RowData row, int ordinal) {
                byte[] writtenBytes;
                byte[] bytes = row.getDecimal(ordinal, precision, scale).toUnscaledBytes();
                if (bytes.length == this.numBytes) {
                    writtenBytes = bytes;
                } else {
                    byte signByte = bytes[0] < 0 ? (byte)-1 : 0;
                    Arrays.fill(this.decimalBuffer, 0, this.numBytes - bytes.length, signByte);
                    System.arraycopy(bytes, 0, this.decimalBuffer, this.numBytes - bytes.length, bytes.length);
                    writtenBytes = this.decimalBuffer;
                }
                ParquetRowDataWriter.this.recordConsumer.addBinary(Binary.fromReusedByteArray(writtenBytes, 0, this.numBytes));
            }
        }
        return new UnscaledBytesWriter();
    }

    private class TimestampWriter
    implements FieldWriter {
        private final int precision;

        private TimestampWriter(int precision) {
            this.precision = precision;
        }

        @Override
        public void write(RowData row, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addBinary(ParquetRowDataWriter.this.timestampToInt96(row.getTimestamp(ordinal, this.precision)));
        }
    }

    private class IntWriter
    implements FieldWriter {
        private IntWriter() {
        }

        @Override
        public void write(RowData row, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addInteger(row.getInt(ordinal));
        }
    }

    private class BinaryWriter
    implements FieldWriter {
        private BinaryWriter() {
        }

        @Override
        public void write(RowData row, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addBinary(Binary.fromReusedByteArray(row.getBinary(ordinal)));
        }
    }

    private class StringWriter
    implements FieldWriter {
        private StringWriter() {
        }

        @Override
        public void write(RowData row, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addBinary(Binary.fromReusedByteArray(row.getString(ordinal).toBytes()));
        }
    }

    private class DoubleWriter
    implements FieldWriter {
        private DoubleWriter() {
        }

        @Override
        public void write(RowData row, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addDouble(row.getDouble(ordinal));
        }
    }

    private class FloatWriter
    implements FieldWriter {
        private FloatWriter() {
        }

        @Override
        public void write(RowData row, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addFloat(row.getFloat(ordinal));
        }
    }

    private class LongWriter
    implements FieldWriter {
        private LongWriter() {
        }

        @Override
        public void write(RowData row, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addLong(row.getLong(ordinal));
        }
    }

    private class ShortWriter
    implements FieldWriter {
        private ShortWriter() {
        }

        @Override
        public void write(RowData row, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addInteger(row.getShort(ordinal));
        }
    }

    private class ByteWriter
    implements FieldWriter {
        private ByteWriter() {
        }

        @Override
        public void write(RowData row, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addInteger(row.getByte(ordinal));
        }
    }

    private class BooleanWriter
    implements FieldWriter {
        private BooleanWriter() {
        }

        @Override
        public void write(RowData row, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addBoolean(row.getBoolean(ordinal));
        }
    }

    private static interface FieldWriter {
        public void write(RowData var1, int var2);
    }
}

