/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.blob.BlobWriter;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptorFactory;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.EdgeManager;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionDeploymentListener;
import org.apache.flink.runtime.executiongraph.ExecutionGraphID;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.executiongraph.JobInformation;
import org.apache.flink.runtime.executiongraph.failover.flip1.partitionrelease.PartitionGroupReleaseStrategy;
import org.apache.flink.runtime.io.network.partition.JobMasterPartitionTracker;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleMaster;
import org.apache.flink.types.Either;
import org.apache.flink.util.SerializedValue;

public interface InternalExecutionGraphAccessor {
    public ClassLoader getUserClassLoader();

    public JobID getJobID();

    public BlobWriter getBlobWriter();

    public Either<SerializedValue<JobInformation>, PermanentBlobKey> getJobInformationOrBlobKey();

    public TaskDeploymentDescriptorFactory.PartitionLocationConstraint getPartitionLocationConstraint();

    public Executor getFutureExecutor();

    @Nonnull
    public ComponentMainThreadExecutor getJobMasterMainThreadExecutor();

    public ShuffleMaster<? extends ShuffleDescriptor> getShuffleMaster();

    public JobMasterPartitionTracker getPartitionTracker();

    public void registerExecution(Execution var1);

    public void deregisterExecution(Execution var1);

    public PartitionGroupReleaseStrategy getPartitionGroupReleaseStrategy();

    public void jobVertexFinished();

    public void jobVertexUnFinished();

    public ExecutionDeploymentListener getExecutionDeploymentListener();

    public void failGlobal(Throwable var1);

    public void notifyExecutionChange(Execution var1, ExecutionState var2, ExecutionState var3);

    public void notifySchedulerNgAboutInternalTaskFailure(ExecutionAttemptID var1, Throwable var2, boolean var3, boolean var4);

    public EdgeManager getEdgeManager();

    public ExecutionVertex getExecutionVertexOrThrow(ExecutionVertexID var1);

    public IntermediateResultPartition getResultPartitionOrThrow(IntermediateResultPartitionID var1);

    public void deleteBlobs(List<PermanentBlobKey> var1);

    public ExecutionJobVertex getJobVertex(JobVertexID var1);

    public boolean isDynamic();

    public ExecutionGraphID getExecutionGraphID();

    public List<ShuffleDescriptor> getClusterPartitionShuffleDescriptors(IntermediateDataSetID var1);
}

