/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.io.File;
import java.time.Duration;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.configuration.UnmodifiableConfiguration;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.registration.RetryingRegistrationConfiguration;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceSpec;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceUtils;
import org.apache.flink.runtime.taskmanager.TaskManagerRuntimeInfo;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManagerConfiguration
implements TaskManagerRuntimeInfo {
    private static final Logger LOG = LoggerFactory.getLogger(TaskManagerConfiguration.class);
    private final int numberSlots;
    private final ResourceProfile defaultSlotResourceProfile;
    private final ResourceProfile totalResourceProfile;
    private final String[] tmpDirectories;
    private final Time rpcTimeout;
    private final Time slotTimeout;
    @Nullable
    private final Duration maxRegistrationDuration;
    private final UnmodifiableConfiguration configuration;
    private final boolean exitJvmOnOutOfMemory;
    @Nullable
    private final String taskManagerLogPath;
    @Nullable
    private final String taskManagerStdoutPath;
    @Nullable
    private final String taskManagerLogDir;
    private final String taskManagerExternalAddress;
    private final File tmpWorkingDirectory;
    private final RetryingRegistrationConfiguration retryingRegistrationConfiguration;

    public TaskManagerConfiguration(int numberSlots, ResourceProfile defaultSlotResourceProfile, ResourceProfile totalResourceProfile, String[] tmpDirectories, Time rpcTimeout, Time slotTimeout, @Nullable Duration maxRegistrationDuration, Configuration configuration, boolean exitJvmOnOutOfMemory, @Nullable String taskManagerLogPath, @Nullable String taskManagerStdoutPath, @Nullable String taskManagerLogDir, String taskManagerExternalAddress, File tmpWorkingDirectory, RetryingRegistrationConfiguration retryingRegistrationConfiguration) {
        this.numberSlots = numberSlots;
        this.defaultSlotResourceProfile = defaultSlotResourceProfile;
        this.totalResourceProfile = totalResourceProfile;
        this.tmpDirectories = Preconditions.checkNotNull(tmpDirectories);
        this.rpcTimeout = Preconditions.checkNotNull(rpcTimeout);
        this.slotTimeout = Preconditions.checkNotNull(slotTimeout);
        this.maxRegistrationDuration = maxRegistrationDuration;
        this.configuration = new UnmodifiableConfiguration(Preconditions.checkNotNull(configuration));
        this.exitJvmOnOutOfMemory = exitJvmOnOutOfMemory;
        this.taskManagerLogPath = taskManagerLogPath;
        this.taskManagerStdoutPath = taskManagerStdoutPath;
        this.taskManagerLogDir = taskManagerLogDir;
        this.taskManagerExternalAddress = taskManagerExternalAddress;
        this.tmpWorkingDirectory = tmpWorkingDirectory;
        this.retryingRegistrationConfiguration = retryingRegistrationConfiguration;
    }

    public int getNumberSlots() {
        return this.numberSlots;
    }

    public ResourceProfile getDefaultSlotResourceProfile() {
        return this.defaultSlotResourceProfile;
    }

    public ResourceProfile getTotalResourceProfile() {
        return this.totalResourceProfile;
    }

    public Time getRpcTimeout() {
        return this.rpcTimeout;
    }

    public Time getSlotTimeout() {
        return this.slotTimeout;
    }

    @Nullable
    public Duration getMaxRegistrationDuration() {
        return this.maxRegistrationDuration;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public String[] getTmpDirectories() {
        return this.tmpDirectories;
    }

    @Override
    public boolean shouldExitJvmOnOutOfMemoryError() {
        return this.exitJvmOnOutOfMemory;
    }

    @Nullable
    public String getTaskManagerLogPath() {
        return this.taskManagerLogPath;
    }

    @Nullable
    public String getTaskManagerStdoutPath() {
        return this.taskManagerStdoutPath;
    }

    @Nullable
    public String getTaskManagerLogDir() {
        return this.taskManagerLogDir;
    }

    @Override
    public String getTaskManagerExternalAddress() {
        return this.taskManagerExternalAddress;
    }

    @Override
    public File getTmpWorkingDirectory() {
        return this.tmpWorkingDirectory;
    }

    public RetryingRegistrationConfiguration getRetryingRegistrationConfiguration() {
        return this.retryingRegistrationConfiguration;
    }

    public static TaskManagerConfiguration fromConfiguration(Configuration configuration, TaskExecutorResourceSpec taskExecutorResourceSpec, String externalAddress, File tmpWorkingDirectory) {
        String taskManagerStdoutPath;
        String taskManagerLogDir;
        Duration finiteRegistrationDuration;
        int numberSlots = configuration.getInteger(TaskManagerOptions.NUM_TASK_SLOTS, 1);
        if (numberSlots == -1) {
            numberSlots = 1;
        }
        String[] tmpDirPaths = ConfigurationUtils.parseTempDirectories(configuration);
        Time rpcTimeout = Time.fromDuration(configuration.get(AkkaOptions.ASK_TIMEOUT_DURATION));
        LOG.debug("Messages have a max timeout of " + rpcTimeout);
        Time slotTimeout = Time.milliseconds(configuration.get(TaskManagerOptions.SLOT_TIMEOUT).toMillis());
        try {
            finiteRegistrationDuration = configuration.get(TaskManagerOptions.REGISTRATION_TIMEOUT);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Invalid format for parameter {}. Set the timeout to be infinite.", (Object)TaskManagerOptions.REGISTRATION_TIMEOUT.key());
            finiteRegistrationDuration = null;
        }
        boolean exitOnOom = configuration.getBoolean(TaskManagerOptions.KILL_ON_OUT_OF_MEMORY);
        String taskManagerLogPath = configuration.getString("taskmanager.log.path", System.getProperty("log.file"));
        if (taskManagerLogPath != null) {
            int extension = taskManagerLogPath.lastIndexOf(46);
            taskManagerLogDir = new File(taskManagerLogPath).getParent();
            taskManagerStdoutPath = extension > 0 ? taskManagerLogPath.substring(0, extension) + ".out" : null;
        } else {
            taskManagerStdoutPath = null;
            taskManagerLogDir = null;
        }
        RetryingRegistrationConfiguration retryingRegistrationConfiguration = RetryingRegistrationConfiguration.fromConfiguration(configuration);
        return new TaskManagerConfiguration(numberSlots, TaskExecutorResourceUtils.generateDefaultSlotResourceProfile(taskExecutorResourceSpec, numberSlots), TaskExecutorResourceUtils.generateTotalAvailableResourceProfile(taskExecutorResourceSpec), tmpDirPaths, rpcTimeout, slotTimeout, finiteRegistrationDuration, configuration, exitOnOom, taskManagerLogPath, taskManagerStdoutPath, taskManagerLogDir, externalAddress, tmpWorkingDirectory, retryingRegistrationConfiguration);
    }
}

