/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.mergetree.compact;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.KeyValue;
import org.apache.flink.table.store.file.compact.CompactResult;
import org.apache.flink.table.store.file.io.DataFileMeta;
import org.apache.flink.table.store.file.io.KeyValueFileReaderFactory;
import org.apache.flink.table.store.file.io.KeyValueFileWriterFactory;
import org.apache.flink.table.store.file.io.RollingFileWriter;
import org.apache.flink.table.store.file.mergetree.MergeTreeReaders;
import org.apache.flink.table.store.file.mergetree.SortedRun;
import org.apache.flink.table.store.file.mergetree.compact.ConcatRecordReader;
import org.apache.flink.table.store.file.mergetree.compact.FullChangelogMergeFunctionWrapper;
import org.apache.flink.table.store.file.mergetree.compact.MergeFunctionFactory;
import org.apache.flink.table.store.file.mergetree.compact.MergeTreeCompactRewriter;
import org.apache.flink.table.store.file.mergetree.compact.SortMergeReader;
import org.apache.flink.table.store.file.utils.RecordReader;
import org.apache.flink.table.store.file.utils.RecordReaderIterator;
import org.apache.flink.util.Preconditions;

public class FullChangelogMergeTreeCompactRewriter
extends MergeTreeCompactRewriter {
    private final int maxLevel;

    public FullChangelogMergeTreeCompactRewriter(int maxLevel, KeyValueFileReaderFactory readerFactory, KeyValueFileWriterFactory writerFactory, Comparator<RowData> keyComparator, MergeFunctionFactory<KeyValue> mfFactory) {
        super(readerFactory, writerFactory, keyComparator, mfFactory);
        this.maxLevel = maxLevel;
    }

    @Override
    public CompactResult rewrite(int outputLevel, boolean dropDelete, List<List<SortedRun>> sections) throws Exception {
        if (outputLevel == this.maxLevel) {
            Preconditions.checkArgument(dropDelete, "Delete records should be dropped from result of full compaction. This is unexpected.");
            return this.rewriteFullCompaction(sections);
        }
        return this.rewriteCompaction(outputLevel, dropDelete, sections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompactResult rewriteFullCompaction(List<List<SortedRun>> sections) throws Exception {
        ArrayList sectionReaders = new ArrayList();
        for (List<SortedRun> section : sections) {
            sectionReaders.add(() -> {
                ArrayList<RecordReader<KeyValue>> runReaders = new ArrayList<RecordReader<KeyValue>>();
                for (SortedRun run : section) {
                    runReaders.add(MergeTreeReaders.readerForRun(run, this.readerFactory));
                }
                return new SortMergeReader<FullChangelogMergeFunctionWrapper.Result>(runReaders, this.keyComparator, new FullChangelogMergeFunctionWrapper(this.mfFactory.create(), this.maxLevel));
            });
        }
        RecordReaderIterator iterator = null;
        RollingFileWriter<KeyValue, DataFileMeta> compactFileWriter = null;
        RollingFileWriter<KeyValue, DataFileMeta> changelogFileWriter = null;
        try {
            iterator = new RecordReaderIterator(ConcatRecordReader.create(sectionReaders));
            compactFileWriter = this.writerFactory.createRollingMergeTreeFileWriter(this.maxLevel);
            changelogFileWriter = this.writerFactory.createRollingChangelogFileWriter(this.maxLevel);
            while (iterator.hasNext()) {
                FullChangelogMergeFunctionWrapper.Result result = (FullChangelogMergeFunctionWrapper.Result)iterator.next();
                if (result.result() != null) {
                    compactFileWriter.write(result.result());
                }
                if (result.before() != null) {
                    changelogFileWriter.write(result.before());
                }
                if (result.after() == null) continue;
                changelogFileWriter.write(result.after());
            }
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
            if (compactFileWriter != null) {
                compactFileWriter.close();
            }
            if (changelogFileWriter != null) {
                changelogFileWriter.close();
            }
        }
        return new CompactResult(FullChangelogMergeTreeCompactRewriter.extractFilesFromSections(sections), (List<DataFileMeta>)compactFileWriter.result(), (List<DataFileMeta>)changelogFileWriter.result());
    }

    @Override
    public CompactResult upgrade(int outputLevel, DataFileMeta file) throws Exception {
        if (outputLevel == this.maxLevel) {
            return this.rewriteFullCompaction(Collections.singletonList(Collections.singletonList(SortedRun.fromSingle(file))));
        }
        return super.upgrade(outputLevel, file);
    }
}

