/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.hive.objectinspector;

import org.apache.flink.table.data.StringData;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class TableStoreCharObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements HiveCharObjectInspector {
    private final int len;

    public TableStoreCharObjectInspector(int len) {
        super((PrimitiveTypeInfo)TypeInfoFactory.getCharTypeInfo((int)len));
        this.len = len;
    }

    public HiveChar getPrimitiveJavaObject(Object o) {
        return o == null ? null : new HiveChar(o.toString(), this.len);
    }

    public HiveCharWritable getPrimitiveWritableObject(Object o) {
        HiveChar hiveChar = this.getPrimitiveJavaObject(o);
        return hiveChar == null ? null : new HiveCharWritable(hiveChar);
    }

    public Object copyObject(Object o) {
        if (o instanceof HiveChar) {
            HiveChar hiveChar = (HiveChar)o;
            return new HiveChar(hiveChar, this.len);
        }
        if (o instanceof StringData) {
            return StringData.fromString(o.toString());
        }
        return o;
    }
}

