/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.system;

import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.core.fs.Path;
import org.apache.flink.shaded.guava30.com.google.common.collect.Iterators;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.store.file.Snapshot;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.utils.IteratorRecordReader;
import org.apache.flink.table.store.file.utils.RecordReader;
import org.apache.flink.table.store.file.utils.SerializationUtils;
import org.apache.flink.table.store.file.utils.SnapshotManager;
import org.apache.flink.table.store.table.Table;
import org.apache.flink.table.store.table.source.Split;
import org.apache.flink.table.store.table.source.TableRead;
import org.apache.flink.table.store.table.source.TableScan;
import org.apache.flink.table.store.utils.ProjectedRowData;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;

public class SnapshotsTable
implements Table {
    private static final long serialVersionUID = 1L;
    public static final String SNAPSHOTS = "snapshots";
    public static final RowType TABLE_TYPE = new RowType(Arrays.asList(new RowType.RowField("snapshot_id", new BigIntType(false)), new RowType.RowField("schema_id", new BigIntType(false)), new RowType.RowField("commit_user", SerializationUtils.newStringType(false)), new RowType.RowField("commit_identifier", new BigIntType(false)), new RowType.RowField("commit_kind", SerializationUtils.newStringType(false)), new RowType.RowField("commit_time", new TimestampType(false, 3))));
    private final Path location;

    public SnapshotsTable(Path location) {
        this.location = location;
    }

    @Override
    public String name() {
        return this.location.getName() + "$" + SNAPSHOTS;
    }

    @Override
    public RowType rowType() {
        return TABLE_TYPE;
    }

    @Override
    public Path location() {
        return this.location;
    }

    @Override
    public TableScan newScan() {
        return new SnapshotsScan();
    }

    @Override
    public TableRead newRead() {
        return new SnapshotsRead();
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new SnapshotsTable(this.location);
    }

    private static class SnapshotsRead
    implements TableRead {
        private int[][] projection;

        private SnapshotsRead() {
        }

        @Override
        public TableRead withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public TableRead withProjection(int[][] projection) {
            this.projection = projection;
            return this;
        }

        @Override
        public RecordReader<RowData> createReader(Split split) throws IOException {
            if (!(split instanceof SnapshotsSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            Path location = ((SnapshotsSplit)split).location;
            Iterator<Snapshot> snapshots = new SnapshotManager(location).snapshots();
            Iterator rows = Iterators.transform(snapshots, this::toRow);
            if (this.projection != null) {
                rows = Iterators.transform(rows, row -> ProjectedRowData.from(this.projection).replaceRow((RowData)row));
            }
            return new IteratorRecordReader<RowData>(rows);
        }

        private RowData toRow(Snapshot snapshot) {
            return GenericRowData.of(snapshot.id(), snapshot.schemaId(), StringData.fromString(snapshot.commitUser()), snapshot.commitIdentifier(), StringData.fromString(snapshot.commitKind().toString()), TimestampData.fromLocalDateTime(LocalDateTime.ofInstant(Instant.ofEpochMilli(snapshot.timeMillis()), ZoneId.systemDefault())));
        }
    }

    private static class SnapshotsSplit
    implements Split {
        private static final long serialVersionUID = 1L;
        private final Path location;

        private SnapshotsSplit(Path location) {
            this.location = location;
        }

        @Override
        public long rowCount() {
            try {
                return new SnapshotManager(this.location).snapshotCount();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SnapshotsSplit that = (SnapshotsSplit)o;
            return Objects.equals(this.location, that.location);
        }

        public int hashCode() {
            return Objects.hash(this.location);
        }
    }

    private class SnapshotsScan
    implements TableScan {
        private SnapshotsScan() {
        }

        @Override
        public TableScan withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public TableScan.Plan plan() {
            return () -> Collections.singletonList(new SnapshotsSplit(SnapshotsTable.this.location));
        }
    }
}

