/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.ConfigGroup;
import org.apache.flink.annotation.docs.ConfigGroups;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.NettyShuffleEnvironmentOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.TextElement;
import org.apache.flink.util.TimeUtils;

@ConfigGroups(groups={@ConfigGroup(name="TaskManagerMemory", keyPrefix="taskmanager.memory")})
@PublicEvolving
public class TaskManagerOptions {
    @Deprecated
    public static final String MANAGED_MEMORY_CONSUMER_NAME_DATAPROC = "DATAPROC";
    public static final String MANAGED_MEMORY_CONSUMER_NAME_OPERATOR = "OPERATOR";
    public static final String MANAGED_MEMORY_CONSUMER_NAME_STATE_BACKEND = "STATE_BACKEND";
    public static final String MANAGED_MEMORY_CONSUMER_NAME_PYTHON = "PYTHON";
    @Deprecated
    public static final ConfigOption<MemorySize> TASK_MANAGER_HEAP_MEMORY = ConfigOptions.key("taskmanager.heap.size").memoryType().noDefaultValue().withDescription("JVM heap size for the TaskManagers, which are the parallel workers of the system. On YARN setups, this value is automatically configured to the size of the TaskManager's YARN container, minus a certain tolerance value.");
    @Deprecated
    public static final ConfigOption<Integer> TASK_MANAGER_HEAP_MEMORY_MB = ConfigOptions.key("taskmanager.heap.mb").intType().noDefaultValue().withDescription("JVM heap size (in megabytes) for the TaskManagers, which are the parallel workers of the system. On YARN setups, this value is automatically configured to the size of the TaskManager's YARN container, minus a certain tolerance value.");
    @Documentation.Section(value={"all_taskmanager"})
    public static final ConfigOption<Boolean> KILL_ON_OUT_OF_MEMORY = ConfigOptions.key("taskmanager.jvm-exit-on-oom").booleanType().defaultValue(false).withDescription("Whether to kill the TaskManager when the task thread throws an OutOfMemoryError.");
    @Deprecated
    public static final ConfigOption<Boolean> EXIT_ON_FATAL_AKKA_ERROR = ConfigOptions.key("taskmanager.exit-on-fatal-akka-error").booleanType().defaultValue(false).withDescription("Whether the quarantine monitor for task managers shall be started. The quarantine monitor shuts down the actor system if it detects that it has quarantined another actor system or if it has been quarantined by another actor system.");
    @Documentation.Section(value={"common_host_port", "all_taskmanager"})
    public static final ConfigOption<String> HOST = ConfigOptions.key("taskmanager.host").stringType().noDefaultValue().withDescription("The external address of the network interface where the TaskManager is exposed. Because different TaskManagers need different values for this option, usually it is specified in an additional non-shared TaskManager-specific config file.");
    public static final ConfigOption<String> BIND_HOST = ConfigOptions.key("taskmanager.bind-host").stringType().noDefaultValue().withDescription("The local address of the network interface that the task manager binds to. If not configured, '0.0.0.0' will be used.");
    @Documentation.Section(value={"common_host_port", "all_taskmanager"})
    public static final ConfigOption<String> RPC_PORT = ConfigOptions.key("taskmanager.rpc.port").stringType().defaultValue("0").withDescription("The external RPC port where the TaskManager is exposed. Accepts a list of ports (\u201c50100,50101\u201d), ranges (\u201c50100-50200\u201d) or a combination of both. It is recommended to set a range of ports to avoid collisions when multiple TaskManagers are running on the same machine.");
    public static final ConfigOption<Integer> RPC_BIND_PORT = ConfigOptions.key("taskmanager.rpc.bind-port").intType().noDefaultValue().withDescription("The local RPC port that the TaskManager binds to. If not configured, the external port (configured by '" + RPC_PORT.key() + "') will be used.");
    @Deprecated
    public static final ConfigOption<Duration> INITIAL_REGISTRATION_BACKOFF = ConfigOptions.key("taskmanager.registration.initial-backoff").durationType().defaultValue(TimeUtils.parseDuration("500 ms")).withDeprecatedKeys("taskmanager.initial-registration-pause").withDescription("The initial registration backoff between two consecutive registration attempts. The backoff is doubled for each new registration attempt until it reaches the maximum registration backoff.");
    @Deprecated
    public static final ConfigOption<Duration> REGISTRATION_MAX_BACKOFF = ConfigOptions.key("taskmanager.registration.max-backoff").durationType().defaultValue(TimeUtils.parseDuration("30 s")).withDeprecatedKeys("taskmanager.max-registration-pause").withDescription("The maximum registration backoff between two consecutive registration attempts. The max registration backoff requires a time unit specifier (ms/s/min/h/d).");
    @Deprecated
    public static final ConfigOption<Duration> REFUSED_REGISTRATION_BACKOFF = ConfigOptions.key("taskmanager.registration.refused-backoff").durationType().defaultValue(TimeUtils.parseDuration("10 s")).withDeprecatedKeys("taskmanager.refused-registration-pause").withDescription("The backoff after a registration has been refused by the job manager before retrying to connect.");
    @Documentation.Section(value={"all_taskmanager"})
    public static final ConfigOption<Duration> REGISTRATION_TIMEOUT = ConfigOptions.key("taskmanager.registration.timeout").durationType().defaultValue(TimeUtils.parseDuration("5 min")).withDeprecatedKeys("taskmanager.maxRegistrationDuration").withDescription("Defines the timeout for the TaskManager registration. If the duration is exceeded without a successful registration, then the TaskManager terminates.");
    @Documentation.Section(value={"all_taskmanager"})
    public static final ConfigOption<Integer> NUM_TASK_SLOTS = ConfigOptions.key("taskmanager.numberOfTaskSlots").intType().defaultValue(1).withDescription("The number of parallel operator or user function instances that a single TaskManager can run. If this value is larger than 1, a single TaskManager takes multiple instances of a function or operator. That way, the TaskManager can utilize multiple CPU cores, but at the same time, the available memory is divided between the different operator or function instances. This value is typically proportional to the number of physical CPU cores that the TaskManager's machine has (e.g., equal to the number of cores, or half the number of cores).");
    @Documentation.Section(value={"all_taskmanager"})
    public static final ConfigOption<Duration> SLOT_TIMEOUT = ConfigOptions.key("taskmanager.slot.timeout").durationType().defaultValue(AkkaOptions.ASK_TIMEOUT_DURATION.defaultValue()).withFallbackKeys(AkkaOptions.ASK_TIMEOUT_DURATION.key()).withDescription(Description.builder().text("Timeout used for identifying inactive slots. The TaskManager will free the slot if it does not become active within the given amount of time. Inactive slots can be caused by an out-dated slot request. If no value is configured, then it will fall back to %s.", TextElement.code(AkkaOptions.ASK_TIMEOUT_DURATION.key())).build());
    @Documentation.Section(value={"all_taskmanager"})
    public static final ConfigOption<Boolean> DEBUG_MEMORY_LOG = ConfigOptions.key("taskmanager.debug.memory.log").booleanType().defaultValue(false).withDeprecatedKeys("taskmanager.debug.memory.startLogThread").withDescription("Flag indicating whether to start a thread, which repeatedly logs the memory usage of the JVM.");
    @Documentation.Section(value={"all_taskmanager"})
    public static final ConfigOption<Long> DEBUG_MEMORY_USAGE_LOG_INTERVAL_MS = ConfigOptions.key("taskmanager.debug.memory.log-interval").longType().defaultValue(5000L).withDeprecatedKeys("taskmanager.debug.memory.logIntervalMs").withDescription("The interval (in ms) for the log thread to log the current memory usage.");
    @Documentation.Section(value={"all_taskmanager"})
    public static final ConfigOption<MemorySize> MEMORY_SEGMENT_SIZE = ConfigOptions.key("taskmanager.memory.segment-size").memoryType().defaultValue(MemorySize.parse("32kb")).withDescription("Size of memory buffers used by the network stack and the memory manager.");
    @Documentation.Section(value={"all_taskmanager"})
    public static final ConfigOption<MemorySize> MIN_MEMORY_SEGMENT_SIZE = ConfigOptions.key("taskmanager.memory.min-segment-size").memoryType().defaultValue(MemorySize.parse("256")).withDescription("Minimum possible size of memory buffers used by the network stack and the memory manager. ex. can be used for automatic buffer size adjustment.");
    @Documentation.Section(value={"all_taskmanager"})
    public static final ConfigOption<String> HOST_BIND_POLICY = ConfigOptions.key("taskmanager.network.bind-policy").stringType().defaultValue("ip").withDescription(Description.builder().text("The automatic address binding policy used by the TaskManager if \"" + HOST.key() + "\" is not set. The value should be one of the following:\n").list(TextElement.text("\"name\" - uses hostname as binding address"), TextElement.text("\"ip\" - uses host's ip address as binding address")).build());
    @Documentation.Section(value={"all_taskmanager"})
    public static final ConfigOption<String> TASK_MANAGER_RESOURCE_ID = ConfigOptions.key("taskmanager.resource-id").stringType().noDefaultValue().withDescription("The TaskManager's ResourceID. If not configured, the ResourceID will be generated with the \"RpcAddress:RpcPort\" and a 6-character random string. Notice that this option is not valid in Yarn and Native Kubernetes mode.");
    @Documentation.ExcludeFromDocumentation
    public static final ConfigOption<Double> CPU_CORES = ConfigOptions.key("taskmanager.cpu.cores").doubleType().noDefaultValue().withDescription("CPU cores for the TaskExecutors. In case of Yarn setups, this value will be rounded to the closest positive integer. If not explicitly configured, legacy config options 'yarn.containers.vcores' and 'kubernetes.taskmanager.cpu' will be used for Yarn / Kubernetes setups, and '" + NUM_TASK_SLOTS.key() + "' will be used for standalone setups (approximate number of slots).");
    @Documentation.Section(value={"common_memory"})
    public static final ConfigOption<MemorySize> TOTAL_PROCESS_MEMORY = ConfigOptions.key("taskmanager.memory.process.size").memoryType().noDefaultValue().withDescription("Total Process Memory size for the TaskExecutors. This includes all the memory that a TaskExecutor consumes, consisting of Total Flink Memory, JVM Metaspace, and JVM Overhead. On containerized setups, this should be set to the container memory. See also 'taskmanager.memory.flink.size' for total Flink memory size configuration.");
    @Documentation.Section(value={"common_memory"})
    public static final ConfigOption<MemorySize> TOTAL_FLINK_MEMORY = ConfigOptions.key("taskmanager.memory.flink.size").memoryType().noDefaultValue().withDescription(String.format("Total Flink Memory size for the TaskExecutors. This includes all the memory that a TaskExecutor consumes, except for JVM Metaspace and JVM Overhead. It consists of Framework Heap Memory, Task Heap Memory, Task Off-Heap Memory, Managed Memory, and Network Memory. See also '%s' for total process memory size configuration.", TOTAL_PROCESS_MEMORY.key()));
    @Documentation.Section(value={"common_memory"})
    public static final ConfigOption<MemorySize> FRAMEWORK_HEAP_MEMORY = ConfigOptions.key("taskmanager.memory.framework.heap.size").memoryType().defaultValue(MemorySize.parse("128m")).withDescription("Framework Heap Memory size for TaskExecutors. This is the size of JVM heap memory reserved for TaskExecutor framework, which will not be allocated to task slots.");
    @Documentation.Section(value={"common_memory"})
    public static final ConfigOption<MemorySize> FRAMEWORK_OFF_HEAP_MEMORY = ConfigOptions.key("taskmanager.memory.framework.off-heap.size").memoryType().defaultValue(MemorySize.parse("128m")).withDescription("Framework Off-Heap Memory size for TaskExecutors. This is the size of off-heap memory (JVM direct memory and native memory) reserved for TaskExecutor framework, which will not be allocated to task slots. The configured value will be fully counted when Flink calculates the JVM max direct memory size parameter.");
    @Documentation.Section(value={"common_memory"})
    public static final ConfigOption<MemorySize> TASK_HEAP_MEMORY = ConfigOptions.key("taskmanager.memory.task.heap.size").memoryType().noDefaultValue().withDescription("Task Heap Memory size for TaskExecutors. This is the size of JVM heap memory reserved for tasks. If not specified, it will be derived as Total Flink Memory minus Framework Heap Memory, Framework Off-Heap Memory, Task Off-Heap Memory, Managed Memory and Network Memory.");
    @Documentation.Section(value={"common_memory"})
    public static final ConfigOption<MemorySize> TASK_OFF_HEAP_MEMORY = ConfigOptions.key("taskmanager.memory.task.off-heap.size").memoryType().defaultValue(MemorySize.ZERO).withDescription("Task Off-Heap Memory size for TaskExecutors. This is the size of off heap memory (JVM direct memory and native memory) reserved for tasks. The configured value will be fully counted when Flink calculates the JVM max direct memory size parameter.");
    @Documentation.Section(value={"common_memory"})
    public static final ConfigOption<MemorySize> MANAGED_MEMORY_SIZE = ConfigOptions.key("taskmanager.memory.managed.size").memoryType().noDefaultValue().withDeprecatedKeys("taskmanager.memory.size").withDescription("Managed Memory size for TaskExecutors. This is the size of off-heap memory managed by the memory manager, reserved for sorting, hash tables, caching of intermediate results and RocksDB state backend. Memory consumers can either allocate memory from the memory manager in the form of MemorySegments, or reserve bytes from the memory manager and keep their memory usage within that boundary. If unspecified, it will be derived to make up the configured fraction of the Total Flink Memory.");
    @Documentation.Section(value={"common_memory"})
    public static final ConfigOption<Float> MANAGED_MEMORY_FRACTION = ConfigOptions.key("taskmanager.memory.managed.fraction").floatType().defaultValue(Float.valueOf(0.4f)).withDescription("Fraction of Total Flink Memory to be used as Managed Memory, if Managed Memory size is not explicitly specified.");
    @Documentation.Section(value={"common_memory"})
    public static final ConfigOption<Map<String, String>> MANAGED_MEMORY_CONSUMER_WEIGHTS = ConfigOptions.key("taskmanager.memory.managed.consumer-weights").mapType().defaultValue((Map<String, String>)new HashMap<String, String>(){
        {
            this.put(TaskManagerOptions.MANAGED_MEMORY_CONSUMER_NAME_OPERATOR, "70");
            this.put(TaskManagerOptions.MANAGED_MEMORY_CONSUMER_NAME_STATE_BACKEND, "70");
            this.put(TaskManagerOptions.MANAGED_MEMORY_CONSUMER_NAME_PYTHON, "30");
        }
    }).withDescription("Managed memory weights for different kinds of consumers. A slot\u2019s managed memory is shared by all kinds of consumers it contains, proportionally to the kinds\u2019 weights and regardless of the number of consumers from each kind. Currently supported kinds of consumers are OPERATOR (for built-in algorithms), STATE_BACKEND (for RocksDB state backend) and PYTHON (for Python processes).");
    @Documentation.Section(value={"common_memory"})
    public static final ConfigOption<MemorySize> NETWORK_MEMORY_MIN = ConfigOptions.key("taskmanager.memory.network.min").memoryType().defaultValue(MemorySize.parse("64m")).withDeprecatedKeys(NettyShuffleEnvironmentOptions.NETWORK_BUFFERS_MEMORY_MIN.key()).withDescription("Min Network Memory size for TaskExecutors. Network Memory is off-heap memory reserved for ShuffleEnvironment (e.g., network buffers). Network Memory size is derived to make up the configured fraction of the Total Flink Memory. If the derived size is less/greater than the configured min/max size, the min/max size will be used. The exact size of Network Memory can be explicitly specified by setting the min/max to the same value.");
    @Documentation.Section(value={"common_memory"})
    public static final ConfigOption<MemorySize> NETWORK_MEMORY_MAX = ConfigOptions.key("taskmanager.memory.network.max").memoryType().defaultValue(MemorySize.parse("1g")).withDeprecatedKeys(NettyShuffleEnvironmentOptions.NETWORK_BUFFERS_MEMORY_MAX.key()).withDescription("Max Network Memory size for TaskExecutors. Network Memory is off-heap memory reserved for ShuffleEnvironment (e.g., network buffers). Network Memory size is derived to make up the configured fraction of the Total Flink Memory. If the derived size is less/greater than the configured min/max size, the min/max size will be used. The exact size of Network Memory can be explicitly specified by setting the min/max to the same value.");
    @Documentation.Section(value={"common_memory"})
    public static final ConfigOption<Float> NETWORK_MEMORY_FRACTION = ConfigOptions.key("taskmanager.memory.network.fraction").floatType().defaultValue(Float.valueOf(0.1f)).withDeprecatedKeys(NettyShuffleEnvironmentOptions.NETWORK_BUFFERS_MEMORY_FRACTION.key()).withDescription("Fraction of Total Flink Memory to be used as Network Memory. Network Memory is off-heap memory reserved for ShuffleEnvironment (e.g., network buffers). Network Memory size is derived to make up the configured fraction of the Total Flink Memory. If the derived size is less/greater than the configured min/max size, the min/max size will be used. The exact size of Network Memory can be explicitly specified by setting the min/max size to the same value.");
    @Documentation.Section(value={"all_taskmanager_network"})
    public static final ConfigOption<Duration> BUFFER_DEBLOAT_PERIOD = ConfigOptions.key("taskmanager.network.memory.buffer-debloat.period").durationType().defaultValue(Duration.ofMillis(200L)).withDescription("The minimum period of time after which the buffer size will be debloated if required. The low value provides a fast reaction to the load fluctuation but can influence the performance.");
    @Documentation.Section(value={"all_taskmanager_network"})
    public static final ConfigOption<Integer> BUFFER_DEBLOAT_SAMPLES = ConfigOptions.key("taskmanager.network.memory.buffer-debloat.samples").intType().defaultValue(20).withDescription("The number of the last buffer size values that will be taken for the correct calculation of the new one.");
    @Documentation.Section(value={"all_taskmanager_network"})
    public static final ConfigOption<Duration> BUFFER_DEBLOAT_TARGET = ConfigOptions.key("taskmanager.network.memory.buffer-debloat.target").durationType().defaultValue(Duration.ofSeconds(1L)).withDescription("The target total time after which buffered in-flight data should be fully consumed. This configuration option will be used, in combination with the measured throughput, to adjust the amount of in-flight data.");
    @Documentation.Section(value={"all_taskmanager_network"})
    public static final ConfigOption<Boolean> BUFFER_DEBLOAT_ENABLED = ConfigOptions.key("taskmanager.network.memory.buffer-debloat.enabled").booleanType().defaultValue(false).withDescription("The switch of the automatic buffered debloating feature. If enabled the amount of in-flight data will be adjusted automatically accordingly to the measured throughput.");
    @Documentation.Section(value={"all_taskmanager_network"})
    public static final ConfigOption<Integer> BUFFER_DEBLOAT_THRESHOLD_PERCENTAGES = ConfigOptions.key("taskmanager.network.memory.buffer-debloat.threshold-percentages").intType().defaultValue(25).withDescription("The minimum difference in percentage between the newly calculated buffer size and the old one to announce the new value. Can be used to avoid constant back and forth small adjustments.");
    @Documentation.Section(value={"common_memory"})
    public static final ConfigOption<MemorySize> NETWORK_BATCH_SHUFFLE_READ_MEMORY = ConfigOptions.key("taskmanager.memory.framework.off-heap.batch-shuffle.size").memoryType().defaultValue(MemorySize.parse("64m")).withDescription(String.format("Size of memory used by blocking shuffle for shuffle data read (currently only used by sort-shuffle and hybrid shuffle). Notes: 1) The memory is cut from '%s' so must be smaller than that, which means you may also need to increase '%s' after you increase this config value; 2) This memory size can influence the shuffle performance and you can increase this config value for large-scale batch jobs (for example, to 128M or 256M).", FRAMEWORK_OFF_HEAP_MEMORY.key(), FRAMEWORK_OFF_HEAP_MEMORY.key()));
    @Documentation.Section(value={"common_memory"})
    public static final ConfigOption<MemorySize> JVM_METASPACE = ConfigOptions.key("taskmanager.memory.jvm-metaspace.size").memoryType().defaultValue(MemorySize.parse("256m")).withDescription("JVM Metaspace Size for the TaskExecutors.");
    @Documentation.Section(value={"common_memory"})
    public static final ConfigOption<MemorySize> JVM_OVERHEAD_MIN = ConfigOptions.key("taskmanager.memory.jvm-overhead.min").memoryType().defaultValue(MemorySize.parse("192m")).withDescription("Min JVM Overhead size for the TaskExecutors. This is off-heap memory reserved for JVM overhead, such as thread stack space, compile cache, etc. This includes native memory but not direct memory, and will not be counted when Flink calculates JVM max direct memory size parameter. The size of JVM Overhead is derived to make up the configured fraction of the Total Process Memory. If the derived size is less/greater than the configured min/max size, the min/max size will be used. The exact size of JVM Overhead can be explicitly specified by setting the min/max size to the same value.");
    @Documentation.Section(value={"common_memory"})
    public static final ConfigOption<MemorySize> JVM_OVERHEAD_MAX = ConfigOptions.key("taskmanager.memory.jvm-overhead.max").memoryType().defaultValue(MemorySize.parse("1g")).withDescription("Max JVM Overhead size for the TaskExecutors. This is off-heap memory reserved for JVM overhead, such as thread stack space, compile cache, etc. This includes native memory but not direct memory, and will not be counted when Flink calculates JVM max direct memory size parameter. The size of JVM Overhead is derived to make up the configured fraction of the Total Process Memory. If the derived size is less/greater than the configured min/max size, the min/max size will be used. The exact size of JVM Overhead can be explicitly specified by setting the min/max size to the same value.");
    @Documentation.Section(value={"common_memory"})
    public static final ConfigOption<Float> JVM_OVERHEAD_FRACTION = ConfigOptions.key("taskmanager.memory.jvm-overhead.fraction").floatType().defaultValue(Float.valueOf(0.1f)).withDescription("Fraction of Total Process Memory to be reserved for JVM Overhead. This is off-heap memory reserved for JVM overhead, such as thread stack space, compile cache, etc. This includes native memory but not direct memory, and will not be counted when Flink calculates JVM max direct memory size parameter. The size of JVM Overhead is derived to make up the configured fraction of the Total Process Memory. If the derived size is less/greater than the configured min/max size, the min/max size will be used. The exact size of JVM Overhead can be explicitly specified by setting the min/max size to the same value.");
    @Documentation.Section(value={"all_taskmanager"})
    public static final ConfigOption<Long> TASK_CANCELLATION_INTERVAL = ConfigOptions.key("task.cancellation.interval").longType().defaultValue(30000L).withDeprecatedKeys("task.cancellation-interval").withDescription("Time interval between two successive task cancellation attempts in milliseconds.");
    @Documentation.Section(value={"all_taskmanager"})
    public static final ConfigOption<Long> TASK_CANCELLATION_TIMEOUT = ConfigOptions.key("task.cancellation.timeout").longType().defaultValue(180000L).withDescription("Timeout in milliseconds after which a task cancellation times out and leads to a fatal TaskManager error. A value of 0 deactivates the watch dog. Notice that a task cancellation is different from both a task failure and a clean shutdown.  Task cancellation timeout only applies to task cancellation and does not apply to task closing/clean-up caused by a task failure or a clean shutdown.");
    @Documentation.Section(value={"all_taskmanager"})
    public static final ConfigOption<Long> TASK_CANCELLATION_TIMEOUT_TIMERS = ConfigOptions.key("task.cancellation.timers.timeout").longType().defaultValue(7500L).withDeprecatedKeys("timerservice.exceptional.shutdown.timeout").withDescription("Time we wait for the timers in milliseconds to finish all pending timer threads when the stream task is cancelled.");

    private TaskManagerOptions() {
    }
}

