/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.plugable;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.plugable.DeserializationDelegate;

public class NonReusingDeserializationDelegate<T>
implements DeserializationDelegate<T> {
    private T instance;
    private final TypeSerializer<T> serializer;

    public NonReusingDeserializationDelegate(TypeSerializer<T> serializer) {
        this.serializer = serializer;
    }

    @Override
    public void setInstance(T instance) {
        this.instance = instance;
    }

    @Override
    public T getInstance() {
        return this.instance;
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        throw new IllegalStateException("Serialization method called on DeserializationDelegate.");
    }

    @Override
    public void read(DataInputView in) throws IOException {
        this.instance = this.serializer.deserialize(in);
    }
}

