/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.FSDataOutputStream;

@Internal
public abstract class MetadataOutputStreamWrapper {
    private volatile boolean closed = false;

    abstract FSDataOutputStream getOutput();

    abstract void closeForCommitAction() throws IOException;

    abstract void closeAction() throws IOException;

    abstract void cleanup() throws IOException;

    final void closeForCommit() throws IOException {
        if (this.closed) {
            throw new IOException("The output stream has been closed. This should not happen.");
        }
        this.closeForCommitAction();
        this.closed = true;
    }

    final void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closeAction();
        this.closed = true;
    }
}

