/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.tunnel.websocket.jetty9;

import java.io.IOException;
import org.apache.guacamole.GuacamoleConnectionClosedException;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.protocol.FilteredGuacamoleWriter;
import org.apache.guacamole.protocol.GuacamoleFilter;
import org.apache.guacamole.protocol.GuacamoleInstruction;
import org.apache.guacamole.protocol.GuacamoleStatus;
import org.apache.guacamole.tunnel.websocket.jetty9.GuacamoleWebSocketTunnelListener;
import org.apache.guacamole.tunnel.websocket.jetty9.RestrictedGuacamoleWebSocketTunnelServlet;
import org.eclipse.jetty.websocket.api.CloseStatus;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GuacamoleWebSocketTunnelListener
implements WebSocketListener {
    private static final int BUFFER_SIZE = 8192;
    private static final String PING_OPCODE = "ping";
    private static final Logger logger = LoggerFactory.getLogger(RestrictedGuacamoleWebSocketTunnelServlet.class);
    private GuacamoleTunnel tunnel;
    private RemoteEndpoint remote;

    private void closeConnection(Session session, int guacamoleStatusCode, int webSocketCode) {
        try {
            String message = Integer.toString(guacamoleStatusCode);
            session.close(new CloseStatus(webSocketCode, message));
        }
        catch (IOException e) {
            logger.debug("Unable to close WebSocket connection.", (Throwable)e);
        }
    }

    private void closeConnection(Session session, GuacamoleStatus guacStatus) {
        this.closeConnection(session, guacStatus.getGuacamoleStatusCode(), guacStatus.getWebSocketCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendInstruction(String instruction) throws IOException {
        RemoteEndpoint remoteEndpoint = this.remote;
        synchronized (remoteEndpoint) {
            this.remote.sendString(instruction);
        }
    }

    private void sendInstruction(GuacamoleInstruction instruction) throws IOException {
        this.sendInstruction(instruction.toString());
    }

    protected abstract GuacamoleTunnel createTunnel(Session var1) throws GuacamoleException;

    public void onWebSocketConnect(Session session) {
        this.remote = session.getRemote();
        try {
            this.tunnel = this.createTunnel(session);
            if (this.tunnel == null) {
                this.closeConnection(session, GuacamoleStatus.RESOURCE_NOT_FOUND);
                return;
            }
        }
        catch (GuacamoleException e) {
            logger.error("Creation of WebSocket tunnel to guacd failed: {}", (Object)e.getMessage());
            logger.debug("Error connecting WebSocket tunnel.", (Throwable)e);
            this.closeConnection(session, e.getStatus().getGuacamoleStatusCode(), e.getWebSocketCode());
            return;
        }
        1 readThread = new /* Unavailable Anonymous Inner Class!! */;
        readThread.start();
    }

    public void onWebSocketText(String message) {
        if (this.tunnel == null) {
            return;
        }
        FilteredGuacamoleWriter writer = new FilteredGuacamoleWriter(this.tunnel.acquireWriter(), (GuacamoleFilter)new /* Unavailable Anonymous Inner Class!! */);
        try {
            writer.write(message.toCharArray());
        }
        catch (GuacamoleConnectionClosedException e) {
            logger.debug("Connection to guacd closed.", (Throwable)e);
        }
        catch (GuacamoleException e) {
            logger.debug("WebSocket tunnel write failed.", (Throwable)e);
        }
        this.tunnel.releaseWriter();
    }

    public void onWebSocketBinary(byte[] payload, int offset, int length) {
        throw new UnsupportedOperationException("Binary WebSocket messages are not supported.");
    }

    public void onWebSocketError(Throwable t) {
        logger.debug("WebSocket tunnel closing due to error.", t);
        try {
            if (this.tunnel != null) {
                this.tunnel.close();
            }
        }
        catch (GuacamoleException e) {
            logger.debug("Unable to close connection to guacd.", (Throwable)e);
        }
    }

    public void onWebSocketClose(int statusCode, String reason) {
        try {
            if (this.tunnel != null) {
                this.tunnel.close();
            }
        }
        catch (GuacamoleException e) {
            logger.debug("Unable to close connection to guacd.", (Throwable)e);
        }
    }

    static /* synthetic */ GuacamoleTunnel access$000(GuacamoleWebSocketTunnelListener x0) {
        return x0.tunnel;
    }

    static /* synthetic */ void access$100(GuacamoleWebSocketTunnelListener x0, GuacamoleInstruction x1) throws IOException {
        x0.sendInstruction(x1);
    }

    static /* synthetic */ void access$200(GuacamoleWebSocketTunnelListener x0, String x1) throws IOException {
        x0.sendInstruction(x1);
    }

    static /* synthetic */ void access$300(GuacamoleWebSocketTunnelListener x0, Session x1, GuacamoleStatus x2) {
        x0.closeConnection(x1, x2);
    }

    static /* synthetic */ Logger access$400() {
        return logger;
    }

    static /* synthetic */ void access$500(GuacamoleWebSocketTunnelListener x0, Session x1, int x2, int x3) {
        x0.closeConnection(x1, x2, x3);
    }
}

