/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.tx;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.internal.client.ClientChannel;
import org.apache.ignite.internal.client.tx.ClientLazyTransaction;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.util.ViewUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.tx.Transaction;
import org.apache.ignite.tx.TransactionException;

public class ClientTransaction
implements Transaction {
    private static final int STATE_OPEN = 0;
    private static final int STATE_COMMITTED = 1;
    private static final int STATE_ROLLED_BACK = 2;
    private final ClientChannel ch;
    private final long id;
    private final AtomicReference<CompletableFuture<Void>> finishFut = new AtomicReference();
    private final AtomicInteger state = new AtomicInteger(0);
    private final boolean isReadOnly;

    public ClientTransaction(ClientChannel ch, long id, boolean isReadOnly) {
        this.ch = ch;
        this.id = id;
        this.isReadOnly = isReadOnly;
    }

    public long id() {
        return this.id;
    }

    public ClientChannel channel() {
        return this.ch;
    }

    @Override
    public void commit() throws TransactionException {
        ViewUtils.sync(this.commitAsync());
    }

    @Override
    public CompletableFuture<Void> commitAsync() {
        if (!this.finishFut.compareAndSet(null, new CompletableFuture())) {
            return this.finishFut.get();
        }
        this.setState(1);
        CompletableFuture<Void> mainFinishFut = this.ch.serviceAsync(44, w -> w.out().packLong(this.id), r -> null);
        mainFinishFut.handle((res, e) -> this.finishFut.get().complete(null));
        return mainFinishFut;
    }

    @Override
    public void rollback() throws TransactionException {
        ViewUtils.sync(this.rollbackAsync());
    }

    @Override
    public CompletableFuture<Void> rollbackAsync() {
        if (!this.finishFut.compareAndSet(null, new CompletableFuture())) {
            return this.finishFut.get();
        }
        this.setState(2);
        CompletableFuture<Void> mainFinishFut = this.ch.serviceAsync(45, w -> w.out().packLong(this.id), r -> null);
        mainFinishFut.handle((res, e) -> this.finishFut.get().complete(null));
        return mainFinishFut;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public static ClientTransaction get(Transaction tx) {
        if (!(tx instanceof ClientLazyTransaction)) {
            throw ClientTransaction.unsupportedTxTypeException(tx);
        }
        ClientTransaction clientTx = ((ClientLazyTransaction)tx).startedTx();
        int state = clientTx.state.get();
        if (state == 0) {
            return clientTx;
        }
        String stateStr = state == 1 ? "COMMITTED" : "ABORTED";
        throw new TransactionException(ErrorGroups.Transactions.TX_ALREADY_FINISHED_ERR, IgniteStringFormatter.format("Transaction is already finished [id={}, state={}].", clientTx.id, stateStr));
    }

    static IgniteException unsupportedTxTypeException(Transaction tx) {
        return new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Unsupported transaction implementation: '" + String.valueOf(tx.getClass()) + "'. Use IgniteClient.transactions() to start transactions.");
    }

    private void setState(int state) {
        this.state.compareAndExchange(0, state);
    }
}

