/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.waiters;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.JmesPathFlatten;
import com.amazonaws.jmespath.JmesPathLengthFunction;
import com.amazonaws.jmespath.JmesPathLiteral;
import com.amazonaws.jmespath.JmesPathProjection;
import com.amazonaws.jmespath.JmesPathVisitor;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazonaws.jmespath.OpGreaterThan;
import com.amazonaws.services.ec2.model.DescribeKeyPairsResult;
import com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

@SdkInternalApi
class KeyPairExists {
    KeyPairExists() {
    }

    static class IsInvalidKeyPairNotFoundMatcher
    extends WaiterAcceptor<DescribeKeyPairsResult> {
        IsInvalidKeyPairNotFoundMatcher() {
        }

        public boolean matches(AmazonServiceException e) {
            return "InvalidKeyPair.NotFound".equals(e.getErrorCode());
        }

        public WaiterState getState() {
            return WaiterState.RETRY;
        }
    }

    static class IsTrueMatcher
    extends WaiterAcceptor<DescribeKeyPairsResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsTrueMatcher() {
        }

        public boolean matches(DescribeKeyPairsResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)ast.accept((JmesPathVisitor)new JmesPathEvaluationVisitor(), (Object)queryNode);
            return AcceptorPathMatcher.pathAll((JsonNode)expectedResult, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("true");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new OpGreaterThan((JmesPathExpression)new JmesPathLengthFunction(new JmesPathExpression[]{new JmesPathProjection((JmesPathExpression)new JmesPathFlatten((JmesPathExpression)new JmesPathField("KeyPairs")), (JmesPathExpression)new JmesPathField("KeyName"))}), (JmesPathExpression)new JmesPathLiteral("0"));
        }
    }
}

