/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.internal;

import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.exception.BadCiphertextException;
import com.amazonaws.encryptionsdk.internal.CipherHandler;
import com.amazonaws.encryptionsdk.internal.CryptoHandler;
import com.amazonaws.encryptionsdk.internal.ProcessingSummary;
import com.amazonaws.encryptionsdk.internal.Utils;
import com.amazonaws.encryptionsdk.model.CipherBlockHeaders;
import java.util.Arrays;
import javax.crypto.SecretKey;

class BlockDecryptionHandler
implements CryptoHandler {
    private final SecretKey decryptionKey_;
    private final short nonceLen_;
    private final CryptoAlgorithm cryptoAlgo_;
    private final byte[] messageId_;
    private final CipherBlockHeaders blockHeaders_;
    private final byte[] bytesToDecrypt_ = new byte[0];
    private byte[] unparsedBytes_ = new byte[0];
    private boolean complete_ = false;

    public BlockDecryptionHandler(SecretKey decryptionKey, short nonceLen, CryptoAlgorithm cryptoAlgo, byte[] messageId) {
        this.decryptionKey_ = decryptionKey;
        this.nonceLen_ = nonceLen;
        this.cryptoAlgo_ = cryptoAlgo;
        this.messageId_ = messageId;
        this.blockHeaders_ = new CipherBlockHeaders();
    }

    @Override
    public synchronized ProcessingSummary processBytes(byte[] in, int off, int len, byte[] out, int outOff) throws AwsCryptoException {
        byte[] bytesToParse = new byte[this.unparsedBytes_.length + len];
        System.arraycopy(this.unparsedBytes_, 0, bytesToParse, 0, this.unparsedBytes_.length);
        System.arraycopy(in, off, bytesToParse, this.unparsedBytes_.length, len);
        long parsedBytes = 0L;
        if (!this.complete_ && parsedBytes < (long)bytesToParse.length) {
            this.blockHeaders_.setNonceLength(this.nonceLen_);
            parsedBytes += (long)this.blockHeaders_.deserialize(bytesToParse, (int)parsedBytes);
            if (parsedBytes > Integer.MAX_VALUE) {
                throw new AwsCryptoException("Integer overflow of the total bytes to parse and decrypt occured.");
            }
            if (this.blockHeaders_.isComplete()) {
                if (this.blockHeaders_.getContentLength() > Integer.MAX_VALUE) {
                    throw new AwsCryptoException("Content length exceeds the maximum allowed value.");
                }
                int protectedContentLen = (int)this.blockHeaders_.getContentLength();
                if ((long)bytesToParse.length - parsedBytes >= (long)(protectedContentLen += this.cryptoAlgo_.getTagLen())) {
                    byte[] plaintext = this.decryptContent(bytesToParse, (int)parsedBytes, protectedContentLen);
                    System.arraycopy(plaintext, 0, out, outOff, plaintext.length);
                    this.complete_ = true;
                    return new ProcessingSummary(plaintext.length, (int)(parsedBytes + (long)protectedContentLen) - this.unparsedBytes_.length);
                }
            }
        }
        this.unparsedBytes_ = Arrays.copyOfRange(bytesToParse, (int)parsedBytes, bytesToParse.length);
        return new ProcessingSummary(0, len);
    }

    @Override
    public synchronized int doFinal(byte[] out, int outOff) throws BadCiphertextException {
        return 0;
    }

    @Override
    public synchronized int estimateOutputSize(int inLen) {
        int outSize = this.bytesToDecrypt_.length + this.unparsedBytes_.length;
        if (inLen > 0) {
            outSize += inLen;
        }
        return outSize;
    }

    @Override
    public int estimatePartialOutputSize(int inLen) {
        return this.estimateOutputSize(inLen);
    }

    @Override
    public int estimateFinalOutputSize() {
        return this.estimateOutputSize(0);
    }

    private byte[] decryptContent(byte[] input, int off, int len) throws BadCiphertextException {
        if (!this.blockHeaders_.isComplete()) {
            return new byte[0];
        }
        byte[] nonce = this.blockHeaders_.getNonce();
        boolean seqNum = true;
        byte[] contentAad = Utils.generateContentAad(this.messageId_, "AWSKMSEncryptionClient Single Block", 1, this.blockHeaders_.getContentLength());
        CipherHandler cipherHandler = new CipherHandler(this.decryptionKey_, 2, this.cryptoAlgo_);
        return cipherHandler.cipherData(nonce, contentAad, input, off, len);
    }

    @Override
    public boolean isComplete() {
        return this.complete_;
    }
}

