/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.internal;

import com.amazonaws.encryptionsdk.MasterKey;
import com.amazonaws.encryptionsdk.internal.MessageCryptoHandler;
import com.amazonaws.encryptionsdk.internal.ProcessingSummary;
import com.amazonaws.encryptionsdk.model.CiphertextHeaders;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class LazyMessageCryptoHandler
implements MessageCryptoHandler {
    private Function<LateBoundInfo, MessageCryptoHandler> delegateFactory;
    private MessageCryptoHandler delegate;
    private long maxInputSize = -1L;

    public LazyMessageCryptoHandler(Function<LateBoundInfo, MessageCryptoHandler> delegateFactory) {
        this.delegateFactory = delegateFactory;
        this.delegate = null;
    }

    private MessageCryptoHandler getDelegate() {
        if (this.delegate == null) {
            this.delegate = this.delegateFactory.apply(new LateBoundInfo(this.maxInputSize));
            if (this.maxInputSize != -1L) {
                this.delegate.setMaxInputLength(this.maxInputSize);
            }
            this.delegateFactory = null;
        }
        return this.delegate;
    }

    @Override
    public void setMaxInputLength(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("Max input size must be non-negative");
        }
        if (this.delegate == null) {
            if (this.maxInputSize == -1L || this.maxInputSize > size) {
                this.maxInputSize = size;
            }
        } else {
            this.delegate.setMaxInputLength(size);
        }
    }

    @Override
    public boolean isComplete() {
        return this.delegate != null && this.delegate.isComplete();
    }

    @Override
    public Map<String, String> getEncryptionContext() {
        return this.getDelegate().getEncryptionContext();
    }

    @Override
    public CiphertextHeaders getHeaders() {
        return this.getDelegate().getHeaders();
    }

    @Override
    public ProcessingSummary processBytes(byte[] in, int inOff, int inLen, byte[] out, int outOff) {
        return this.getDelegate().processBytes(in, inOff, inLen, out, outOff);
    }

    @Override
    public List<? extends MasterKey<?>> getMasterKeys() {
        return this.getDelegate().getMasterKeys();
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        return this.getDelegate().doFinal(out, outOff);
    }

    @Override
    public int estimateOutputSize(int inLen) {
        return this.getDelegate().estimateOutputSize(inLen);
    }

    @Override
    public int estimatePartialOutputSize(int inLen) {
        return this.getDelegate().estimatePartialOutputSize(inLen);
    }

    @Override
    public int estimateFinalOutputSize() {
        return this.getDelegate().estimateFinalOutputSize();
    }

    public static final class LateBoundInfo {
        private final long maxInputSize;

        private LateBoundInfo(long maxInputSize) {
            this.maxInputSize = maxInputSize;
        }

        public long getMaxInputSize() {
            return this.maxInputSize;
        }
    }
}

