/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.util.Map;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeTaskFuture;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.mxbean.ComputeMXBean;
import org.apache.ignite.resources.IgniteInstanceResource;

public class ComputeMXBeanImpl
implements ComputeMXBean {
    private final GridKernalContext ctx;

    public ComputeMXBeanImpl(GridKernalContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public void cancel(String sesId) {
        A.notNull(sesId, "sessionId");
        this.cancel(IgniteUuid.fromString(sesId));
    }

    public void cancel(IgniteUuid sesId) {
        try {
            this.ctx.grid().compute(this.ctx.grid().cluster()).broadcast(new ComputeCancelSession(), sesId);
        }
        catch (IgniteException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ComputeCancelSession
    implements IgniteClosure<IgniteUuid, Void> {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        private transient IgniteEx ignite;

        private ComputeCancelSession() {
        }

        @Override
        public Void apply(IgniteUuid sesId) {
            this.ignite.context().job().cancelJob(sesId, null, false);
            IgniteCompute compute = this.ignite.compute(this.ignite.cluster().forLocal());
            Map futs = compute.activeTaskFutures();
            ComputeTaskFuture fut = futs.get(sesId);
            if (fut != null) {
                fut.cancel();
            }
            return null;
        }
    }
}

