/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.thin;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLTimeoutException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.internal.jdbc.thin.JdbcThinConnection;
import org.apache.ignite.internal.jdbc.thin.JdbcThinResultSet;
import org.apache.ignite.internal.jdbc.thin.JdbcThinTcpIo;
import org.apache.ignite.internal.processors.cache.query.IgniteQueryErrorCode;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBatchExecuteRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBatchExecuteResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBulkLoadAckResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBulkLoadBatchRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQuery;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryCancelRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryExecuteMultipleStatementsResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryExecuteRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryExecuteResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResultInfo;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResultWithIo;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcStatementType;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.sql.SqlParseException;
import org.apache.ignite.internal.sql.SqlParser;
import org.apache.ignite.internal.sql.command.SqlCommand;
import org.apache.ignite.internal.sql.command.SqlSetStreamingCommand;
import org.apache.ignite.internal.util.typedef.F;

public class JdbcThinStatement
implements Statement {
    private static final int DFLT_PAGE_SIZE = 1024;
    protected final JdbcThinConnection conn;
    private final String schema;
    private volatile boolean closed;
    private int maxRows;
    private int timeout;
    boolean explicitTimeout;
    private int reqTimeout;
    private int pageSize = 1024;
    private final int resHoldability;
    protected int batchSize;
    protected List<JdbcQuery> batch;
    private boolean closeOnCompletion;
    protected volatile List<JdbcThinResultSet> resultSets;
    protected int curRes;
    private long currReqId;
    private JdbcThinTcpIo stickyIo;
    private volatile boolean cancelled;
    final Object cancellationMux = new Object();

    JdbcThinStatement(JdbcThinConnection conn, int resHoldability, String schema) {
        assert (conn != null);
        this.conn = conn;
        this.resHoldability = resHoldability;
        this.schema = schema;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.execute0(JdbcStatementType.SELECT_STATEMENT_TYPE, sql, null);
        ResultSet rs = this.getResultSet();
        if (rs == null) {
            throw new SQLException("The query isn't SELECT query: " + sql, "42000");
        }
        return rs;
    }

    private SqlCommand tryParseNative(String sql) {
        try {
            return new SqlParser(this.schema, sql).nextCommand();
        }
        catch (SqlParseException e) {
            return null;
        }
    }

    private static boolean isEligibleForNativeParsing(String sql) {
        if (F.isEmpty(sql)) {
            return false;
        }
        int setPos = (sql = sql.toUpperCase()).indexOf("SET");
        if (setPos == -1) {
            return false;
        }
        int streamingPos = sql.indexOf("STREAMING");
        return streamingPos - setPos - "SET".length() >= 1;
    }

    protected void execute0(JdbcStatementType stmtType, String sql, List<Object> args) throws SQLException {
        this.ensureNotClosed();
        this.closeResults();
        if (sql == null || sql.isEmpty()) {
            throw new SQLException("SQL query is empty.");
        }
        this.checkStatementBatchEmpty();
        SqlCommand nativeCmd = null;
        if (stmtType != JdbcStatementType.SELECT_STATEMENT_TYPE && JdbcThinStatement.isEligibleForNativeParsing(sql)) {
            nativeCmd = this.tryParseNative(sql);
        }
        if (nativeCmd != null) {
            this.conn.executeNative(sql, nativeCmd, this);
            this.resultSets = Collections.singletonList(this.resultSetForUpdate(0L));
            return;
        }
        if (this.conn.isStream()) {
            if (stmtType == JdbcStatementType.SELECT_STATEMENT_TYPE) {
                throw new SQLException("executeQuery() method is not allowed in streaming mode.", "50000", 1002);
            }
            this.conn.addBatch(sql, args);
            this.resultSets = Collections.singletonList(this.resultSetForUpdate(0L));
            return;
        }
        JdbcQueryExecuteRequest req = new JdbcQueryExecuteRequest(stmtType, this.schema, this.pageSize, this.maxRows, this.conn.getAutoCommit(), this.explicitTimeout, sql, args == null ? null : args.toArray(new Object[args.size()]));
        JdbcResultWithIo resWithIo = this.conn.sendRequest(req, this, null);
        Object res0 = resWithIo.response();
        JdbcThinTcpIo stickyIo = resWithIo.cliIo();
        assert (res0 != null);
        if (res0 instanceof JdbcBulkLoadAckResult) {
            res0 = this.sendFile((JdbcBulkLoadAckResult)res0, stickyIo);
        }
        if (res0 instanceof JdbcQueryExecuteResult) {
            JdbcQueryExecuteResult res = (JdbcQueryExecuteResult)res0;
            this.resultSets = Collections.singletonList(new JdbcThinResultSet(this, res.cursorId(), this.pageSize, res.last(), res.items(), res.isQuery(), this.conn.autoCloseServerCursor(), res.updateCount(), this.closeOnCompletion, stickyIo));
        } else if (res0 instanceof JdbcQueryExecuteMultipleStatementsResult) {
            JdbcQueryExecuteMultipleStatementsResult res = (JdbcQueryExecuteMultipleStatementsResult)res0;
            List<JdbcResultInfo> resInfos = res.results();
            this.resultSets = new ArrayList<JdbcThinResultSet>(resInfos.size());
            boolean firstRes = true;
            for (JdbcResultInfo rsInfo : resInfos) {
                if (!rsInfo.isQuery()) {
                    this.resultSets.add(this.resultSetForUpdate(rsInfo.updateCount()));
                    continue;
                }
                if (firstRes) {
                    firstRes = false;
                    this.resultSets.add(new JdbcThinResultSet(this, rsInfo.cursorId(), this.pageSize, res.isLast(), res.items(), true, this.conn.autoCloseServerCursor(), -1L, this.closeOnCompletion, stickyIo));
                    continue;
                }
                this.resultSets.add(new JdbcThinResultSet(this, rsInfo.cursorId(), this.pageSize, false, null, true, this.conn.autoCloseServerCursor(), -1L, this.closeOnCompletion, stickyIo));
            }
        } else {
            throw new SQLException("Unexpected result [res=" + res0 + ']');
        }
        assert (!this.resultSets.isEmpty()) : "At least one results set is expected";
    }

    void checkStatementBatchEmpty() throws SQLException {
        if (this.conn.isStream() && !F.isEmpty(this.batch)) {
            throw new IgniteSQLException("Statement has non-empty batch (call executeBatch() or clearBatch() before enabling streaming).", 1002).toJdbcException();
        }
    }

    private JdbcThinResultSet resultSetForUpdate(long cnt) {
        return new JdbcThinResultSet(this, -1L, this.pageSize, true, Collections.emptyList(), false, this.conn.autoCloseServerCursor(), cnt, this.closeOnCompletion, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JdbcResult sendFile(JdbcBulkLoadAckResult cmdRes, JdbcThinTcpIo stickyIO) throws SQLException {
        String fileName = cmdRes.params().localFileName();
        int batchSize = cmdRes.params().packetSize();
        int batchNum = 0;
        try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(fileName));){
            int readBytes;
            byte[] buf = new byte[batchSize];
            int timeSpendMillis = 0;
            while ((readBytes = ((InputStream)input).read(buf)) != -1) {
                Object res;
                long startTime = System.currentTimeMillis();
                if (readBytes == 0) continue;
                if (this.reqTimeout != 0) {
                    this.reqTimeout -= timeSpendMillis;
                }
                if (!((res = this.conn.sendRequest(new JdbcBulkLoadBatchRequest(cmdRes.cursorId(), batchNum++, 0, readBytes == buf.length ? buf : Arrays.copyOf(buf, readBytes)), this, stickyIO).response()) instanceof JdbcQueryExecuteResult)) {
                    throw new SQLException("Unknown response sent by the server: " + res);
                }
                timeSpendMillis = (int)(System.currentTimeMillis() - startTime);
            }
            if (this.reqTimeout != 0) {
                this.reqTimeout -= timeSpendMillis;
            }
            Object r = this.conn.sendRequest(new JdbcBulkLoadBatchRequest(cmdRes.cursorId(), batchNum++, 2), this, stickyIO).response();
            return r;
        }
        catch (Exception e) {
            if (e instanceof SQLTimeoutException) {
                throw (SQLTimeoutException)e;
            }
            try {
                this.conn.sendRequest(new JdbcBulkLoadBatchRequest(cmdRes.cursorId(), batchNum, 1), this, stickyIO);
            }
            catch (SQLException e1) {
                throw new SQLException("Cannot send finalization request: " + e1.getMessage(), e);
            }
            if (!(e instanceof SQLException)) throw new SQLException("Failed to read file: '" + fileName + "'", "50000", e);
            throw (SQLException)e;
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.execute0(JdbcStatementType.UPDATE_STMT_TYPE, sql, null);
        int res = this.getUpdateCount();
        if (res == -1) {
            throw new SQLException("The query is not DML statememt: " + sql);
        }
        return res;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        try {
            this.closeResults();
            this.conn.closeStatement(this);
        }
        finally {
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeResults() throws SQLException {
        if (this.resultSets != null) {
            for (JdbcThinResultSet rs : this.resultSets) {
                rs.close0();
            }
            this.resultSets = null;
            this.curRes = 0;
        }
        Object object = this.cancellationMux;
        synchronized (object) {
            this.currReqId = 0L;
            this.stickyIo = null;
            this.cancelled = false;
        }
    }

    boolean isCancelled() {
        return this.cancelled;
    }

    void closeOnDisconnect() {
        if (this.resultSets != null) {
            for (JdbcThinResultSet rs : this.resultSets) {
                rs.closeOnDisconnect();
            }
            this.resultSets = null;
        }
        this.closed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.ensureNotClosed();
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.ensureNotClosed();
        if (max < 0) {
            throw new SQLException("Invalid field limit.");
        }
        throw new SQLFeatureNotSupportedException("Field size limitation is not supported.");
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.ensureNotClosed();
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int maxRows) throws SQLException {
        this.ensureNotClosed();
        if (maxRows < 0) {
            throw new SQLException("Invalid max rows value.");
        }
        this.maxRows = maxRows;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.ensureNotClosed();
        return this.timeout / 1000;
    }

    @Override
    public void setQueryTimeout(int timeout) throws SQLException {
        this.ensureNotClosed();
        if (timeout < 0) {
            throw new SQLException("Invalid timeout value.");
        }
        this.timeout(timeout * 1000 > timeout ? timeout * 1000 : Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        JdbcThinTcpIo cliIo;
        long reqId;
        this.ensureNotClosed();
        if (!this.isQueryCancellationSupported()) {
            throw new SQLFeatureNotSupportedException("Cancel method is not supported.");
        }
        Object object = this.cancellationMux;
        synchronized (object) {
            if (this.isCancelled()) {
                return;
            }
            if (this.conn.isStream()) {
                throw new SQLFeatureNotSupportedException("Cancel method is not allowed in streaming mode.");
            }
            reqId = this.currReqId;
            if (reqId != 0L) {
                this.cancelled = true;
            }
            cliIo = this.stickyIo;
        }
        if (reqId != 0L) {
            this.conn.sendQueryCancelRequest(new JdbcQueryCancelRequest(reqId), cliIo);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.ensureNotClosed();
        this.execute0(JdbcStatementType.ANY_STATEMENT_TYPE, sql, null);
        return this.resultSets.get(0).isQuery();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.ensureAlive();
        if (this.resultSets == null || this.curRes >= this.resultSets.size()) {
            return null;
        }
        JdbcThinResultSet rs = this.resultSets.get(this.curRes);
        if (!rs.isQuery()) {
            return null;
        }
        return rs;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.ensureAlive();
        if (this.resultSets == null || this.curRes >= this.resultSets.size()) {
            return -1;
        }
        JdbcThinResultSet rs = this.resultSets.get(this.curRes);
        if (rs.isQuery()) {
            return -1;
        }
        return (int)rs.updatedCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.ensureNotClosed();
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException("Only forward direction is supported.");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.ensureNotClosed();
        return 1000;
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        this.ensureNotClosed();
        if (fetchSize <= 0) {
            throw new SQLException("Fetch size must be greater than zero.");
        }
        this.pageSize = fetchSize;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.ensureNotClosed();
        return this.pageSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.ensureNotClosed();
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.ensureNotClosed();
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.ensureNotClosed();
        this.checkStatementEligibleForBatching(sql);
        this.checkStatementBatchEmpty();
        ++this.batchSize;
        if (this.conn.isStream()) {
            this.conn.addBatch(sql, null);
            return;
        }
        if (this.batch == null) {
            this.batch = new ArrayList<JdbcQuery>();
        }
        this.batch.add(new JdbcQuery(sql, null));
    }

    void checkStatementEligibleForBatching(String sql) throws SQLException {
        SqlCommand nativeCmd = null;
        if (JdbcThinStatement.isEligibleForNativeParsing(sql)) {
            nativeCmd = this.tryParseNative(sql);
        }
        if (nativeCmd != null) {
            assert (nativeCmd instanceof SqlSetStreamingCommand);
            throw new SQLException("Streaming control commands must be executed explicitly - either via Statement.execute(String), or via using prepared statements.", "0A000");
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.ensureNotClosed();
        this.batchSize = 0;
        this.batch = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.ensureNotClosed();
        this.closeResults();
        this.checkStatementBatchEmpty();
        if (this.conn.isStream()) {
            int[] res = new int[this.batchSize];
            this.batchSize = 0;
            return res;
        }
        if (F.isEmpty(this.batch)) {
            return new int[0];
        }
        JdbcBatchExecuteRequest req = new JdbcBatchExecuteRequest(this.conn.getSchema(), this.batch, this.conn.getAutoCommit(), false);
        try {
            JdbcBatchExecuteResult res = (JdbcBatchExecuteResult)this.conn.sendRequest(req, this, null).response();
            if (res.errorCode() != 0) {
                throw new BatchUpdateException(res.errorMessage(), IgniteQueryErrorCode.codeToSqlState(res.errorCode()), res.errorCode(), res.updateCounts());
            }
            int[] nArray = res.updateCounts();
            return nArray;
        }
        finally {
            this.batchSize = 0;
            this.batch = null;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.ensureNotClosed();
        return this.conn;
    }

    @Override
    public boolean getMoreResults(int curr) throws SQLException {
        this.ensureAlive();
        if (this.resultSets == null || this.curRes >= this.resultSets.size()) {
            return false;
        }
        ++this.curRes;
        if (this.resultSets != null) {
            assert (this.curRes <= this.resultSets.size()) : "Invalid results state: [resultsCount=" + this.resultSets.size() + ", curRes=" + this.curRes + ']';
            switch (curr) {
                case 1: {
                    if (this.curRes <= 0) break;
                    this.resultSets.get(this.curRes - 1).close0();
                    break;
                }
                case 3: {
                    for (int i = 0; i < this.curRes; ++i) {
                        this.resultSets.get(i).close0();
                    }
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new SQLException("Invalid 'current' parameter.");
                }
            }
        }
        return this.resultSets != null && this.curRes < this.resultSets.size();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.ensureAlive();
        throw new SQLFeatureNotSupportedException("Auto-generated columns are not supported.");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.ensureNotClosed();
        switch (autoGeneratedKeys) {
            case 1: {
                throw new SQLFeatureNotSupportedException("Auto-generated columns are not supported.");
            }
            case 2: {
                return this.executeUpdate(sql);
            }
        }
        throw new SQLException("Invalid autoGeneratedKeys value");
    }

    @Override
    public int executeUpdate(String sql, int[] colIndexes) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Auto-generated columns are not supported.");
    }

    @Override
    public int executeUpdate(String sql, String[] colNames) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Auto-generated columns are not supported.");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.ensureNotClosed();
        switch (autoGeneratedKeys) {
            case 1: {
                throw new SQLFeatureNotSupportedException("Auto-generated columns are not supported.");
            }
            case 2: {
                return this.execute(sql);
            }
        }
        throw new SQLException("Invalid autoGeneratedKeys value.");
    }

    @Override
    public boolean execute(String sql, int[] colIndexes) throws SQLException {
        this.ensureNotClosed();
        if (colIndexes != null && colIndexes.length > 0) {
            throw new SQLFeatureNotSupportedException("Auto-generated columns are not supported.");
        }
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] colNames) throws SQLException {
        this.ensureNotClosed();
        if (colNames != null && colNames.length > 0) {
            throw new SQLFeatureNotSupportedException("Auto-generated columns are not supported.");
        }
        return this.execute(sql);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.ensureNotClosed();
        return this.resHoldability;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.conn.isClosed() || this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.ensureNotClosed();
        if (poolable) {
            throw new SQLFeatureNotSupportedException("Pooling is not supported.");
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.ensureNotClosed();
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Statement is not a wrapper for " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(JdbcThinStatement.class);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.ensureNotClosed();
        this.closeOnCompletion = true;
        if (this.resultSets != null) {
            for (JdbcThinResultSet rs : this.resultSets) {
                rs.closeStatement(true);
            }
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.ensureNotClosed();
        return this.closeOnCompletion;
    }

    public final void timeout(int timeout) {
        assert (timeout >= 0);
        this.reqTimeout = this.timeout = timeout;
        this.explicitTimeout = true;
    }

    JdbcThinConnection connection() {
        return this.conn;
    }

    void ensureNotClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement is closed.");
        }
    }

    void ensureAlive() throws SQLException {
        this.ensureNotClosed();
        if (this.cancelled) {
            throw new SQLException("The query was cancelled while executing.", "57014");
        }
    }

    void closeIfAllResultsClosed() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        boolean allRsClosed = true;
        if (this.resultSets != null) {
            for (JdbcThinResultSet rs : this.resultSets) {
                if (rs.isClosed()) continue;
                allRsClosed = false;
            }
        }
        if (allRsClosed) {
            this.close();
        }
    }

    void currentRequestMeta(long currReqId, JdbcThinTcpIo currCliIo) {
        assert (Thread.holdsLock(this.cancellationMux));
        this.currReqId = currReqId;
        this.stickyIo = currCliIo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long currentRequestId() {
        Object object = this.cancellationMux;
        synchronized (object) {
            return this.currReqId;
        }
    }

    Object cancellationMutex() {
        return this.cancellationMux;
    }

    private boolean isQueryCancellationSupported() {
        return this.conn.isQueryCancellationSupported();
    }

    int requestTimeout() {
        return this.reqTimeout;
    }
}

