/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.reader;

import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.persistence.wal.WALPointer;
import org.apache.ignite.internal.util.lang.GridIteratorAdapter;
import org.apache.ignite.lang.IgniteBiTuple;

public class FilteredWalIterator
extends GridIteratorAdapter<IgniteBiTuple<WALPointer, WALRecord>>
implements WALIterator {
    private static final long serialVersionUID = 0L;
    private final WALIterator delegateWalIter;
    private final Predicate<IgniteBiTuple<WALPointer, WALRecord>> filter;
    private IgniteBiTuple<WALPointer, WALRecord> next;

    public FilteredWalIterator(WALIterator walIterator, Predicate<IgniteBiTuple<WALPointer, WALRecord>> filter) throws IgniteCheckedException {
        this.filter = filter == null ? r -> true : filter;
        this.delegateWalIter = walIterator;
        this.next = this.nextFilteredRecord();
    }

    @Override
    public Optional<WALPointer> lastRead() {
        return Optional.ofNullable(this.next == null ? null : this.next.get1());
    }

    private IgniteBiTuple<WALPointer, WALRecord> nextFilteredRecord() {
        while (this.delegateWalIter.hasNext()) {
            IgniteBiTuple next = (IgniteBiTuple)this.delegateWalIter.next();
            if (!this.filter.test(next)) continue;
            return next;
        }
        return null;
    }

    @Override
    public IgniteBiTuple<WALPointer, WALRecord> nextX() throws IgniteCheckedException {
        if (!this.hasNextX()) {
            throw new NoSuchElementException();
        }
        IgniteBiTuple<WALPointer, WALRecord> cur = this.next;
        this.next = this.nextFilteredRecord();
        return cur;
    }

    @Override
    public boolean hasNextX() throws IgniteCheckedException {
        return this.next != null;
    }

    @Override
    public void removeX() throws IgniteCheckedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IgniteCheckedException {
        this.delegateWalIter.close();
    }

    @Override
    public boolean isClosed() {
        return this.delegateWalIter.isClosed();
    }
}

