/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.cache.query.QueryMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.events.CacheQueryExecutedEvent;
import org.apache.ignite.events.CacheQueryReadEvent;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridClosureCallMode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheInvalidStateException;
import org.apache.ignite.internal.processors.cache.CacheMetricsImpl;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectUtils;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheManagerAdapter;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtUnreservedPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.query.CacheQuery;
import org.apache.ignite.internal.processors.cache.query.CacheQueryEntry;
import org.apache.ignite.internal.processors.cache.query.CacheQueryFuture;
import org.apache.ignite.internal.processors.cache.query.CacheQueryType;
import org.apache.ignite.internal.processors.cache.query.GridCacheLocalQueryFuture;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryAdapter;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryBean;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryDetailMetricsAdapter;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryDetailMetricsKey;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryInfo;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryMetricsAdapter;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryRequest;
import org.apache.ignite.internal.processors.cache.query.GridCacheQuerySqlMetadataJobV2;
import org.apache.ignite.internal.processors.cache.query.GridCacheQuerySqlMetadataV2;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlIndexMetadata;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlMetadata;
import org.apache.ignite.internal.processors.datastructures.DataStructuresProcessor;
import org.apache.ignite.internal.processors.datastructures.GridSetQueryPredicate;
import org.apache.ignite.internal.processors.datastructures.SetItemKey;
import org.apache.ignite.internal.processors.platform.cache.PlatformCacheEntryFilter;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.query.GridQueryIndexDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.security.SecurityUtils;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.GridBoundedPriorityQueue;
import org.apache.ignite.internal.util.GridCloseableIteratorAdapter;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.GridEmptyCloseableIterator;
import org.apache.ignite.internal.util.GridLeanMap;
import org.apache.ignite.internal.util.GridSpiCloseableIteratorWrapper;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.internal.util.lang.IgniteClosureX;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CIX1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.lang.IgniteReducer;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.spi.IgniteSpiCloseableIterator;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.apache.ignite.spi.indexing.IndexingQueryFilterImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GridCacheQueryManager<K, V>
extends GridCacheManagerAdapter<K, V> {
    private static final int QRY_DETAIL_METRICS_EVICTION_LIMIT = 10000;
    private static final IgniteProductVersion NOT_NULLS_SUPPORT_VER = IgniteProductVersion.fromString("2.3.0");
    private static final Comparator<GridCacheQueryDetailMetricsAdapter> QRY_DETAIL_METRICS_PRIORITY_NEW_CMP = new Comparator<GridCacheQueryDetailMetricsAdapter>(){

        @Override
        public int compare(GridCacheQueryDetailMetricsAdapter m1, GridCacheQueryDetailMetricsAdapter m2) {
            return Long.compare(m1.lastStartTime(), m2.lastStartTime());
        }
    };
    private static final Comparator<GridCacheQueryDetailMetricsAdapter> QRY_DETAIL_METRICS_PRIORITY_OLD_CMP = new Comparator<GridCacheQueryDetailMetricsAdapter>(){

        @Override
        public int compare(GridCacheQueryDetailMetricsAdapter m1, GridCacheQueryDetailMetricsAdapter m2) {
            return Long.compare(m2.lastStartTime(), m1.lastStartTime());
        }
    };
    private static final BiFunction<GridCacheQueryDetailMetricsAdapter, GridCacheQueryDetailMetricsAdapter, GridCacheQueryDetailMetricsAdapter> QRY_DETAIL_METRICS_MERGE_FX = GridCacheQueryDetailMetricsAdapter::aggregate;
    private final boolean isIndexingSpiAllowsBinary = !IgniteSystemProperties.getBoolean("IGNITE_UNWRAP_BINARY_FOR_INDEXING_SPI");
    private GridQueryProcessor qryProc;
    private String cacheName;
    private int maxIterCnt;
    private volatile GridCacheQueryMetricsAdapter metrics;
    private int detailMetricsSz;
    private ConcurrentHashMap<GridCacheQueryDetailMetricsKey, GridCacheQueryDetailMetricsAdapter> detailMetrics;
    private final ConcurrentMap<UUID, RequestFutureMap> qryIters = new ConcurrentHashMap<UUID, RequestFutureMap>();
    private final GridConcurrentHashSet<ScanQueryIterator> locIters = new GridConcurrentHashSet();
    private final ConcurrentMap<UUID, Map<Long, GridFutureAdapter<FieldsResult>>> fieldsQryRes = new ConcurrentHashMap<UUID, Map<Long, GridFutureAdapter<FieldsResult>>>();
    private volatile ConcurrentMap<Object, CachedResult<?>> qryResCache = new ConcurrentHashMap();
    private final GridSpinBusyLock busyLock = new GridSpinBusyLock();
    private GridLocalEventListener lsnr;
    private volatile boolean enabled;
    private volatile boolean qryProcEnabled;
    private AffinityTopologyVersion qryTopVer;

    @Override
    public void start0() throws IgniteCheckedException {
        CacheConfiguration ccfg = this.cctx.config();
        this.qryProcEnabled = QueryUtils.isEnabled(ccfg);
        this.qryProc = this.cctx.kernalContext().query();
        this.cacheName = this.cctx.name();
        this.enabled = this.qryProcEnabled || this.isIndexingSpiEnabled() && !CU.isSystemCache(this.cacheName);
        this.maxIterCnt = ccfg.getMaxQueryIteratorsCount();
        this.detailMetricsSz = ccfg.getQueryDetailMetricsSize();
        if (this.detailMetricsSz > 0) {
            this.detailMetrics = new ConcurrentHashMap(this.detailMetricsSz);
        }
        this.lsnr = new GridLocalEventListener(){

            @Override
            public void onEvent(Event evt) {
                Map fieldsFuts;
                UUID nodeId = ((DiscoveryEvent)evt).eventNode().id();
                Map futs = (Map)GridCacheQueryManager.this.qryIters.remove(nodeId);
                if (futs != null) {
                    for (Map.Entry entry : futs.entrySet()) {
                        final Object rcpt = GridCacheQueryManager.recipient(nodeId, (Long)entry.getKey());
                        ((GridFutureAdapter)entry.getValue()).listen(new CIX1<IgniteInternalFuture<QueryResult<K, V>>>(){

                            @Override
                            public void applyx(IgniteInternalFuture<QueryResult<K, V>> f) throws IgniteCheckedException {
                                f.get().closeIfNotShared(rcpt);
                            }
                        });
                    }
                }
                if ((fieldsFuts = (Map)GridCacheQueryManager.this.fieldsQryRes.remove(nodeId)) != null) {
                    for (Map.Entry entry : fieldsFuts.entrySet()) {
                        final Object rcpt = GridCacheQueryManager.recipient(nodeId, (Long)entry.getKey());
                        ((GridFutureAdapter)entry.getValue()).listen(new CIX1<IgniteInternalFuture<FieldsResult>>(){

                            @Override
                            public void applyx(IgniteInternalFuture<FieldsResult> f) throws IgniteCheckedException {
                                f.get().closeIfNotShared(rcpt);
                            }
                        });
                    }
                }
            }
        };
        this.metrics = new GridCacheQueryMetricsAdapter(this.cctx.kernalContext().metric(), this.cctx.name(), this.cctx.isNear());
        this.cctx.events().addListener(this.lsnr, 11, 12);
        this.qryTopVer = this.cctx.startTopologyVersion();
        assert (this.qryTopVer != null) : this.cctx.name();
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void enable() {
        this.qryProcEnabled = true;
        this.enabled = true;
    }

    @Override
    protected void onKernalStop0(boolean cancel) {
        this.busyLock.block();
        this.cctx.events().removeListener(this.lsnr);
        if (cancel) {
            this.onCancelAtStop();
        } else {
            this.onWaitAtStop();
        }
    }

    private boolean enterBusy() {
        return this.busyLock.enterBusy();
    }

    private void leaveBusy() {
        this.busyLock.leaveBusy();
    }

    @Override
    public final void stop0(boolean cancel, boolean destroy) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopped cache query manager.");
        }
    }

    void onQueryFutureCanceled(long reqId) {
    }

    void onCancelAtStop() {
    }

    void onWaitAtStop() {
    }

    void processQueryRequest(UUID sndId, GridCacheQueryRequest req) {
    }

    private boolean isIndexingSpiEnabled() {
        return this.cctx.kernalContext().indexing().enabled();
    }

    private void invalidateResultCache() {
        if (!this.qryResCache.isEmpty()) {
            this.qryResCache = new ConcurrentHashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(CacheDataRow newRow, @Nullable CacheDataRow prevRow, boolean prevRowAvailable) throws IgniteCheckedException {
        assert (this.enabled());
        assert (newRow != null && newRow.value() != null && newRow.link() != 0L) : newRow;
        if (!this.enterBusy()) {
            throw new NodeStoppingException("Operation has been cancelled (node is stopping).");
        }
        try {
            if (this.isIndexingSpiEnabled()) {
                CacheObjectContext coctx = this.cctx.cacheObjectContext();
                Object key0 = this.unwrapIfNeeded(newRow.key(), coctx);
                Object val0 = this.unwrapIfNeeded(newRow.value(), coctx);
                this.cctx.kernalContext().indexing().store(this.cacheName, key0, val0, newRow.expireTime());
            }
            if (this.qryProcEnabled) {
                this.qryProc.store(this.cctx, newRow, prevRow, prevRowAvailable);
            }
        }
        finally {
            this.invalidateResultCache();
            this.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(KeyCacheObject key, @Nullable CacheDataRow prevRow) throws IgniteCheckedException {
        if (!this.qryProcEnabled) {
            return;
        }
        if (!this.enterBusy()) {
            return;
        }
        try {
            if (this.isIndexingSpiEnabled()) {
                Object key0 = this.unwrapIfNeeded(key, this.cctx.cacheObjectContext());
                this.cctx.kernalContext().indexing().remove(this.cacheName, key0);
            }
            if (this.qryProcEnabled && prevRow != null) {
                this.qryProc.remove(this.cctx, prevRow);
            }
        }
        finally {
            this.invalidateResultCache();
            this.leaveBusy();
        }
    }

    CacheQueryFuture<?> queryLocal(GridCacheQueryBean qry) {
        GridCacheLocalQueryFuture fut;
        block4: {
            assert (qry.query().type() != GridCacheQueryType.SCAN) : qry;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Executing query on local node: " + qry);
            }
            fut = new GridCacheLocalQueryFuture(this.cctx, qry);
            try {
                qry.query().validate();
                fut.execute();
            }
            catch (IgniteCheckedException e) {
                if (fut == null) break block4;
                fut.onDone(e);
            }
        }
        return fut;
    }

    public abstract CacheQueryFuture<?> queryDistributed(GridCacheQueryBean var1, Collection<ClusterNode> var2);

    public abstract GridCloseableIterator scanQueryDistributed(GridCacheQueryAdapter var1, Collection<ClusterNode> var2) throws IgniteCheckedException;

    public abstract void loadPage(long var1, GridCacheQueryAdapter<?> var3, Collection<ClusterNode> var4, boolean var5);

    public abstract CacheQueryFuture<?> queryFieldsLocal(GridCacheQueryBean var1);

    public abstract CacheQueryFuture<?> queryFieldsDistributed(GridCacheQueryBean var1, Collection<ClusterNode> var2);

    private Object unwrapIfNeeded(CacheObject obj, CacheObjectContext coctx) {
        return this.isIndexingSpiAllowsBinary && this.cctx.cacheObjects().isBinaryObject(obj) ? obj : obj.value(coctx, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryResult<K, V> executeQuery(GridCacheQueryAdapter<?> qry, @Nullable Object[] args, IgniteClosure transformer, boolean loc, @Nullable UUID subjId, @Nullable String taskName, Object rcpt) throws IgniteCheckedException {
        QueryResult res;
        block22: {
            if (qry.type() == null) {
                assert (!loc);
                throw new IgniteCheckedException("Received next page request after iterator was removed. Consider increasing maximum number of stored iterators (see CacheConfiguration.getMaxQueryIteratorsCount() configuration property).");
            }
            T3<String, String, List<Object[]>> resKey = null;
            if (qry.type() == GridCacheQueryType.SQL) {
                resKey = new T3<String, String, List<Object[]>>(qry.queryClassName(), qry.clause(), F.asList(args));
                res = (QueryResult)this.qryResCache.get(resKey);
                if (res != null && res.addRecipient(rcpt)) {
                    return res;
                }
                res = new QueryResult(qry.type(), rcpt);
                if (this.qryResCache.putIfAbsent(resKey, res) != null) {
                    resKey = null;
                }
            } else {
                res = new QueryResult(qry.type(), rcpt);
            }
            try {
                GridCloseableIterator iter;
                switch (qry.type()) {
                    case SQL: {
                        throw new IllegalStateException("Should never be called.");
                    }
                    case SCAN: {
                        if (this.cctx.events().isRecordable(96)) {
                            this.cctx.gridEvents().record(new CacheQueryExecutedEvent(this.cctx.localNode(), "Scan query executed.", 96, CacheQueryType.SCAN.name(), this.cctx.name(), null, null, qry.scanFilter(), null, null, subjId, taskName));
                        }
                        iter = this.scanIterator(qry, transformer, false);
                        break;
                    }
                    case TEXT: {
                        if (this.cctx.events().isRecordable(96)) {
                            this.cctx.gridEvents().record(new CacheQueryExecutedEvent(this.cctx.localNode(), "Full text query executed.", 96, CacheQueryType.FULL_TEXT.name(), this.cctx.name(), qry.queryClassName(), qry.clause(), null, null, null, subjId, taskName));
                        }
                        iter = this.qryProc.queryText(this.cacheName, qry.clause(), qry.queryClassName(), this.filter(qry), qry.limit());
                        break;
                    }
                    case SET: {
                        iter = this.sharedCacheSetIterator(qry);
                        break;
                    }
                    case SQL_FIELDS: {
                        assert (false) : "SQL fields query is incorrectly processed.";
                    }
                    default: {
                        throw new IgniteCheckedException("Unknown query type: " + (Object)((Object)qry.type()));
                    }
                }
                res.onDone(iter);
                if (resKey == null) break block22;
                this.qryResCache.remove(resKey, res);
            }
            catch (Exception e) {
                res.onDone(e);
            }
            finally {
                if (resKey != null) {
                    this.qryResCache.remove(resKey, res);
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FieldsResult executeFieldsQuery(GridCacheQueryAdapter<?> qry, @Nullable Object[] args, boolean loc, @Nullable UUID subjId, @Nullable String taskName, Object rcpt) throws IgniteCheckedException {
        FieldsResult res;
        block17: {
            assert (qry != null);
            T2<String, List<Object[]>> resKey = null;
            if (qry.clause() == null && qry.type() != GridCacheQueryType.SPI) {
                assert (!loc);
                throw new IgniteCheckedException("Received next page request after iterator was removed. Consider increasing maximum number of stored iterators (see CacheConfiguration.getMaxQueryIteratorsCount() configuration property).");
            }
            if (qry.type() == GridCacheQueryType.SQL_FIELDS) {
                if (this.cctx.events().isRecordable(96)) {
                    this.cctx.gridEvents().record(new CacheQueryExecutedEvent(this.cctx.localNode(), "SQL fields query executed.", 96, CacheQueryType.SQL_FIELDS.name(), this.cctx.name(), null, qry.clause(), null, null, args, subjId, taskName));
                }
                if ((res = (FieldsResult)this.qryResCache.get(resKey = new T2<String, List<Object[]>>(qry.clause(), F.asList(args)))) != null && res.addRecipient(rcpt)) {
                    return res;
                }
                res = new FieldsResult(rcpt);
                if (this.qryResCache.putIfAbsent(resKey, res) != null) {
                    resKey = null;
                }
            } else {
                assert (qry.type() == GridCacheQueryType.SPI) : "Unexpected query type: " + (Object)((Object)qry.type());
                if (this.cctx.events().isRecordable(96)) {
                    this.cctx.gridEvents().record(new CacheQueryExecutedEvent(this.cctx.localNode(), "SPI query executed.", 96, CacheQueryType.SPI.name(), this.cctx.name(), null, null, null, null, args, subjId, taskName));
                }
                res = new FieldsResult(rcpt);
            }
            try {
                if (qry.type() != GridCacheQueryType.SPI) {
                    assert (qry.type() == GridCacheQueryType.SQL_FIELDS);
                    throw new IllegalStateException("Should never be called.");
                }
                IgniteSpiCloseableIterator<?> iter = this.cctx.kernalContext().indexing().query(this.cacheName, F.asList(args), this.filter(qry));
                res.onDone(iter);
                if (resKey == null) break block17;
                this.qryResCache.remove(resKey, res);
            }
            catch (Exception e) {
                try {
                    res.onDone(e);
                    if (resKey == null) break block17;
                    this.qryResCache.remove(resKey, res);
                }
                catch (Throwable throwable) {
                    if (resKey != null) {
                        this.qryResCache.remove(resKey, res);
                    }
                    throw throwable;
                }
            }
        }
        return res;
    }

    private GridCloseableIterator<IgniteBiTuple<K, V>> sharedCacheSetIterator(GridCacheQueryAdapter<?> qry) throws IgniteCheckedException {
        GridSetQueryPredicate filter = (GridSetQueryPredicate)qry.scanFilter();
        final IgniteUuid id = filter.setId();
        GridCacheQueryAdapter qry0 = new GridCacheQueryAdapter(this.cctx, GridCacheQueryType.SCAN, new IgniteBiPredicate<Object, Object>(){

            @Override
            public boolean apply(Object k, Object v) {
                return k instanceof SetItemKey && id.equals(((SetItemKey)k).setId());
            }
        }, new IgniteClosure<Map.Entry, Object>(){

            @Override
            public Object apply(Map.Entry entry) {
                return new IgniteBiTuple<Object, Boolean>(((SetItemKey)entry.getKey()).item(), Boolean.TRUE);
            }
        }, qry.partition(), false, true, qry.isDataPageScanEnabled());
        return this.scanQueryLocal(qry0, false);
    }

    private GridCloseableIterator scanIterator(GridCacheQueryAdapter<?> qry, IgniteClosure transformer, boolean locNode) throws IgniteCheckedException {
        assert (!this.cctx.mvccEnabled() || qry.mvccSnapshot() != null);
        IgniteBiPredicate keyValFilter = qry.scanFilter();
        final InternalScanFilter intFilter = keyValFilter != null ? new InternalScanFilter(keyValFilter) : null;
        try {
            GridIterator<CacheDataRow> it;
            GridDhtLocalPartition locPart;
            GridDhtCacheAdapter dht;
            boolean backups;
            Integer part;
            if (keyValFilter instanceof PlatformCacheEntryFilter) {
                ((PlatformCacheEntryFilter)keyValFilter).cacheContext(this.cctx);
            } else {
                this.injectResources(keyValFilter);
            }
            Integer n = part = this.cctx.isLocal() ? null : qry.partition();
            if (part != null && (part < 0 || part >= this.cctx.affinity().partitions())) {
                return new GridEmptyCloseableIterator(){

                    @Override
                    public void close() throws IgniteCheckedException {
                        if (intFilter != null) {
                            intFilter.close();
                        }
                        super.close();
                    }
                };
            }
            AffinityTopologyVersion topVer = GridQueryProcessor.getRequestAffinityTopologyVersion();
            if (topVer == null) {
                topVer = this.cctx.affinity().affinityTopologyVersion();
            }
            boolean bl = backups = qry.includeBackups() || this.cctx.isReplicated();
            if (part != null) {
                dht = this.cctx.isNear() ? this.cctx.near().dht() : this.cctx.dht();
                GridDhtLocalPartition locPart0 = dht.topology().localPartition(part, topVer, false);
                if (locPart0 == null || locPart0.state() != GridDhtPartitionState.OWNING || !locPart0.reserve()) {
                    throw locPart0 != null && locPart0.state() == GridDhtPartitionState.LOST ? new CacheInvalidStateException("Failed to execute scan query because cache partition has been lost [cacheName=" + this.cctx.name() + ", part=" + part + "]") : new GridDhtUnreservedPartitionException(part, this.cctx.affinity().affinityTopologyVersion(), "Partition can not be reserved");
                }
                locPart = locPart0;
                it = this.cctx.offheap().cachePartitionIterator(this.cctx.cacheId(), part, qry.mvccSnapshot(), qry.isDataPageScanEnabled());
            } else {
                Set<Integer> lostParts;
                locPart = null;
                if (!this.cctx.isLocal() && !(lostParts = (dht = this.cctx.isNear() ? this.cctx.near().dht() : this.cctx.dht()).topology().lostPartitions()).isEmpty()) {
                    throw new CacheInvalidStateException("Failed to execute scan query because cache partition has been lost [cacheName=" + this.cctx.name() + ", part=" + lostParts.iterator().next() + "]");
                }
                it = this.cctx.offheap().cacheIterator(this.cctx.cacheId(), true, backups, topVer, qry.mvccSnapshot(), qry.isDataPageScanEnabled());
            }
            ScanQueryIterator iter = new ScanQueryIterator(it, qry, topVer, locPart, SecurityUtils.sandboxedProxy(this.cctx.kernalContext(), IgniteBiPredicate.class, keyValFilter), SecurityUtils.sandboxedProxy(this.cctx.kernalContext(), IgniteClosure.class, transformer), locNode, locNode ? this.locIters : null, this.cctx, this.log);
            if (locNode) {
                ScanQueryIterator old = this.locIters.addx(iter);
                assert (old == null);
            }
            return iter;
        }
        catch (RuntimeException | IgniteCheckedException e) {
            if (intFilter != null) {
                intFilter.close();
            }
            throw e;
        }
    }

    private void injectResources(@Nullable Object o) throws IgniteCheckedException {
        if (o != null) {
            GridKernalContext ctx = this.cctx.kernalContext();
            ClassLoader ldr = o.getClass().getClassLoader();
            if (ctx.deploy().isGlobalLoader(ldr)) {
                ctx.resource().inject(ctx.deploy().getDeployment(ctx.deploy().getClassLoaderId(ldr)), o.getClass(), o);
            } else {
                ctx.resource().inject(ctx.deploy().getDeployment(o.getClass().getName()), o.getClass(), o);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runFieldsQuery(GridCacheQueryInfo qryInfo) {
        assert (qryInfo != null);
        if (!this.enterBusy()) {
            if (!this.cctx.localNodeId().equals(qryInfo.senderId())) return;
            throw new IllegalStateException("Failed to process query request (grid is stopping).");
        }
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Running query: " + qryInfo);
            }
            boolean rmvRes = true;
            CachedResult res = null;
            boolean statsEnabled = this.cctx.statisticsEnabled();
            boolean readEvt = this.cctx.events().isRecordable(97);
            try {
                ArrayList<GridQueryFieldMetadata> meta;
                IgniteReducer<?, Object> rdc = qryInfo.reducer();
                this.injectResources(rdc);
                GridCacheQueryAdapter<?> qry = qryInfo.query();
                int pageSize = qry.pageSize();
                List<Object> data = null;
                ArrayList entities = null;
                if (qryInfo.local() || rdc != null || this.cctx.isLocalNode(qryInfo.senderId())) {
                    data = new ArrayList(pageSize);
                } else {
                    entities = new ArrayList(pageSize);
                }
                String taskName = this.cctx.kernalContext().task().resolveTaskName(qry.taskHash());
                CachedResult cachedResult = res = qryInfo.local() ? this.executeFieldsQuery(qry, qryInfo.arguments(), qryInfo.local(), qry.subjectId(), taskName, GridCacheQueryManager.recipient(qryInfo.senderId(), qryInfo.requestId())) : this.fieldsQueryResult(qryInfo, taskName);
                ArrayList<GridQueryFieldMetadata> arrayList = qryInfo.includeMetaData() ? (((FieldsResult)res).metaData() != null ? new ArrayList<GridQueryFieldMetadata>(((FieldsResult)res).metaData()) : null) : (meta = ((FieldsResult)res).metaData());
                if (!qryInfo.includeMetaData()) {
                    meta = null;
                }
                GridSpiCloseableIteratorWrapper it = new GridSpiCloseableIteratorWrapper(res.iterator(GridCacheQueryManager.recipient(qryInfo.senderId(), qryInfo.requestId())));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received fields iterator [iterHasNext=" + it.hasNext() + ']');
                }
                if (!it.hasNext()) {
                    if (rdc != null) {
                        data = Collections.singletonList(rdc.reduce());
                    }
                    this.onFieldsPageReady(qryInfo.local(), qryInfo, meta, entities, data, true, null);
                    return;
                }
                int cnt = 0;
                boolean metaSent = false;
                while (!Thread.currentThread().isInterrupted() && it.hasNext()) {
                    long start = statsEnabled ? System.nanoTime() : 0L;
                    Object row = it.next();
                    if (row == null) {
                        this.onPageReady(qryInfo.local(), qryInfo, null, true, null);
                        break;
                    }
                    if (statsEnabled) {
                        CacheMetricsImpl metrics = this.cctx.cache().metrics0();
                        metrics.onRead(true);
                        metrics.addGetTimeNanos(System.nanoTime() - start);
                    }
                    if (readEvt && this.cctx.gridEvents().hasListener(97)) {
                        this.cctx.gridEvents().record(new CacheQueryReadEvent<Object, Object>(this.cctx.localNode(), "SQL fields query result set row read.", 97, CacheQueryType.SQL_FIELDS.name(), this.cctx.name(), null, qry.clause(), null, null, qryInfo.arguments(), qry.subjectId(), taskName, null, null, null, row));
                    }
                    if (qryInfo.local() || rdc != null || this.cctx.isLocalNode(qryInfo.senderId())) {
                        if (rdc != null) {
                            if (!rdc.collect(row)) {
                                break;
                            }
                        } else {
                            data.add(row);
                        }
                    } else {
                        entities.add(row);
                    }
                    if (rdc != null || (qryInfo.allPages() || ++cnt != pageSize) && it.hasNext()) continue;
                    this.onFieldsPageReady(qryInfo.local(), qryInfo, !metaSent ? meta : null, entities, data, !it.hasNext(), null);
                    if (it.hasNext()) {
                        rmvRes = false;
                    }
                    if (qryInfo.allPages()) continue;
                    return;
                }
                if (rdc == null) return;
                this.onFieldsPageReady(qryInfo.local(), qryInfo, meta, null, Collections.singletonList(rdc.reduce()), true, null);
                return;
            }
            catch (IgniteCheckedException e) {
                if (this.log.isDebugEnabled() || !e.hasCause(SQLException.class)) {
                    U.error(this.log, "Failed to run fields query [qry=" + qryInfo + ", node=" + this.cctx.nodeId() + ']', e);
                } else if (e.hasCause(SQLException.class)) {
                    U.error(this.log, "Failed to run fields query [node=" + this.cctx.nodeId() + ", msg=" + e.getCause(SQLException.class).getMessage() + ']');
                } else {
                    U.error(this.log, "Failed to run fields query [node=" + this.cctx.nodeId() + ", msg=" + e.getMessage() + ']');
                }
                this.onFieldsPageReady(qryInfo.local(), qryInfo, null, null, null, true, e);
                return;
            }
            catch (Throwable e) {
                block55: {
                    U.error(this.log, "Failed to run fields query [qry=" + qryInfo + ", node=" + this.cctx.nodeId() + "]", e);
                    this.onFieldsPageReady(qryInfo.local(), qryInfo, null, null, null, true, e);
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    if (!qryInfo.local()) break block55;
                    if (!rmvRes) return;
                    if (res == null) return;
                    try {
                        res.closeIfNotShared(GridCacheQueryManager.recipient(qryInfo.senderId(), qryInfo.requestId()));
                        return;
                    }
                    catch (IgniteCheckedException e2) {
                        U.error(this.log, "Failed to close local iterator [qry=" + qryInfo + ", node=" + this.cctx.nodeId() + "]", e2);
                        return;
                    }
                }
                if (!rmvRes) return;
                this.removeFieldsQueryResult(qryInfo.senderId(), qryInfo.requestId());
                return;
            }
            finally {
                if (qryInfo.local()) {
                    if (rmvRes && res != null) {
                        try {
                            res.closeIfNotShared(GridCacheQueryManager.recipient(qryInfo.senderId(), qryInfo.requestId()));
                        }
                        catch (IgniteCheckedException e) {
                            U.error(this.log, "Failed to close local iterator [qry=" + qryInfo + ", node=" + this.cctx.nodeId() + "]", e);
                        }
                    }
                } else if (rmvRes) {
                    this.removeFieldsQueryResult(qryInfo.senderId(), qryInfo.requestId());
                }
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * Exception decompiling
     */
    protected void runQuery(GridCacheQueryInfo qryInfo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 25[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected GridCloseableIterator scanQueryLocal(GridCacheQueryAdapter qry, boolean updateStatistics) throws IgniteCheckedException {
        if (!this.enterBusy()) {
            throw new IllegalStateException("Failed to process query request (grid is stopping).");
        }
        boolean statsEnabled = this.cctx.statisticsEnabled();
        updateStatistics &= statsEnabled;
        long startTime = U.currentTimeMillis();
        String namex = this.cctx.name();
        InternalScanFilter intFilter = qry.scanFilter() != null ? new InternalScanFilter(qry.scanFilter()) : null;
        try {
            assert (qry.type() == GridCacheQueryType.SCAN);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Running local SCAN query: " + qry);
            }
            String taskName = this.cctx.kernalContext().task().resolveTaskName(qry.taskHash());
            ClusterNode locNode = this.cctx.localNode();
            UUID subjId = qry.subjectId();
            if (this.cctx.events().isRecordable(96)) {
                this.cctx.gridEvents().record(new CacheQueryExecutedEvent(locNode, "Scan query executed.", 96, CacheQueryType.SCAN.name(), namex, null, null, intFilter != null ? intFilter.scanFilter() : null, null, null, subjId, taskName));
            }
            IgniteClosure transformer = qry.transform();
            this.injectResources(transformer);
            GridCloseableIterator it = this.scanIterator(qry, transformer, true);
            updateStatistics = false;
            GridCloseableIterator gridCloseableIterator = it;
            return gridCloseableIterator;
        }
        catch (Exception e) {
            if (intFilter != null) {
                intFilter.close();
            }
            if (updateStatistics) {
                this.cctx.queries().collectMetrics(GridCacheQueryType.SCAN, namex, startTime, U.currentTimeMillis() - startTime, true);
            }
            throw e;
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private QueryResult<K, V> queryResult(GridCacheQueryInfo qryInfo, String taskName) throws IgniteCheckedException {
        GridFutureAdapter<QueryResult<K, V>> fut;
        block12: {
            RequestFutureMap old;
            assert (qryInfo != null);
            final UUID sndId = qryInfo.senderId();
            assert (sndId != null);
            RequestFutureMap futs = (RequestFutureMap)this.qryIters.get(sndId);
            if (futs == null && (old = this.qryIters.putIfAbsent(sndId, futs = new RequestFutureMap(){

                @Override
                protected boolean removeEldestEntry(Map.Entry<Long, GridFutureAdapter<QueryResult<K, V>>> e) {
                    boolean rmv;
                    boolean bl = rmv = this.size() > GridCacheQueryManager.this.maxIterCnt;
                    if (rmv) {
                        try {
                            e.getValue().get().closeIfNotShared(GridCacheQueryManager.recipient(sndId, e.getKey()));
                        }
                        catch (IgniteCheckedException ex) {
                            U.error(GridCacheQueryManager.this.log, "Failed to close query iterator.", ex);
                        }
                    }
                    return rmv;
                }
            })) != null) {
                futs = old;
            }
            assert (futs != null);
            boolean exec = false;
            RequestFutureMap requestFutureMap = futs;
            synchronized (requestFutureMap) {
                if (futs.isCanceled(qryInfo.requestId())) {
                    return null;
                }
                fut = (GridFutureAdapter<QueryResult<K, V>>)futs.get(qryInfo.requestId());
                if (fut == null) {
                    fut = new GridFutureAdapter<QueryResult<K, V>>();
                    futs.put(qryInfo.requestId(), fut);
                    exec = true;
                }
            }
            if (exec) {
                try {
                    fut.onDone(this.executeQuery(qryInfo.query(), qryInfo.arguments(), qryInfo.transformer(), false, qryInfo.query().subjectId(), taskName, GridCacheQueryManager.recipient(qryInfo.senderId(), qryInfo.requestId())));
                }
                catch (Throwable e) {
                    fut.onDone(e);
                    if (!(e instanceof Error)) break block12;
                    throw (Error)e;
                }
            }
        }
        return (QueryResult)fut.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueryResult(@Nullable UUID sndId, long reqId) {
        block8: {
            if (sndId == null) {
                return;
            }
            RequestFutureMap futs = (RequestFutureMap)this.qryIters.get(sndId);
            if (futs != null) {
                Object fut;
                RequestFutureMap requestFutureMap = futs;
                synchronized (requestFutureMap) {
                    fut = futs.remove(reqId);
                }
                if (fut != null) {
                    try {
                        ((QueryResult)fut.get()).closeIfNotShared(GridCacheQueryManager.recipient(sndId, reqId));
                    }
                    catch (IgniteCheckedException e) {
                        if (X.hasCause((Throwable)e, GridDhtUnreservedPartitionException.class)) break block8;
                        U.error(this.log, "Failed to close iterator.", e);
                    }
                }
            }
        }
    }

    private static Object recipient(UUID sndId, long reqId) {
        assert (sndId != null);
        return new IgniteBiTuple<UUID, Long>(sndId, reqId);
    }

    private FieldsResult fieldsQueryResult(GridCacheQueryInfo qryInfo, String taskName) throws IgniteCheckedException {
        Map<Long, GridFutureAdapter<FieldsResult>> old;
        final UUID sndId = qryInfo.senderId();
        assert (sndId != null);
        Map<Long, GridFutureAdapter<FieldsResult>> iters = (Map<Long, GridFutureAdapter<FieldsResult>>)this.fieldsQryRes.get(sndId);
        if (iters == null && (old = this.fieldsQryRes.putIfAbsent(sndId, iters = new LinkedHashMap<Long, GridFutureAdapter<FieldsResult>>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Long, GridFutureAdapter<FieldsResult>> e) {
                boolean rmv;
                boolean bl = rmv = this.size() > GridCacheQueryManager.this.maxIterCnt;
                if (rmv) {
                    try {
                        e.getValue().get().closeIfNotShared(GridCacheQueryManager.recipient(sndId, e.getKey()));
                    }
                    catch (IgniteCheckedException ex) {
                        U.error(GridCacheQueryManager.this.log, "Failed to close fields query iterator.", ex);
                    }
                }
                return rmv;
            }

            @Override
            public boolean equals(Object o) {
                return o == this;
            }
        })) != null) {
            iters = old;
        }
        return this.fieldsQueryResult(iters, qryInfo, taskName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FieldsResult fieldsQueryResult(Map<Long, GridFutureAdapter<FieldsResult>> resMap, GridCacheQueryInfo qryInfo, String taskName) throws IgniteCheckedException {
        GridFutureAdapter<FieldsResult<Object>> fut;
        assert (resMap != null);
        assert (qryInfo != null);
        boolean exec = false;
        Map<Long, GridFutureAdapter<FieldsResult>> map = resMap;
        synchronized (map) {
            fut = resMap.get(qryInfo.requestId());
            if (fut == null) {
                fut = new GridFutureAdapter();
                resMap.put(qryInfo.requestId(), fut);
                exec = true;
            }
        }
        if (exec) {
            try {
                fut.onDone(this.executeFieldsQuery(qryInfo.query(), qryInfo.arguments(), false, qryInfo.query().subjectId(), taskName, GridCacheQueryManager.recipient(qryInfo.senderId(), qryInfo.requestId())));
            }
            catch (IgniteCheckedException e) {
                fut.onDone(e);
            }
        }
        return fut.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFieldsQueryResult(@Nullable UUID sndId, long reqId) {
        if (sndId == null) {
            return;
        }
        Map futs = (Map)this.fieldsQryRes.get(sndId);
        if (futs != null) {
            IgniteInternalFuture fut;
            Map map = futs;
            synchronized (map) {
                fut = (IgniteInternalFuture)futs.remove(reqId);
            }
            if (fut != null) {
                assert (fut.isDone());
                try {
                    ((FieldsResult)fut.get()).closeIfNotShared(GridCacheQueryManager.recipient(sndId, reqId));
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to close iterator.", e);
                }
            }
        }
    }

    protected abstract boolean onPageReady(boolean var1, GridCacheQueryInfo var2, @Nullable Collection<?> var3, boolean var4, @Nullable Throwable var5);

    protected abstract boolean onFieldsPageReady(boolean var1, GridCacheQueryInfo var2, @Nullable List<GridQueryFieldMetadata> var3, @Nullable Collection<?> var4, @Nullable Collection<?> var5, boolean var6, @Nullable Throwable var7);

    public QueryMetrics metrics() {
        return this.metrics.snapshot();
    }

    public Collection<GridCacheQueryDetailMetricsAdapter> detailMetrics() {
        if (this.detailMetricsSz > 0) {
            if (this.detailMetrics.size() > this.detailMetricsSz) {
                GridBoundedPriorityQueue<GridCacheQueryDetailMetricsAdapter> latestMetrics = new GridBoundedPriorityQueue<GridCacheQueryDetailMetricsAdapter>(this.detailMetricsSz, QRY_DETAIL_METRICS_PRIORITY_NEW_CMP);
                latestMetrics.addAll(this.detailMetrics.values());
                return latestMetrics;
            }
            return new ArrayList<GridCacheQueryDetailMetricsAdapter>(this.detailMetrics.values());
        }
        return Collections.emptyList();
    }

    public void evictDetailMetrics() {
        int sz;
        if (this.detailMetricsSz > 0 && (sz = this.detailMetrics.size()) > this.detailMetricsSz) {
            int evictCnt = Math.min(10000, sz - this.detailMetricsSz);
            GridBoundedPriorityQueue<GridCacheQueryDetailMetricsAdapter> metricsToEvict = new GridBoundedPriorityQueue<GridCacheQueryDetailMetricsAdapter>(evictCnt, QRY_DETAIL_METRICS_PRIORITY_OLD_CMP);
            metricsToEvict.addAll(this.detailMetrics.values());
            for (GridCacheQueryDetailMetricsAdapter m : metricsToEvict) {
                this.detailMetrics.remove(m.key());
            }
        }
    }

    public void resetMetrics() {
        this.metrics.reset();
    }

    public void resetDetailMetrics() {
        if (this.detailMetrics != null) {
            this.detailMetrics.clear();
        }
    }

    public void collectMetrics(GridCacheQueryType qryType, String qry, long startTime, long duration, boolean failed) {
        this.metrics.update(duration, failed);
        if (this.detailMetricsSz > 0) {
            if (qryType == GridCacheQueryType.SQL_FIELDS && !F.isEmpty(qry)) {
                int off;
                int len = qry.length();
                for (off = 0; off < len && Character.isWhitespace(qry.charAt(off)); ++off) {
                }
                if (qry.regionMatches(true, off, "EXPLAIN", 0, 7)) {
                    return;
                }
            }
            GridCacheQueryDetailMetricsAdapter m = new GridCacheQueryDetailMetricsAdapter(qryType, qry, this.cctx.name(), startTime, duration, failed);
            GridCacheQueryDetailMetricsKey key = m.key();
            this.detailMetrics.merge(key, m, QRY_DETAIL_METRICS_MERGE_FX);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteInternalFuture<Collection<GridCacheSqlMetadata>> sqlMetadataAsync() throws IgniteCheckedException {
        if (!this.enterBusy()) {
            throw new IllegalStateException("Failed to get metadata (grid is stopping).");
        }
        try {
            MetadataJob job = new MetadataJob();
            Collection<ClusterNode> nodes = CU.affinityNodes(this.cctx, AffinityTopologyVersion.NONE);
            final ArrayList<Collection<CacheSqlMetadata>> res = new ArrayList<Collection<CacheSqlMetadata>>(nodes.size() + 1);
            IgniteInternalFuture<Collection<Collection<Collection<CacheSqlMetadata>>>> rmtFut = null;
            if (!nodes.isEmpty()) {
                rmtFut = this.cctx.closures().callAsyncNoFailover(GridClosureCallMode.BROADCAST, Collections.singleton(job), nodes, true, 0L);
            }
            IgniteInternalFuture<Collection<CacheSqlMetadata>> locFut = this.cctx.closures().callLocalSafe(job, true);
            res.add(locFut.get());
            if (rmtFut == null) {
                GridFinishedFuture<Collection<GridCacheSqlMetadata>> gridFinishedFuture = new GridFinishedFuture<Collection<GridCacheSqlMetadata>>(this.convertMetadata(res));
                return gridFinishedFuture;
            }
            IgniteInternalFuture<Collection<GridCacheSqlMetadata>> igniteInternalFuture = rmtFut.chain(new IgniteClosureX<IgniteInternalFuture<Collection<Collection<CacheSqlMetadata>>>, Collection<GridCacheSqlMetadata>>(){

                @Override
                public Collection<GridCacheSqlMetadata> applyx(IgniteInternalFuture<Collection<Collection<CacheSqlMetadata>>> fut) throws IgniteCheckedException {
                    res.addAll(fut.get());
                    return GridCacheQueryManager.this.convertMetadata(res);
                }
            });
            return igniteInternalFuture;
        }
        finally {
            this.leaveBusy();
        }
    }

    @NotNull
    private Collection<GridCacheSqlMetadata> convertMetadata(Collection<Collection<CacheSqlMetadata>> res) {
        HashMap<String, Collection> map = new HashMap<String, Collection>();
        for (Collection<CacheSqlMetadata> col : res) {
            for (CacheSqlMetadata meta : col) {
                String name = meta.cacheName();
                Collection cacheMetas = map.computeIfAbsent(name, k -> new LinkedList());
                cacheMetas.add(meta);
            }
        }
        ArrayList<GridCacheSqlMetadata> col = new ArrayList<GridCacheSqlMetadata>(map.size());
        col.add(new CacheSqlMetadata((Iterable)map.remove(this.cacheName)));
        for (Collection metas : map.values()) {
            col.add(new CacheSqlMetadata(metas));
        }
        return col;
    }

    public Collection<GridCacheSqlMetadata> sqlMetadata() throws IgniteCheckedException {
        return this.sqlMetadataAsync().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<GridCacheSqlMetadata> sqlMetadataV2() throws IgniteCheckedException {
        if (!this.enterBusy()) {
            throw new IllegalStateException("Failed to get metadata (grid is stopping).");
        }
        try {
            GridCacheQuerySqlMetadataJobV2 job = new GridCacheQuerySqlMetadataJobV2();
            Collection<ClusterNode> nodes = CU.affinityNodes(this.cctx, AffinityTopologyVersion.NONE);
            ArrayList<Collection<CacheSqlMetadata>> res = new ArrayList<Collection<CacheSqlMetadata>>(nodes.size() + 1);
            IgniteInternalFuture rmtFut = null;
            if (!nodes.isEmpty()) {
                boolean allNodesNew = true;
                for (ClusterNode clusterNode : nodes) {
                    if (clusterNode.version().compareTo(NOT_NULLS_SUPPORT_VER) >= 0) continue;
                    allNodesNew = false;
                }
                if (!allNodesNew) {
                    Collection<GridCacheSqlMetadata> collection = this.sqlMetadata();
                    return collection;
                }
                rmtFut = this.cctx.closures().callAsyncNoFailover(GridClosureCallMode.BROADCAST, Collections.singleton(job), nodes, true, 0L);
            }
            IgniteInternalFuture<Collection<CacheSqlMetadata>> locFut = this.cctx.closures().callLocalSafe(job, true);
            if (rmtFut != null) {
                res.addAll((Collection)rmtFut.get());
            }
            res.add(locFut.get());
            HashMap<String, LinkedList<CacheSqlMetadata>> map = new HashMap<String, LinkedList<CacheSqlMetadata>>();
            for (Collection collection : res) {
                for (CacheSqlMetadata meta : collection) {
                    String name = meta.cacheName();
                    LinkedList<CacheSqlMetadata> cacheMetas = (LinkedList<CacheSqlMetadata>)map.get(name);
                    if (cacheMetas == null) {
                        cacheMetas = new LinkedList<CacheSqlMetadata>();
                        map.put(name, cacheMetas);
                    }
                    cacheMetas.add(meta);
                }
            }
            ArrayList<GridCacheSqlMetadata> arrayList = new ArrayList<GridCacheSqlMetadata>(map.size());
            arrayList.add(new GridCacheQuerySqlMetadataV2((Iterable)map.remove(this.cacheName)));
            for (Collection metas : map.values()) {
                arrayList.add(new GridCacheQuerySqlMetadataV2(metas));
            }
            ArrayList<GridCacheSqlMetadata> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.leaveBusy();
        }
    }

    public AffinityTopologyVersion queryTopologyVersion() {
        return this.qryTopVer;
    }

    private IndexingQueryFilter filter(GridCacheQueryAdapter<?> qry) {
        if (qry.includeBackups()) {
            return null;
        }
        return new IndexingQueryFilterImpl(this.cctx.kernalContext(), AffinityTopologyVersion.NONE, null);
    }

    @Override
    public void printMemoryStats() {
        X.println(">>>", new Object[0]);
        X.println(">>> Query manager memory stats [igniteInstanceName=" + this.cctx.igniteInstanceName() + ", cache=" + this.cctx.name() + ']', new Object[0]);
    }

    public String cacheName() {
        return this.cacheName;
    }

    public <R> CacheQuery<R> createSpiQuery(boolean keepBinary) {
        return new GridCacheQueryAdapter(this.cctx, GridCacheQueryType.SPI, null, null, null, null, false, keepBinary, null);
    }

    public <R> CacheQuery<R> createScanQuery(@Nullable IgniteBiPredicate<K, V> filter, @Nullable Integer part, boolean keepBinary, Boolean dataPageScanEnabled) {
        return this.createScanQuery(filter, null, part, keepBinary, false, dataPageScanEnabled);
    }

    public <T, R> CacheQuery<R> createScanQuery(@Nullable IgniteBiPredicate<K, V> filter, @Nullable IgniteClosure<T, R> trans, @Nullable Integer part, boolean keepBinary, boolean forceLocal, Boolean dataPageScanEnabled) {
        return new GridCacheQueryAdapter(this.cctx, GridCacheQueryType.SCAN, filter, trans, part, keepBinary, forceLocal, dataPageScanEnabled);
    }

    public CacheQuery<Map.Entry<K, V>> createFullTextQuery(String clsName, String search, int limit, boolean keepBinary) {
        A.notNull("clsName", clsName);
        A.notNull("search", search);
        return new GridCacheQueryAdapter(this.cctx, GridCacheQueryType.TEXT, clsName, search, null, null, false, keepBinary, null).limit(limit);
    }

    public ConcurrentMap<UUID, RequestFutureMap> queryIterators() {
        return this.qryIters;
    }

    public GridConcurrentHashSet<ScanQueryIterator> localQueryIterators() {
        return this.locIters;
    }

    private static class InternalScanFilter<K, V>
    implements IgniteBiPredicate<K, V> {
        private static final long serialVersionUID = 0L;
        private final IgniteBiPredicate<K, V> scanFilter;

        InternalScanFilter(IgniteBiPredicate<K, V> scanFilter) {
            this.scanFilter = scanFilter;
        }

        @Override
        public boolean apply(K k, V v) {
            try {
                return this.scanFilter == null || this.scanFilter.apply(k, v);
            }
            catch (Throwable e) {
                throw new IgniteException(e);
            }
        }

        void close() {
            if (this.scanFilter instanceof PlatformCacheEntryFilter) {
                ((PlatformCacheEntryFilter)this.scanFilter).onClose();
            }
        }

        IgniteBiPredicate<K, V> scanFilter() {
            return this.scanFilter;
        }
    }

    public static final class ScanQueryIterator<K, V>
    extends GridCloseableIteratorAdapter<Object> {
        private static final long serialVersionUID = 0L;
        private final GridDhtCacheAdapter dht;
        private final GridDhtLocalPartition locPart;
        private final InternalScanFilter<K, V> intScanFilter;
        private final boolean statsEnabled;
        private final GridIterator<CacheDataRow> it;
        private final GridCacheAdapter cache;
        private final AffinityTopologyVersion topVer;
        private final boolean keepBinary;
        private final boolean readEvt;
        private final String cacheName;
        private final UUID subjId;
        private final String taskName;
        private final IgniteClosure transform;
        private final CacheObjectContext objCtx;
        private final GridCacheContext cctx;
        private final IgniteLogger log;
        private Object next;
        private boolean needAdvance;
        private IgniteCacheExpiryPolicy expiryPlc;
        private final boolean locNode;
        private final boolean incBackups;
        private final long startTime;
        private final int pageSize;
        @Nullable
        private final GridConcurrentHashSet<ScanQueryIterator> locIters;

        ScanQueryIterator(GridIterator<CacheDataRow> it, GridCacheQueryAdapter qry, AffinityTopologyVersion topVer, GridDhtLocalPartition locPart, IgniteBiPredicate<K, V> scanFilter, IgniteClosure transformer, boolean locNode, @Nullable GridConcurrentHashSet<ScanQueryIterator> locIters, GridCacheContext cctx, IgniteLogger log) {
            assert (!locNode || locIters != null) : "Local iterators can't be null for local query.";
            this.it = it;
            this.topVer = topVer;
            this.locPart = locPart;
            this.intScanFilter = scanFilter != null ? new InternalScanFilter<K, V>(scanFilter) : null;
            this.cctx = cctx;
            this.log = log;
            this.locNode = locNode;
            this.locIters = locIters;
            this.incBackups = qry.includeBackups();
            this.statsEnabled = cctx.statisticsEnabled();
            boolean bl = this.readEvt = cctx.events().isRecordable(97) && cctx.gridEvents().hasListener(97);
            if (this.readEvt) {
                this.taskName = cctx.kernalContext().task().resolveTaskName(qry.taskHash());
                this.subjId = qry.subjectId();
            } else {
                this.taskName = null;
                this.subjId = null;
            }
            this.keepBinary = !locNode && scanFilter == null && transformer == null && !this.readEvt || qry.keepBinary();
            this.transform = transformer;
            this.dht = cctx.isLocal() ? null : (cctx.isNear() ? cctx.near().dht() : cctx.dht());
            this.cache = this.dht != null ? this.dht : cctx.cache();
            this.objCtx = cctx.cacheObjectContext();
            this.cacheName = cctx.name();
            this.needAdvance = true;
            this.expiryPlc = this.cctx.cache().expiryPolicy(null);
            this.startTime = U.currentTimeMillis();
            this.pageSize = qry.pageSize();
        }

        @Override
        protected Object onNext() {
            if (this.needAdvance) {
                this.advance();
            } else {
                this.needAdvance = true;
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            return this.next;
        }

        @Override
        protected boolean onHasNext() {
            if (this.needAdvance) {
                this.advance();
                this.needAdvance = false;
            }
            return this.next != null;
        }

        @Override
        protected void onClose() {
            if (this.expiryPlc != null && this.dht != null) {
                this.dht.sendTtlUpdateRequest(this.expiryPlc);
                this.expiryPlc = null;
            }
            if (this.locPart != null) {
                this.locPart.release();
            }
            if (this.intScanFilter != null) {
                this.intScanFilter.close();
            }
            if (this.locIters != null) {
                this.locIters.remove(this);
            }
        }

        private void advance() {
            long start = this.statsEnabled ? System.nanoTime() : 0L;
            IgniteBiTuple next0 = null;
            while (this.it.hasNext()) {
                CacheObject val;
                CacheDataRow row = (CacheDataRow)this.it.next();
                KeyCacheObject key = row.key();
                if (this.expiryPlc != null) {
                    try {
                        CacheDataRow tmp = row;
                        while (true) {
                            try {
                                GridCacheEntryEx entry = this.cache.entryEx(key);
                                entry.unswap(tmp);
                                val = entry.peek(true, true, this.topVer, this.expiryPlc);
                                entry.touch();
                            }
                            catch (GridCacheEntryRemovedException ignore) {
                                tmp = null;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (IgniteCheckedException e) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Failed to peek value: " + e);
                        }
                        val = null;
                    }
                    if (this.dht != null && this.expiryPlc.readyToFlush(100)) {
                        this.dht.sendTtlUpdateRequest(this.expiryPlc);
                    }
                } else {
                    val = row.value();
                }
                if (!(this.cctx.isReplicated() || this.locPart != null || this.cctx.config().getCacheMode() == CacheMode.LOCAL || this.incBackups || this.cctx.affinity().primaryByKey(this.cctx.localNode(), key, this.topVer))) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Ignoring backup element [row=" + row + ", cacheMode=" + (Object)((Object)this.cctx.config().getCacheMode()) + ", incBackups=" + this.incBackups + ", primary=" + this.cctx.affinity().primaryByKey(this.cctx.localNode(), key, this.topVer) + ']');
                    continue;
                }
                if (this.log.isDebugEnabled()) {
                    ClusterNode primaryNode = this.cctx.affinity().primaryByKey(key, this.cctx.affinity().affinityTopologyVersion());
                    this.log.debug(S.toString("Record", "key", (Object)key, true, "val", (Object)val, true, "incBackups", (Object)this.incBackups, false, "priNode", (Object)(primaryNode != null ? U.id8(primaryNode.id()) : null), false, "node", (Object)U.id8(this.cctx.localNode().id()), false));
                }
                if (val == null) continue;
                Object key0 = CacheObjectUtils.unwrapBinaryIfNeeded(this.objCtx, key, this.keepBinary, false);
                Object val0 = CacheObjectUtils.unwrapBinaryIfNeeded(this.objCtx, val, this.keepBinary, false);
                if (this.statsEnabled) {
                    CacheMetricsImpl metrics = this.cctx.cache().metrics0();
                    metrics.onRead(true);
                    metrics.addGetTimeNanos(System.nanoTime() - start);
                }
                if (this.intScanFilter != null && !this.intScanFilter.apply(key0, val0)) continue;
                if (this.readEvt) {
                    this.cctx.gridEvents().record(new CacheQueryReadEvent<Object, Object>(this.cctx.localNode(), "Scan query entry read.", 97, CacheQueryType.SCAN.name(), this.cacheName, null, null, (IgniteBiPredicate<Object, Object>)(this.intScanFilter != null ? this.intScanFilter.scanFilter() : null), null, null, this.subjId, this.taskName, key0, val0, null, null));
                }
                if (this.transform != null) {
                    try {
                        next0 = this.transform.apply(new CacheQueryEntry<Object, Object>(key0, val0));
                        break;
                    }
                    catch (Throwable e) {
                        throw new IgniteException(e);
                    }
                }
                next0 = !this.locNode ? new T2<Object, Object>(key0, val0) : new CacheQueryEntry<Object, Object>(key0, val0);
                break;
            }
            if ((this.next = next0) == null && this.expiryPlc != null && this.dht != null) {
                this.dht.sendTtlUpdateRequest(this.expiryPlc);
                this.expiryPlc = null;
            }
        }

        @Nullable
        public IgniteBiPredicate<K, V> filter() {
            return this.intScanFilter == null ? null : ((InternalScanFilter)this.intScanFilter).scanFilter;
        }

        public AffinityTopologyVersion topVer() {
            return this.topVer;
        }

        public GridDhtLocalPartition localPartition() {
            return this.locPart;
        }

        public IgniteClosure transformer() {
            return this.transform;
        }

        public long startTime() {
            return this.startTime;
        }

        public boolean local() {
            return this.locNode;
        }

        public boolean keepBinary() {
            return this.keepBinary;
        }

        public UUID subjectId() {
            return this.subjId;
        }

        public String taskName() {
            return this.taskName;
        }

        public GridCacheContext cacheContext() {
            return this.cctx;
        }

        public int pageSize() {
            return this.pageSize;
        }
    }

    public class RequestFutureMap
    extends LinkedHashMap<Long, GridFutureAdapter<QueryResult<K, V>>> {
        private static final long serialVersionUID = 0L;
        private static final int CANCELED_COUNT = 128;
        private Set<Long> canceled;

        @Override
        public GridFutureAdapter<QueryResult<K, V>> remove(Object key) {
            if (this.containsKey(key)) {
                return (GridFutureAdapter)super.remove(key);
            }
            if (this.canceled == null) {
                this.canceled = Collections.newSetFromMap(new LinkedHashMap<Long, Boolean>(){

                    @Override
                    protected boolean removeEldestEntry(Map.Entry<Long, Boolean> eldest) {
                        return this.size() > 128;
                    }
                });
            }
            this.canceled.add((Long)key);
            return null;
        }

        public boolean isCanceled(Long key) {
            return this.canceled != null && this.canceled.contains(key);
        }
    }

    static class CircularQueue<R> {
        private int off;
        private int size;
        private R[] arr;

        CircularQueue(int cap) {
            assert (U.isPow2(cap));
            this.arr = new Object[cap];
        }

        public void add(R o) {
            if (this.size == this.arr.length) {
                Object[] newArr = new Object[this.arr.length << 1];
                int tailSize = this.arr.length - this.off;
                System.arraycopy(this.arr, this.off, newArr, 0, tailSize);
                if (this.off != 0) {
                    System.arraycopy(this.arr, 0, newArr, tailSize, this.off);
                    this.off = 0;
                }
                this.arr = newArr;
            }
            int idx = this.off + this.size & this.arr.length - 1;
            assert (this.arr[idx] == null);
            this.arr[idx] = o;
            ++this.size;
        }

        public void remove(int n) {
            assert (n > 0) : n;
            assert (n <= this.size) : n + " " + this.size;
            int mask = this.arr.length - 1;
            for (int i = 0; i < n; ++i) {
                int idx = this.off + i & mask;
                assert (this.arr[idx] != null);
                this.arr[idx] = null;
            }
            this.size -= n;
            this.off += n;
            if (this.off >= this.arr.length) {
                this.off -= this.arr.length;
            }
        }

        public R get(int idx) {
            assert (idx >= 0) : idx;
            assert (idx < this.size) : idx + " " + this.size;
            R res = this.arr[idx + this.off & this.arr.length - 1];
            assert (res != null);
            return res;
        }

        public int size() {
            return this.size;
        }
    }

    private static abstract class CachedResult<R>
    extends GridFutureAdapter<IgniteSpiCloseableIterator<R>> {
        private final Map<Object, QueueIterator> recipients = new GridLeanMap<Object, QueueIterator>(1);
        private CircularQueue<R> queue;
        private int pruned;

        protected CachedResult(Object rcpt) {
            boolean res = this.addRecipient(rcpt);
            assert (res);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeIfNotShared(Object rcpt) throws IgniteCheckedException {
            assert (this.isDone());
            Map<Object, QueueIterator> map = this.recipients;
            synchronized (map) {
                if (this.recipients.isEmpty()) {
                    return;
                }
                this.recipients.remove(rcpt);
                if (this.recipients.isEmpty()) {
                    ((IgniteSpiCloseableIterator)this.get()).close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addRecipient(Object rcpt) {
            Map<Object, QueueIterator> map = this.recipients;
            synchronized (map) {
                if (this.isDone()) {
                    return false;
                }
                assert (!this.recipients.containsKey(rcpt)) : rcpt + " -> " + this.recipients;
                this.recipients.put(rcpt, new QueueIterator(rcpt));
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean onDone(@Nullable IgniteSpiCloseableIterator<R> res, @Nullable Throwable err) {
            assert (!this.isDone());
            Map<Object, QueueIterator> map = this.recipients;
            synchronized (map) {
                if (this.recipients.size() > 1) {
                    this.queue = new CircularQueue(128);
                    for (QueueIterator it : this.recipients.values()) {
                        it.init();
                    }
                }
                return super.onDone(res, err);
            }
        }

        private void pruneQueue() {
            assert (!this.recipients.isEmpty());
            assert (Thread.holdsLock(this.recipients));
            int minPos = Collections.min(this.recipients.values()).pos;
            if (minPos > this.pruned) {
                this.queue.remove(minPos - this.pruned);
                this.pruned = minPos;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IgniteSpiCloseableIterator<R> iterator(Object rcpt) throws IgniteCheckedException {
            assert (rcpt != null);
            IgniteSpiCloseableIterator it = (IgniteSpiCloseableIterator)this.get();
            assert (it != null);
            Map<Object, QueueIterator> map = this.recipients;
            synchronized (map) {
                return this.queue == null ? it : (IgniteSpiCloseableIterator)this.recipients.get(rcpt);
            }
        }

        private class QueueIterator
        implements IgniteSpiCloseableIterator<R>,
        Comparable<QueueIterator> {
            private static final long serialVersionUID = 0L;
            private static final int NEXT_SIZE = 64;
            private final Object rcpt;
            private int pos;
            private Queue<R> next;

            private QueueIterator(Object rcpt) {
                this.rcpt = rcpt;
            }

            public void init() {
                assert (this.next == null);
                this.next = new ArrayDeque(64);
            }

            @Override
            public void close() throws IgniteCheckedException {
                CachedResult.this.closeIfNotShared(this.rcpt);
            }

            @Override
            public boolean hasNext() {
                return !this.next.isEmpty() || this.fillNext();
            }

            @Override
            public R next() {
                return this.next.remove();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean fillNext() {
                IgniteSpiCloseableIterator it;
                assert (this.next.isEmpty());
                try {
                    it = (IgniteSpiCloseableIterator)CachedResult.this.get();
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException(e);
                }
                Map map = CachedResult.this.recipients;
                synchronized (map) {
                    for (int i = 0; i < 64; ++i) {
                        Object res;
                        int off = this.pos - CachedResult.this.pruned;
                        if (off == CachedResult.this.queue.size()) {
                            if (!it.hasNext()) break;
                            res = it.next();
                            CachedResult.this.queue.add(res);
                        } else {
                            res = CachedResult.this.queue.get(off);
                        }
                        assert (res != null);
                        ++this.pos;
                        this.next.add(res);
                    }
                    CachedResult.this.pruneQueue();
                }
                return !this.next.isEmpty();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int compareTo(QueueIterator o) {
                return Integer.compare(this.pos, o.pos);
            }
        }
    }

    private static class FieldsResult<Q>
    extends CachedResult<Q> {
        private static final long serialVersionUID = 0L;
        private List<GridQueryFieldMetadata> meta;

        FieldsResult(Object rcpt) {
            super(rcpt);
        }

        public List<GridQueryFieldMetadata> metaData() throws IgniteCheckedException {
            this.get();
            return this.meta;
        }

        public void metaData(List<GridQueryFieldMetadata> meta) {
            this.meta = meta;
        }
    }

    public static class QueryResult<K, V>
    extends CachedResult<IgniteBiTuple<K, V>> {
        private static final long serialVersionUID = 0L;
        private final GridCacheQueryType type;

        private QueryResult(GridCacheQueryType type, Object rcpt) {
            super(rcpt);
            this.type = type;
        }

        public GridCacheQueryType type() {
            return this.type;
        }
    }

    public static class CacheSqlIndexMetadata
    implements GridCacheSqlIndexMetadata {
        private static final long serialVersionUID = 0L;
        private String name;
        private Collection<String> fields;
        private Collection<String> descendings;
        private boolean unique;

        public CacheSqlIndexMetadata() {
        }

        CacheSqlIndexMetadata(String name, Collection<String> fields, Collection<String> descendings, boolean unique) {
            assert (name != null);
            assert (fields != null);
            assert (descendings != null);
            this.name = name;
            this.fields = fields;
            this.descendings = descendings;
            this.unique = unique;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Collection<String> fields() {
            return this.fields;
        }

        @Override
        public boolean descending(String field) {
            return this.descendings.contains(field);
        }

        @Override
        public Collection<String> descendings() {
            return this.descendings;
        }

        @Override
        public boolean unique() {
            return this.unique;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeString(out, this.name);
            U.writeCollection(out, this.fields);
            U.writeCollection(out, this.descendings);
            out.writeBoolean(this.unique);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.name = U.readString(in);
            this.fields = U.readCollection(in);
            this.descendings = U.readCollection(in);
            this.unique = in.readBoolean();
        }

        public String toString() {
            return S.toString(CacheSqlIndexMetadata.class, this);
        }
    }

    public static class CacheSqlMetadata
    implements GridCacheSqlMetadata {
        private static final long serialVersionUID = 0L;
        private String cacheName;
        private Collection<String> types;
        private Map<String, String> keyClasses;
        private Map<String, String> valClasses;
        private Map<String, Map<String, String>> fields;
        private Map<String, Collection<GridCacheSqlIndexMetadata>> indexes;

        public CacheSqlMetadata() {
        }

        CacheSqlMetadata(@Nullable String cacheName, Collection<String> types, Map<String, String> keyClasses, Map<String, String> valClasses, Map<String, Map<String, String>> fields, Map<String, Collection<GridCacheSqlIndexMetadata>> indexes) {
            assert (types != null);
            assert (keyClasses != null);
            assert (valClasses != null);
            assert (fields != null);
            assert (indexes != null);
            this.cacheName = cacheName;
            this.types = types;
            this.keyClasses = keyClasses;
            this.valClasses = valClasses;
            this.fields = fields;
            this.indexes = indexes;
        }

        CacheSqlMetadata(Iterable<CacheSqlMetadata> metas) {
            this.types = new HashSet<String>();
            this.keyClasses = new HashMap<String, String>();
            this.valClasses = new HashMap<String, String>();
            this.fields = new HashMap<String, Map<String, String>>();
            this.indexes = new HashMap<String, Collection<GridCacheSqlIndexMetadata>>();
            for (CacheSqlMetadata meta : metas) {
                if (this.cacheName == null) {
                    this.cacheName = meta.cacheName;
                } else assert (F.eq(this.cacheName, meta.cacheName));
                this.types.addAll(meta.types);
                this.keyClasses.putAll(meta.keyClasses);
                this.valClasses.putAll(meta.valClasses);
                this.fields.putAll(meta.fields);
                this.indexes.putAll(meta.indexes);
            }
        }

        @Override
        public String cacheName() {
            return this.cacheName;
        }

        @Override
        public Collection<String> types() {
            return this.types;
        }

        @Override
        public String keyClass(String type) {
            return this.keyClasses.get(type);
        }

        @Override
        public String valueClass(String type) {
            return this.valClasses.get(type);
        }

        @Override
        public Map<String, String> fields(String type) {
            return this.fields.get(type);
        }

        @Override
        public Collection<String> notNullFields(String type) {
            return null;
        }

        @Override
        public Map<String, String> keyClasses() {
            return this.keyClasses;
        }

        @Override
        public Map<String, String> valClasses() {
            return this.valClasses;
        }

        @Override
        public Map<String, Map<String, String>> fields() {
            return this.fields;
        }

        @Override
        public Map<String, Collection<GridCacheSqlIndexMetadata>> indexes() {
            return this.indexes;
        }

        @Override
        public Collection<GridCacheSqlIndexMetadata> indexes(String type) {
            return this.indexes.get(type);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeString(out, this.cacheName);
            U.writeCollection(out, this.types);
            U.writeMap(out, this.keyClasses);
            U.writeMap(out, this.valClasses);
            U.writeMap(out, this.fields);
            U.writeMap(out, this.indexes);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.cacheName = U.readString(in);
            this.types = U.readCollection(in);
            this.keyClasses = U.readMap(in);
            this.valClasses = U.readMap(in);
            this.fields = U.readMap(in);
            this.indexes = U.readMap(in);
        }

        public String toString() {
            return S.toString(CacheSqlMetadata.class, this);
        }
    }

    @GridInternal
    private static class MetadataJob
    implements IgniteCallable<Collection<CacheSqlMetadata>> {
        private static final long serialVersionUID = 0L;
        private static final int NO_FIELDS_COLUMNS_COUNT = 2;
        @IgniteInstanceResource
        private Ignite ignite;

        private MetadataJob() {
        }

        @Override
        public Collection<CacheSqlMetadata> call() {
            final GridKernalContext ctx = ((IgniteKernal)this.ignite).context();
            Collection cacheNames = F.viewReadOnly(ctx.cache().caches(), new C1<IgniteInternalCache<?, ?>, String>(){

                @Override
                public String apply(IgniteInternalCache<?, ?> c) {
                    return c.name();
                }
            }, new P1<IgniteInternalCache<?, ?>>(){

                @Override
                public boolean apply(IgniteInternalCache<?, ?> c) {
                    return !CU.isSystemCache(c.name()) && !DataStructuresProcessor.isDataStructureCache(c.name());
                }
            });
            return F.transform(cacheNames, new C1<String, CacheSqlMetadata>(){

                @Override
                public CacheSqlMetadata apply(String cacheName) {
                    Collection<GridQueryTypeDescriptor> types = ctx.query().types(cacheName);
                    HashSet<String> names = U.newHashSet(types.size());
                    HashMap<String, String> keyClasses = U.newHashMap(types.size());
                    HashMap<String, String> valClasses = U.newHashMap(types.size());
                    HashMap<String, Map<String, String>> fields = U.newHashMap(types.size());
                    HashMap<String, Collection<GridCacheSqlIndexMetadata>> indexes = U.newHashMap(types.size());
                    for (GridQueryTypeDescriptor type : types) {
                        if (type.name().startsWith("GridCache")) continue;
                        names.add(type.name());
                        keyClasses.put(type.name(), type.keyClass().getName());
                        valClasses.put(type.name(), type.valueClass().getName());
                        int size = type.fields().isEmpty() ? 2 : type.fields().size();
                        LinkedHashMap<String, String> fieldsMap = U.newLinkedHashMap(size);
                        if (type.fields().isEmpty()) {
                            fieldsMap.put("_KEY", type.keyClass().getName());
                            fieldsMap.put("_VAL", type.valueClass().getName());
                        }
                        for (Map.Entry<String, Class<?>> e : type.fields().entrySet()) {
                            fieldsMap.put(e.getKey().toUpperCase(), e.getValue().getName());
                        }
                        fields.put(type.name(), fieldsMap);
                        Map<String, GridQueryIndexDescriptor> idxs = type.indexes();
                        ArrayList<CacheSqlIndexMetadata> indexesCol = new ArrayList<CacheSqlIndexMetadata>(idxs.size());
                        for (Map.Entry<String, GridQueryIndexDescriptor> e : idxs.entrySet()) {
                            GridQueryIndexDescriptor desc = e.getValue();
                            if (desc.type() != QueryIndexType.SORTED) continue;
                            LinkedList<String> idxFields = new LinkedList<String>();
                            LinkedList<String> descendings = new LinkedList<String>();
                            for (String idxField : e.getValue().fields()) {
                                String idxFieldUpper = idxField.toUpperCase();
                                idxFields.add(idxFieldUpper);
                                if (!desc.descending(idxField)) continue;
                                descendings.add(idxFieldUpper);
                            }
                            indexesCol.add(new CacheSqlIndexMetadata(e.getKey().toUpperCase(), idxFields, descendings, false));
                        }
                        indexes.put(type.name(), indexesCol);
                    }
                    return new CacheSqlMetadata(cacheName, names, keyClasses, valClasses, fields, indexes);
                }
            });
        }
    }
}

