/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcProtocolContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRawBinarylizable;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcParameterMeta
implements JdbcRawBinarylizable {
    private int isNullable;
    private boolean signed;
    private int precision;
    private int scale;
    private int type;
    private String typeName;
    private String typeClass;
    private int mode;

    public JdbcParameterMeta() {
    }

    public JdbcParameterMeta(ParameterMetaData meta, int order) throws SQLException {
        this.isNullable = meta.isNullable(order);
        this.signed = meta.isSigned(order);
        this.precision = meta.getPrecision(order);
        this.scale = meta.getScale(order);
        this.type = meta.getParameterType(order);
        this.typeName = meta.getParameterTypeName(order);
        this.typeClass = meta.getParameterClassName(order);
        this.mode = meta.getParameterMode(order);
    }

    public int isNullable() {
        return this.isNullable;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public int precision() {
        return this.precision;
    }

    public int scale() {
        return this.scale;
    }

    public int type() {
        return this.type;
    }

    public String typeName() {
        return this.typeName;
    }

    public String typeClass() {
        return this.typeClass;
    }

    public int mode() {
        return this.mode;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        writer.writeInt(this.isNullable);
        writer.writeBoolean(this.signed);
        writer.writeInt(this.precision);
        writer.writeInt(this.scale);
        writer.writeInt(this.type);
        writer.writeString(this.typeName);
        writer.writeString(this.typeClass);
        writer.writeInt(this.mode);
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        this.isNullable = reader.readInt();
        this.signed = reader.readBoolean();
        this.precision = reader.readInt();
        this.scale = reader.readInt();
        this.type = reader.readInt();
        this.typeName = reader.readString();
        this.typeClass = reader.readString();
        this.mode = reader.readInt();
    }

    public String toString() {
        return S.toString(JdbcParameterMeta.class, this);
    }
}

