/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.memory;

import org.apache.ignite.internal.processors.platform.callback.PlatformCallbackGateway;
import org.apache.ignite.internal.processors.platform.memory.PlatformExternalMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemoryManager;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemoryPool;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemoryUtils;
import org.apache.ignite.internal.processors.platform.memory.PlatformUnpooledMemory;
import org.jetbrains.annotations.Nullable;

public class PlatformMemoryManagerImpl
implements PlatformMemoryManager {
    private final PlatformCallbackGateway gate;
    private final int dfltCap;
    private final ThreadLocal<PlatformMemoryPool> threadLocPool = new ThreadLocal();

    public PlatformMemoryManagerImpl(@Nullable PlatformCallbackGateway gate, int dfltCap) {
        this.gate = gate;
        this.dfltCap = dfltCap;
    }

    @Override
    public PlatformMemory allocate() {
        return this.allocate(this.dfltCap);
    }

    @Override
    public PlatformMemory allocate(int cap) {
        return this.pool().allocate(cap);
    }

    @Override
    public PlatformMemory get(long memPtr) {
        int flags = PlatformMemoryUtils.flags(memPtr);
        return PlatformMemoryUtils.isExternal(flags) ? new PlatformExternalMemory(this.gate, memPtr) : (PlatformMemoryUtils.isPooled(flags) ? this.pool().get(memPtr) : new PlatformUnpooledMemory(memPtr));
    }

    private PlatformMemoryPool pool() {
        PlatformMemoryPool pool = this.threadLocPool.get();
        if (pool == null) {
            pool = new PlatformMemoryPool();
            this.threadLocPool.set(pool);
        }
        return pool;
    }
}

