/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.internal.util.GridSetWrapper;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentLinkedHashMap;

public class GridConcurrentLinkedHashSet<E>
extends GridSetWrapper<E> {
    private static final long serialVersionUID = 0L;

    public GridConcurrentLinkedHashSet() {
        super(new ConcurrentLinkedHashMap());
    }

    public GridConcurrentLinkedHashSet(int initCap) {
        super(new ConcurrentLinkedHashMap(initCap));
    }

    public GridConcurrentLinkedHashSet(int initCap, float loadFactor, int conLevel) {
        super(new ConcurrentLinkedHashMap(initCap, loadFactor, conLevel));
    }

    public GridConcurrentLinkedHashSet(Collection<E> c) {
        super(new ConcurrentLinkedHashMap(c.size()));
        this.addAll(c);
    }

    @Override
    public boolean add(E e) {
        ConcurrentMap m = (ConcurrentMap)this.map;
        return m.putIfAbsent(e, e) == null;
    }

    @Nullable
    public E addx(E e) {
        ConcurrentMap m = (ConcurrentMap)this.map;
        return m.putIfAbsent(e, e);
    }

    public Iterator<E> descendingIterator() {
        return ((ConcurrentLinkedHashMap)this.map).descendingKeySet().iterator();
    }

    @Override
    public String toString() {
        return S.toString(GridConcurrentLinkedHashSet.class, this, "elements", this.map().keySet());
    }
}

