/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.communication.tcp.internal.shmem;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.tracing.Tracing;
import org.apache.ignite.internal.util.ipc.IpcEndpoint;
import org.apache.ignite.internal.util.ipc.shmem.IpcSharedMemoryServerEndpoint;
import org.apache.ignite.internal.util.nio.GridNioMessageReaderFactory;
import org.apache.ignite.internal.util.nio.GridNioMessageWriterFactory;
import org.apache.ignite.internal.util.nio.GridNioServerListener;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageFactory;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationMetricsListener;
import org.apache.ignite.spi.communication.tcp.internal.shmem.ShmemWorker;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.Nullable;

public class ShmemAcceptWorker
extends GridWorker {
    private static final String WORKER_NAME = "shmem-communication-acceptor";
    private final Collection<ShmemWorker> shmemWorkers = new ConcurrentLinkedDeque<ShmemWorker>();
    private final IpcSharedMemoryServerEndpoint srv;
    private final GridNioServerListener<Message> srvLsnr;
    @Nullable
    private volatile TcpCommunicationMetricsListener metricsLsnr;
    private final IgniteLogger log;
    private final MessageFactory msgFactory;
    private final GridNioMessageWriterFactory writerFactory;
    private final GridNioMessageReaderFactory readerFactory;
    private final Tracing tracing;

    public ShmemAcceptWorker(String igniteInstanceName, GridNioServerListener<Message> srvLsnr, IpcSharedMemoryServerEndpoint srv, TcpCommunicationMetricsListener metricsLsnr, IgniteLogger log, MessageFactory msgFactory, GridNioMessageWriterFactory writerFactory, GridNioMessageReaderFactory readerFactory, Tracing tracing) {
        super(igniteInstanceName, WORKER_NAME, log);
        this.msgFactory = msgFactory;
        this.writerFactory = writerFactory;
        this.readerFactory = readerFactory;
        this.tracing = tracing;
        this.srv = srv;
        this.srvLsnr = srvLsnr;
        this.metricsLsnr = metricsLsnr;
        this.log = log;
    }

    @Override
    protected void body() throws InterruptedException {
        try {
            while (!Thread.interrupted()) {
                IpcEndpoint ipcEndpoint = this.srv.accept();
                ShmemWorker e = new ShmemWorker(this.igniteInstanceName(), this.log, this.tracing, ipcEndpoint, this.srvLsnr, this.metricsLsnr, this.readerFactory, this.writerFactory, this.msgFactory);
                e.onFinish(() -> this.shmemWorkers.remove(e));
                this.shmemWorkers.add(e);
                new IgniteThread(e).start();
            }
        }
        catch (IgniteCheckedException e) {
            if (!this.isCancelled()) {
                U.error(this.log, "Shmem server failed.", e);
            }
        }
        finally {
            this.srv.close();
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        this.srv.close();
    }

    public void metricsListener(@Nullable TcpCommunicationMetricsListener metricsLsnr) {
        this.metricsLsnr = metricsLsnr;
    }
}

