/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata.enums;

public enum CompressionType {
    UNCOMPRESSED("", 0),
    SNAPPY(".snappy", 1),
    GZIP(".gzip", 2),
    LZ4(".lz4", 7);

    private final String extensionName;
    private final byte index;

    private CompressionType(String extensionName, byte index) {
        this.extensionName = extensionName;
        this.index = index;
    }

    public static CompressionType deserialize(byte compressor) {
        switch (compressor) {
            case 0: {
                return UNCOMPRESSED;
            }
            case 1: {
                return SNAPPY;
            }
            case 2: {
                return GZIP;
            }
            case 7: {
                return LZ4;
            }
        }
        throw new IllegalArgumentException("Invalid input: " + compressor);
    }

    public static int getSerializedSize() {
        return 1;
    }

    public byte serialize() {
        return this.index;
    }

    public String getExtension() {
        return this.extensionName;
    }
}

