/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata.statistics;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.tsfile.exception.filter.StatisticsClassException;
import org.apache.iotdb.tsfile.exception.write.UnknownColumnTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.BinaryStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.BooleanStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.DoubleStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.FloatStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.IntegerStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.LongStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.TimeStatistics;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Statistics<T extends Serializable> {
    private static final Logger LOG = LoggerFactory.getLogger(Statistics.class);
    protected boolean isEmpty = true;
    private int count = 0;
    private long startTime = Long.MAX_VALUE;
    private long endTime = Long.MIN_VALUE;
    static final String STATS_UNSUPPORTED_MSG = "%s statistics does not support: %s";

    public static Statistics<? extends Serializable> getStatsByType(TSDataType type) {
        switch (type) {
            case INT32: {
                return new IntegerStatistics();
            }
            case INT64: {
                return new LongStatistics();
            }
            case TEXT: {
                return new BinaryStatistics();
            }
            case BOOLEAN: {
                return new BooleanStatistics();
            }
            case DOUBLE: {
                return new DoubleStatistics();
            }
            case FLOAT: {
                return new FloatStatistics();
            }
            case VECTOR: {
                return new TimeStatistics();
            }
        }
        throw new UnknownColumnTypeException(type.toString());
    }

    public static int getSizeByType(TSDataType type) {
        switch (type) {
            case INT32: {
                return 64;
            }
            case INT64: {
                return 80;
            }
            case TEXT: {
                return 32;
            }
            case BOOLEAN: {
                return 56;
            }
            case DOUBLE: {
                return 80;
            }
            case FLOAT: {
                return 64;
            }
            case VECTOR: {
                return 40;
            }
        }
        throw new UnknownColumnTypeException(type.toString());
    }

    public abstract TSDataType getType();

    public int getSerializedSize() {
        return ReadWriteForEncodingUtils.uVarIntSize(this.count) + 16 + this.getStatsSize();
    }

    public abstract int getStatsSize();

    public int serialize(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteForEncodingUtils.writeUnsignedVarInt(this.count, outputStream);
        byteLen += ReadWriteIOUtils.write(this.startTime, outputStream);
        byteLen += ReadWriteIOUtils.write(this.endTime, outputStream);
        return byteLen += this.serializeStats(outputStream);
    }

    abstract int serializeStats(OutputStream var1) throws IOException;

    public abstract void deserialize(InputStream var1) throws IOException;

    public abstract void deserialize(ByteBuffer var1);

    public abstract T getMinValue();

    public abstract T getMaxValue();

    public abstract T getFirstValue();

    public abstract T getLastValue();

    public abstract double getSumDoubleValue();

    public abstract long getSumLongValue();

    public void mergeStatistics(Statistics<? extends Serializable> stats) {
        if (this.getClass() == stats.getClass()) {
            if (!stats.isEmpty) {
                if (stats.startTime < this.startTime) {
                    this.startTime = stats.startTime;
                }
                if (stats.endTime > this.endTime) {
                    this.endTime = stats.endTime;
                }
                this.count += stats.count;
                this.mergeStatisticsValue(stats);
                this.isEmpty = false;
            }
        } else {
            Class<?> thisClass = this.getClass();
            Class<?> statsClass = stats.getClass();
            LOG.warn("Statistics classes mismatched,no merge: {} v.s. {}", thisClass, statsClass);
            throw new StatisticsClassException(thisClass, statsClass);
        }
    }

    public void update(long time, boolean value) {
        this.update(time);
        this.updateStats(value);
    }

    public void update(long time, int value) {
        this.update(time);
        this.updateStats(value);
    }

    public void update(long time, long value) {
        this.update(time);
        this.updateStats(value);
    }

    public void update(long time, float value) {
        this.update(time);
        this.updateStats(value);
    }

    public void update(long time, double value) {
        this.update(time);
        this.updateStats(value);
    }

    public void update(long time, Binary value) {
        this.update(time);
        this.updateStats(value);
    }

    public void update(long time) {
        if (time < this.startTime) {
            this.startTime = time;
        }
        if (time > this.endTime) {
            this.endTime = time;
        }
        ++this.count;
    }

    public void update(long[] time, boolean[] values, int batchSize) {
        this.update(time, batchSize);
        this.updateStats(values, batchSize);
    }

    public void update(long[] time, int[] values, int batchSize) {
        this.update(time, batchSize);
        this.updateStats(values, batchSize);
    }

    public void update(long[] time, long[] values, int batchSize) {
        this.update(time, batchSize);
        this.updateStats(values, batchSize);
    }

    public void update(long[] time, float[] values, int batchSize) {
        this.update(time, batchSize);
        this.updateStats(values, batchSize);
    }

    public void update(long[] time, double[] values, int batchSize) {
        this.update(time, batchSize);
        this.updateStats(values, batchSize);
    }

    public void update(long[] time, Binary[] values, int batchSize) {
        this.update(time, batchSize);
        this.updateStats(values, batchSize);
    }

    public void update(long[] time, int batchSize) {
        if (time[0] < this.startTime) {
            this.startTime = time[0];
        }
        if (time[batchSize - 1] > this.endTime) {
            this.endTime = time[batchSize - 1];
        }
        this.count += batchSize;
    }

    protected abstract void mergeStatisticsValue(Statistics<T> var1);

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public void setEmpty(boolean empty) {
        this.isEmpty = empty;
    }

    void updateStats(boolean value) {
        throw new UnsupportedOperationException();
    }

    void updateStats(int value) {
        throw new UnsupportedOperationException();
    }

    void updateStats(long value) {
        throw new UnsupportedOperationException();
    }

    void updateStats(float value) {
        throw new UnsupportedOperationException();
    }

    void updateStats(double value) {
        throw new UnsupportedOperationException();
    }

    void updateStats(Binary value) {
        throw new UnsupportedOperationException();
    }

    void updateStats(boolean[] values, int batchSize) {
        throw new UnsupportedOperationException();
    }

    void updateStats(int[] values, int batchSize) {
        throw new UnsupportedOperationException();
    }

    void updateStats(long[] values, int batchSize) {
        throw new UnsupportedOperationException();
    }

    void updateStats(float[] values, int batchSize) {
        throw new UnsupportedOperationException();
    }

    void updateStats(double[] values, int batchSize) {
        throw new UnsupportedOperationException();
    }

    void updateStats(Binary[] values, int batchSize) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(long min, long max) {
        throw new UnsupportedOperationException();
    }

    public static Statistics<? extends Serializable> deserialize(InputStream inputStream, TSDataType dataType) throws IOException {
        Statistics<Serializable> statistics = Statistics.getStatsByType(dataType);
        statistics.setCount(ReadWriteForEncodingUtils.readUnsignedVarInt(inputStream));
        statistics.setStartTime(ReadWriteIOUtils.readLong(inputStream));
        statistics.setEndTime(ReadWriteIOUtils.readLong(inputStream));
        statistics.deserialize(inputStream);
        statistics.isEmpty = false;
        return statistics;
    }

    public static Statistics<? extends Serializable> deserialize(ByteBuffer buffer, TSDataType dataType) {
        Statistics<Serializable> statistics = Statistics.getStatsByType(dataType);
        statistics.setCount(ReadWriteForEncodingUtils.readUnsignedVarInt(buffer));
        statistics.setStartTime(ReadWriteIOUtils.readLong(buffer));
        statistics.setEndTime(ReadWriteIOUtils.readLong(buffer));
        statistics.deserialize(buffer);
        statistics.isEmpty = false;
        return statistics;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getCount() {
        return this.count;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public abstract long calculateRamSize();

    public String toString() {
        return "startTime: " + this.startTime + " endTime: " + this.endTime + " count: " + this.count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.count, this.startTime, this.endTime);
    }
}

