/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.chunk;

import java.io.IOException;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.compress.ICompressor;
import org.apache.iotdb.tsfile.encoding.encoder.Encoder;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.TimeStatistics;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.write.page.TimePageWriter;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeChunkWriter {
    private static final Logger logger = LoggerFactory.getLogger(TimeChunkWriter.class);
    private final String measurementId;
    private final TSEncoding encodingType;
    private final CompressionType compressionType;
    private final PublicBAOS pageBuffer;
    private int numOfPages;
    private TimePageWriter pageWriter;
    private final long pageSizeThreshold;
    private final int maxNumberOfPointsInPage;
    private int valueCountInOnePageForNextCheck;
    private static final int MINIMUM_RECORD_COUNT_FOR_CHECK = 1500;
    private TimeStatistics statistics;
    private int sizeWithoutStatistic;
    private Statistics<?> firstPageStatistics;

    public TimeChunkWriter(String measurementId, CompressionType compressionType, TSEncoding encodingType, Encoder timeEncoder) {
        this.measurementId = measurementId;
        this.encodingType = encodingType;
        this.compressionType = compressionType;
        this.pageBuffer = new PublicBAOS();
        this.pageSizeThreshold = TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
        this.maxNumberOfPointsInPage = TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage();
        this.valueCountInOnePageForNextCheck = 1500;
        this.statistics = new TimeStatistics();
        this.pageWriter = new TimePageWriter(timeEncoder, ICompressor.getCompressor(compressionType));
    }

    public void write(long time) {
        this.pageWriter.write(time);
    }

    public void write(long[] timestamps, int batchSize) {
        this.pageWriter.write(timestamps, batchSize);
    }

    public boolean checkPageSizeAndMayOpenANewPage() {
        if (this.pageWriter.getPointNumber() == (long)this.maxNumberOfPointsInPage) {
            logger.debug("current line count reaches the upper bound, write page {}", (Object)this.measurementId);
            return true;
        }
        if (this.pageWriter.getPointNumber() >= (long)this.valueCountInOnePageForNextCheck) {
            long currentPageSize = this.pageWriter.estimateMaxMemSize();
            if (currentPageSize > this.pageSizeThreshold) {
                logger.debug("enough size, write page {}, pageSizeThreshold:{}, currentPateSize:{}, valueCountInOnePage:{}", new Object[]{this.measurementId, this.pageSizeThreshold, currentPageSize, this.pageWriter.getPointNumber()});
                this.valueCountInOnePageForNextCheck = 1500;
                return true;
            }
            this.valueCountInOnePageForNextCheck = (int)((float)this.pageSizeThreshold / (float)currentPageSize * (float)this.pageWriter.getPointNumber());
        }
        return false;
    }

    public void writePageToPageBuffer() {
        try {
            if (this.numOfPages == 0) {
                this.firstPageStatistics = this.pageWriter.getStatistics();
                this.sizeWithoutStatistic = this.pageWriter.writePageHeaderAndDataIntoBuff(this.pageBuffer, true);
            } else if (this.numOfPages == 1) {
                byte[] b = this.pageBuffer.toByteArray();
                this.pageBuffer.reset();
                this.pageBuffer.write(b, 0, this.sizeWithoutStatistic);
                this.firstPageStatistics.serialize(this.pageBuffer);
                this.pageBuffer.write(b, this.sizeWithoutStatistic, b.length - this.sizeWithoutStatistic);
                this.pageWriter.writePageHeaderAndDataIntoBuff(this.pageBuffer, false);
                this.firstPageStatistics = null;
            } else {
                this.pageWriter.writePageHeaderAndDataIntoBuff(this.pageBuffer, false);
            }
            ++this.numOfPages;
            this.statistics.mergeStatistics(this.pageWriter.getStatistics());
        }
        catch (IOException e) {
            logger.error("meet error in pageWriter.writePageHeaderAndDataIntoBuff,ignore this page:", (Throwable)e);
        }
        finally {
            this.pageWriter.reset();
        }
    }

    public void writeToFileWriter(TsFileIOWriter tsfileWriter) throws IOException {
        this.sealCurrentPage();
        this.writeAllPagesOfChunkToTsFile(tsfileWriter);
        this.pageBuffer.reset();
        this.numOfPages = 0;
        this.firstPageStatistics = null;
        this.statistics = new TimeStatistics();
    }

    public long estimateMaxSeriesMemSize() {
        return (long)this.pageBuffer.size() + this.pageWriter.estimateMaxMemSize() + (long)PageHeader.estimateMaxPageHeaderSizeWithoutStatistics() + (long)this.pageWriter.getStatistics().getSerializedSize();
    }

    public long getCurrentChunkSize() {
        if (this.pageBuffer.size() == 0) {
            return 0L;
        }
        return (long)ChunkHeader.getSerializedSize(this.measurementId, this.pageBuffer.size()) + (long)this.pageBuffer.size();
    }

    public void sealCurrentPage() {
        if (this.pageWriter != null && this.pageWriter.getPointNumber() > 0L) {
            this.writePageToPageBuffer();
        }
    }

    public void clearPageWriter() {
        this.pageWriter = null;
    }

    public int getNumOfPages() {
        return this.numOfPages;
    }

    public TSDataType getDataType() {
        return TSDataType.VECTOR;
    }

    public void writeAllPagesOfChunkToTsFile(TsFileIOWriter writer) throws IOException {
        if (this.statistics.getCount() == 0L) {
            return;
        }
        writer.startFlushChunk(this.measurementId, this.compressionType, TSDataType.VECTOR, this.encodingType, this.statistics, this.pageBuffer.size(), this.numOfPages, -128);
        long dataOffset = writer.getPos();
        writer.writeBytesToStream(this.pageBuffer);
        int dataSize = (int)(writer.getPos() - dataOffset);
        if (dataSize != this.pageBuffer.size()) {
            throw new IOException("Bytes written is inconsistent with the size of data: " + dataSize + " != " + this.pageBuffer.size());
        }
        writer.endCurrentChunk();
    }

    public PublicBAOS getPageBuffer() {
        return this.pageBuffer;
    }

    public TimePageWriter getPageWriter() {
        return this.pageWriter;
    }
}

