/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log.logtypes;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.cluster.log.Log;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhysicalPlanLog
extends Log {
    private static final Logger logger = LoggerFactory.getLogger(PhysicalPlanLog.class);
    private PhysicalPlan plan;

    public PhysicalPlanLog() {
    }

    public PhysicalPlanLog(PhysicalPlan plan) {
        this.plan = plan;
    }

    @Override
    public ByteBuffer serialize() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        try (DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
            dataOutputStream.writeByte((byte)Log.Types.PHYSICAL_PLAN.ordinal());
            dataOutputStream.writeLong(this.getCurrLogIndex());
            dataOutputStream.writeLong(this.getCurrLogTerm());
            this.plan.serialize(dataOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        this.setCurrLogIndex(buffer.getLong());
        this.setCurrLogTerm(buffer.getLong());
        try {
            this.plan = PhysicalPlan.Factory.create((ByteBuffer)buffer);
        }
        catch (IOException | IllegalPathException e) {
            logger.error("Cannot parse a physical {}:{} plan {}", new Object[]{this.getCurrLogIndex(), this.getCurrLogTerm(), buffer.array().length, e});
        }
    }

    public PhysicalPlan getPlan() {
        return this.plan;
    }

    public void setPlan(PhysicalPlan plan) {
        this.plan = plan;
    }

    public String toString() {
        return this.plan + ",term:" + this.getCurrLogTerm() + ",index:" + this.getCurrLogIndex();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PhysicalPlanLog that = (PhysicalPlanLog)o;
        return Objects.equals(this.plan, that.plan);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.plan);
    }
}

