/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.partition.balancer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.partition.balancer.SlotBalancer;
import org.apache.iotdb.cluster.partition.slot.SlotPartitionTable;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftNode;

public class DefaultSlotBalancer
implements SlotBalancer {
    private int multiRaftFactor = ClusterDescriptor.getInstance().getConfig().getMultiRaftFactor();
    private SlotPartitionTable table;

    public DefaultSlotBalancer(SlotPartitionTable partitionTable) {
        this.table = partitionTable;
    }

    @Override
    public void moveSlotsToNew(Node newNode, List<Node> oldRing) {
        Map<RaftNode, List<Integer>> nodeSlotMap = this.table.getAllNodeSlots();
        Map<RaftNode, Map<Integer, PartitionGroup>> previousNodeMap = this.table.getPreviousNodeMap();
        RaftNode[] slotNodes = this.table.getSlotNodes();
        int newAvg = this.table.getTotalSlotNumbers() / this.table.getAllNodes().size() / this.multiRaftFactor;
        HashMap newNodeSlotMap = new HashMap();
        int raftId = 0;
        for (int i = 0; i < this.multiRaftFactor; ++i) {
            RaftNode raftNode = new RaftNode(newNode, i);
            newNodeSlotMap.putIfAbsent(raftNode, new ArrayList());
            previousNodeMap.putIfAbsent(raftNode, new HashMap());
        }
        for (Map.Entry<RaftNode, List<Integer>> entry : nodeSlotMap.entrySet()) {
            List<Integer> slots = entry.getValue();
            int transferNum = slots.size() - newAvg;
            if (transferNum <= 0) continue;
            RaftNode curNode = new RaftNode(newNode, raftId);
            int numToMove = transferNum;
            if (raftId != this.multiRaftFactor - 1) {
                numToMove = Math.min(numToMove, newAvg - ((List)newNodeSlotMap.get(curNode)).size());
            }
            List<Integer> slotsToMove = slots.subList(slots.size() - transferNum, slots.size() - transferNum + numToMove);
            ((List)newNodeSlotMap.get(curNode)).addAll(slotsToMove);
            for (Integer slot : slotsToMove) {
                previousNodeMap.get(curNode).put(slot, this.table.getPartitionGroup(entry.getKey(), oldRing));
                slotNodes[slot.intValue()] = curNode;
            }
            slotsToMove.clear();
            if ((transferNum -= numToMove) <= 0) continue;
            curNode = new RaftNode(newNode, ++raftId);
            slotsToMove = slots.subList(slots.size() - transferNum, slots.size());
            ((List)newNodeSlotMap.get(curNode)).addAll(slotsToMove);
            for (Integer slot : slotsToMove) {
                previousNodeMap.get(curNode).put(slot, this.table.getPartitionGroup(entry.getKey(), oldRing));
                slotNodes[slot.intValue()] = curNode;
            }
            slotsToMove.clear();
        }
        nodeSlotMap.putAll(newNodeSlotMap);
    }

    @Override
    public Map<RaftNode, List<Integer>> retrieveSlots(Node target) {
        Map<RaftNode, List<Integer>> nodeSlotMap = this.table.getAllNodeSlots();
        RaftNode[] slotNodes = this.table.getSlotNodes();
        List<Node> nodeRing = this.table.getAllNodes();
        HashMap<RaftNode, List<Integer>> newHolderSlotMap = new HashMap<RaftNode, List<Integer>>();
        for (int raftId = 0; raftId < this.multiRaftFactor; ++raftId) {
            RaftNode raftNode = new RaftNode(target, raftId);
            List<Integer> slots = nodeSlotMap.remove(raftNode);
            for (int i = 0; i < slots.size(); ++i) {
                RaftNode newHolder;
                int slot = slots.get(i);
                slotNodes[slot] = newHolder = new RaftNode(nodeRing.get(i % nodeRing.size()), raftId);
                nodeSlotMap.computeIfAbsent(newHolder, n -> new ArrayList()).add(slot);
                newHolderSlotMap.computeIfAbsent(newHolder, n -> new ArrayList()).add(slot);
            }
        }
        return newHolderSlotMap;
    }
}

