/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.partition.slot;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.partition.NodeAdditionResult;
import org.apache.iotdb.cluster.partition.NodeRemovalResult;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.partition.PartitionTable;
import org.apache.iotdb.cluster.partition.balancer.DefaultSlotBalancer;
import org.apache.iotdb.cluster.partition.balancer.SlotBalancer;
import org.apache.iotdb.cluster.partition.slot.SlotNodeAdditionResult;
import org.apache.iotdb.cluster.partition.slot.SlotNodeRemovalResult;
import org.apache.iotdb.cluster.partition.slot.SlotStrategy;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftNode;
import org.apache.iotdb.cluster.utils.NodeSerializeUtils;
import org.apache.iotdb.db.utils.SerializeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotPartitionTable
implements PartitionTable {
    private static final Logger logger = LoggerFactory.getLogger(SlotPartitionTable.class);
    private static SlotStrategy slotStrategy = new SlotStrategy.DefaultStrategy();
    private final int replicationNum = ClusterDescriptor.getInstance().getConfig().getReplicationNum();
    private final int multiRaftFactor = ClusterDescriptor.getInstance().getConfig().getMultiRaftFactor();
    private List<Node> nodeRing = new ArrayList<Node>();
    private int totalSlotNumbers;
    private Map<RaftNode, List<Integer>> nodeSlotMap = new ConcurrentHashMap<RaftNode, List<Integer>>();
    private RaftNode[] slotNodes = new RaftNode[10000];
    private Map<RaftNode, Map<Integer, PartitionGroup>> previousNodeMap = new ConcurrentHashMap<RaftNode, Map<Integer, PartitionGroup>>();
    private NodeRemovalResult nodeRemovalResult = new SlotNodeRemovalResult();
    private List<PartitionGroup> localGroups;
    private Node thisNode;
    private List<PartitionGroup> globalGroups;
    private volatile long lastMetaLogIndex = -1L;
    private SlotBalancer slotBalancer = new DefaultSlotBalancer(this);

    public SlotPartitionTable(Node thisNode) {
        this.thisNode = thisNode;
    }

    public SlotPartitionTable(SlotPartitionTable other) {
        this.thisNode = other.thisNode;
        this.totalSlotNumbers = other.totalSlotNumbers;
        this.lastMetaLogIndex = other.lastMetaLogIndex;
        this.nodeRing = new ArrayList<Node>(other.nodeRing);
        this.nodeSlotMap = new HashMap<RaftNode, List<Integer>>(other.nodeSlotMap);
        this.slotNodes = new RaftNode[this.totalSlotNumbers];
        System.arraycopy(other.slotNodes, 0, this.slotNodes, 0, this.totalSlotNumbers);
        this.previousNodeMap = new HashMap<RaftNode, Map<Integer, PartitionGroup>>(this.previousNodeMap);
        this.localGroups = this.getPartitionGroups(this.thisNode);
    }

    public SlotPartitionTable(Collection<Node> nodes, Node thisNode) {
        this(nodes, thisNode, 10000);
    }

    private SlotPartitionTable(Collection<Node> nodes, Node thisNode, int totalSlotNumbers) {
        this.thisNode = thisNode;
        this.totalSlotNumbers = totalSlotNumbers;
        this.init(nodes);
    }

    public static SlotStrategy getSlotStrategy() {
        return slotStrategy;
    }

    public static void setSlotStrategy(SlotStrategy slotStrategy) {
        SlotPartitionTable.slotStrategy = slotStrategy;
    }

    public SlotBalancer getLoadBalancer() {
        return this.slotBalancer;
    }

    public void setLoadBalancer(SlotBalancer slotBalancer) {
        this.slotBalancer = slotBalancer;
    }

    private void init(Collection<Node> nodes) {
        logger.info("Initializing a new partition table");
        this.nodeRing.addAll(nodes);
        Collections.sort(this.nodeRing);
        this.localGroups = this.getPartitionGroups(this.thisNode);
        this.assignPartitions();
    }

    private void assignPartitions() {
        int nodeNum = this.nodeRing.size();
        int slotsPerNode = this.totalSlotNumbers / nodeNum;
        int slotsPerRaftGroup = slotsPerNode / this.multiRaftFactor;
        for (Node node : this.nodeRing) {
            for (int i = 0; i < this.multiRaftFactor; ++i) {
                this.nodeSlotMap.put(new RaftNode(node, i), new ArrayList());
            }
        }
        for (int i = 0; i < this.totalSlotNumbers; ++i) {
            int nodeIdx = i / slotsPerNode;
            int raftId = i % slotsPerNode / slotsPerRaftGroup;
            if (nodeIdx >= nodeNum) {
                --nodeIdx;
            }
            if (raftId >= this.multiRaftFactor) {
                --raftId;
            }
            this.nodeSlotMap.get(new RaftNode(this.nodeRing.get(nodeIdx), raftId)).add(i);
        }
        for (Map.Entry<RaftNode, List<Integer>> entry : this.nodeSlotMap.entrySet()) {
            for (Integer slot : entry.getValue()) {
                this.slotNodes[slot.intValue()] = entry.getKey();
            }
        }
    }

    private List<PartitionGroup> getPartitionGroups(Node node) {
        ArrayList<PartitionGroup> ret = new ArrayList<PartitionGroup>();
        int nodeIndex = this.nodeRing.indexOf(node);
        if (nodeIndex == -1) {
            logger.info("PartitionGroups is empty due to this node has been removed from the cluster!");
            return ret;
        }
        for (int i = 0; i < this.replicationNum; ++i) {
            int startIndex = nodeIndex - i;
            if (startIndex < 0) {
                startIndex += this.nodeRing.size();
            }
            for (int j = 0; j < this.multiRaftFactor; ++j) {
                ret.add(this.getPartitionGroup(new RaftNode(this.nodeRing.get(startIndex), j)));
            }
        }
        logger.debug("The partition groups of {} are: {}", (Object)node, ret);
        return ret;
    }

    public PartitionGroup getPartitionGroup(RaftNode header, List<Node> nodeRing) {
        PartitionGroup ret = new PartitionGroup(header.getRaftId(), new Node[0]);
        int nodeIndex = nodeRing.indexOf(header.getNode());
        if (nodeIndex == -1) {
            logger.warn("Node {} is not in the cluster", (Object)header.getNode());
            return null;
        }
        int endIndex = nodeIndex + this.replicationNum;
        if (endIndex > nodeRing.size()) {
            ret.addAll(nodeRing.subList(nodeIndex, nodeRing.size()));
            ret.addAll(nodeRing.subList(0, endIndex - nodeRing.size()));
        } else {
            ret.addAll(nodeRing.subList(nodeIndex, endIndex));
        }
        return ret;
    }

    @Override
    public PartitionGroup getPartitionGroup(RaftNode headerNode) {
        return this.getPartitionGroup(headerNode, this.nodeRing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartitionGroup route(String storageGroupName, long timestamp) {
        List<Node> list = this.nodeRing;
        synchronized (list) {
            RaftNode raftNode = this.routeToHeaderByTime(storageGroupName, timestamp);
            return this.getPartitionGroup(raftNode);
        }
    }

    public PartitionGroup route(int slot) {
        if (slot >= this.slotNodes.length || slot < 0) {
            logger.warn("Invalid slot to route: {}, stack trace: {}", (Object)slot, (Object)Thread.currentThread().getStackTrace());
            return null;
        }
        RaftNode raftNode = this.slotNodes[slot];
        logger.debug("The slot of {} is held by {}", (Object)slot, (Object)raftNode);
        if (raftNode.getNode() == null) {
            logger.warn("The slot {} is incorrect", (Object)slot);
            return null;
        }
        return this.getPartitionGroup(raftNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RaftNode routeToHeaderByTime(String storageGroupName, long timestamp) {
        List<Node> list = this.nodeRing;
        synchronized (list) {
            int slot = SlotPartitionTable.getSlotStrategy().calculateSlotByTime(storageGroupName, timestamp, this.getTotalSlotNumbers());
            RaftNode raftNode = this.slotNodes[slot];
            logger.trace("The slot of {}@{} is {}, held by {}", new Object[]{storageGroupName, timestamp, slot, raftNode});
            return raftNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNode(Node node) {
        ArrayList<Node> oldRing;
        List<Node> list = this.nodeRing;
        synchronized (list) {
            if (this.nodeRing.contains(node)) {
                return;
            }
            oldRing = new ArrayList<Node>(this.nodeRing);
            this.nodeRing.add(node);
            this.nodeRing.sort(Comparator.comparingInt(Node::getNodeIdentifier));
            ArrayList<PartitionGroup> retiredGroups = new ArrayList<PartitionGroup>();
            for (int i = 0; i < this.localGroups.size(); ++i) {
                PartitionGroup oldGroup = this.localGroups.get(i);
                RaftNode header = oldGroup.getHeader();
                PartitionGroup newGrp = this.getPartitionGroup(header);
                if (newGrp.contains(node) && newGrp.contains(this.thisNode)) {
                    this.localGroups.set(i, newGrp);
                    continue;
                }
                if (!newGrp.contains(node) || newGrp.contains(this.thisNode)) continue;
                retiredGroups.add(newGrp);
            }
            Iterator<PartitionGroup> groupIterator = this.localGroups.iterator();
            block4: while (groupIterator.hasNext()) {
                PartitionGroup partitionGroup = groupIterator.next();
                for (PartitionGroup retiredGroup : retiredGroups) {
                    if (!retiredGroup.getHeader().equals(partitionGroup.getHeader()) || retiredGroup.getRaftId() != partitionGroup.getRaftId()) continue;
                    groupIterator.remove();
                    continue block4;
                }
            }
        }
        for (int raftId = 0; raftId < this.multiRaftFactor; ++raftId) {
            PartitionGroup newGroup = this.getPartitionGroup(new RaftNode(node, raftId));
            if (!newGroup.contains(this.thisNode)) continue;
            this.localGroups.add(newGroup);
        }
        this.globalGroups = this.calculateGlobalGroups(this.nodeRing);
        this.slotBalancer.moveSlotsToNew(node, oldRing);
        this.nodeRemovalResult = new SlotNodeRemovalResult();
    }

    @Override
    public NodeAdditionResult getNodeAdditionResult(Node node) {
        SlotNodeAdditionResult result = new SlotNodeAdditionResult();
        HashMap<RaftNode, Set<Integer>> lostSlotsMap = new HashMap<RaftNode, Set<Integer>>();
        for (int raftId = 0; raftId < this.multiRaftFactor; ++raftId) {
            RaftNode raftNode = new RaftNode(node, raftId);
            result.addNewGroup(this.getPartitionGroup(raftNode));
            for (Map.Entry<Integer, PartitionGroup> entry : this.previousNodeMap.get(raftNode).entrySet()) {
                RaftNode header = entry.getValue().getHeader();
                lostSlotsMap.computeIfAbsent(header, k -> new HashSet()).add(entry.getKey());
            }
        }
        result.setLostSlots(lostSlotsMap);
        return result;
    }

    @Override
    public List<PartitionGroup> getLocalGroups() {
        return this.localGroups;
    }

    @Override
    public ByteBuffer serialize() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(4096);
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        try {
            dataOutputStream.writeLong(this.lastMetaLogIndex);
            dataOutputStream.writeInt(this.totalSlotNumbers);
            dataOutputStream.writeInt(this.nodeSlotMap.size());
            for (Map.Entry<RaftNode, List<Integer>> entry : this.nodeSlotMap.entrySet()) {
                NodeSerializeUtils.serialize(entry.getKey().getNode(), dataOutputStream);
                dataOutputStream.writeInt(entry.getKey().getRaftId());
                SerializeUtils.serializeIntList(entry.getValue(), (DataOutputStream)dataOutputStream);
            }
            dataOutputStream.writeInt(this.previousNodeMap.size());
            for (Map.Entry<RaftNode, Object> entry : this.previousNodeMap.entrySet()) {
                NodeSerializeUtils.serialize(entry.getKey().getNode(), dataOutputStream);
                dataOutputStream.writeInt(entry.getKey().getRaftId());
                Map prevHolders = (Map)entry.getValue();
                dataOutputStream.writeInt(prevHolders.size());
                for (Map.Entry integerNodeEntry : prevHolders.entrySet()) {
                    ((PartitionGroup)integerNodeEntry.getValue()).serialize(dataOutputStream);
                    dataOutputStream.writeInt((Integer)integerNodeEntry.getKey());
                }
            }
            this.nodeRemovalResult.serialize(dataOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ByteBuffer.wrap(outputStream.toByteArray());
    }

    @Override
    public synchronized boolean deserialize(ByteBuffer buffer) {
        Node node;
        long newLastLogIndex = buffer.getLong();
        if (logger.isDebugEnabled()) {
            logger.debug("Partition table: lastMetaLogIndex {}, newLastLogIndex {}", (Object)this.lastMetaLogIndex, (Object)newLastLogIndex);
        }
        if (this.lastMetaLogIndex != -1L && this.lastMetaLogIndex >= newLastLogIndex) {
            return this.lastMetaLogIndex == newLastLogIndex;
        }
        this.lastMetaLogIndex = newLastLogIndex;
        logger.info("Initializing the partition table from buffer");
        this.totalSlotNumbers = buffer.getInt();
        int size = buffer.getInt();
        this.nodeSlotMap = new HashMap<RaftNode, List<Integer>>();
        for (int i = 0; i < size; ++i) {
            node = new Node();
            NodeSerializeUtils.deserialize(node, buffer);
            RaftNode raftNode = new RaftNode(node, buffer.getInt());
            ArrayList slots = new ArrayList();
            SerializeUtils.deserializeIntList(slots, (ByteBuffer)buffer);
            this.nodeSlotMap.put(raftNode, slots);
            for (Integer slot : slots) {
                this.slotNodes[slot.intValue()] = raftNode;
            }
        }
        int prevNodeMapSize = buffer.getInt();
        this.previousNodeMap = new HashMap<RaftNode, Map<Integer, PartitionGroup>>();
        for (int i = 0; i < prevNodeMapSize; ++i) {
            node = new Node();
            NodeSerializeUtils.deserialize(node, buffer);
            RaftNode raftNode = new RaftNode(node, buffer.getInt());
            HashMap<Integer, PartitionGroup> prevHolders = new HashMap<Integer, PartitionGroup>();
            int holderNum = buffer.getInt();
            for (int i1 = 0; i1 < holderNum; ++i1) {
                PartitionGroup group = new PartitionGroup();
                group.deserialize(buffer);
                prevHolders.put(buffer.getInt(), group);
            }
            this.previousNodeMap.put(raftNode, prevHolders);
        }
        this.nodeRemovalResult = new SlotNodeRemovalResult();
        this.nodeRemovalResult.deserialize(buffer);
        this.nodeRing.clear();
        for (RaftNode raftNode : this.nodeSlotMap.keySet()) {
            if (this.nodeRing.contains(raftNode.getNode())) continue;
            this.nodeRing.add(raftNode.getNode());
        }
        Collections.sort(this.nodeRing);
        logger.info("All known nodes: {}", this.nodeRing);
        this.localGroups = this.getPartitionGroups(this.thisNode);
        return true;
    }

    @Override
    public List<Node> getAllNodes() {
        return this.nodeRing;
    }

    public Map<RaftNode, Map<Integer, PartitionGroup>> getPreviousNodeMap() {
        return this.previousNodeMap;
    }

    public Map<Integer, PartitionGroup> getPreviousNodeMap(RaftNode raftNode) {
        return this.previousNodeMap.get(raftNode);
    }

    public List<Integer> getNodeSlots(RaftNode header) {
        return this.nodeSlotMap.get(header);
    }

    public Map<RaftNode, List<Integer>> getAllNodeSlots() {
        return this.nodeSlotMap;
    }

    public int getTotalSlotNumbers() {
        return this.totalSlotNumbers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlotPartitionTable that = (SlotPartitionTable)o;
        return this.totalSlotNumbers == that.totalSlotNumbers && Objects.equals(this.nodeRing, that.nodeRing) && Objects.equals(this.nodeSlotMap, that.nodeSlotMap) && Arrays.equals(this.slotNodes, that.slotNodes) && Objects.equals(this.previousNodeMap, that.previousNodeMap) && this.lastMetaLogIndex == that.lastMetaLogIndex;
    }

    public int hashCode() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNode(Node target) {
        List<Node> list = this.nodeRing;
        synchronized (list) {
            int i;
            if (!this.nodeRing.contains(target)) {
                return;
            }
            SlotNodeRemovalResult result = new SlotNodeRemovalResult();
            for (int raftId = 0; raftId < this.multiRaftFactor; ++raftId) {
                result.addRemovedGroup(this.getPartitionGroup(new RaftNode(target, raftId)));
            }
            this.nodeRing.remove(target);
            ArrayList<Integer> removedGroupIdxs = new ArrayList<Integer>();
            for (i = 0; i < this.localGroups.size(); ++i) {
                PartitionGroup oldGroup = this.localGroups.get(i);
                RaftNode header = oldGroup.getHeader();
                if (header.getNode().equals(target)) {
                    removedGroupIdxs.add(i);
                    continue;
                }
                PartitionGroup newGrp = this.getPartitionGroup(header);
                this.localGroups.set(i, newGrp);
            }
            for (i = removedGroupIdxs.size() - 1; i >= 0; --i) {
                int removedGroupIdx = (Integer)removedGroupIdxs.get(i);
                int raftId = this.localGroups.get(removedGroupIdx).getRaftId();
                this.localGroups.remove(removedGroupIdx);
                int thisNodeIdx = this.nodeRing.indexOf(this.thisNode);
                if (thisNodeIdx == -1) continue;
                int headerNodeIdx = thisNodeIdx - (this.replicationNum - 1);
                headerNodeIdx = headerNodeIdx < 0 ? headerNodeIdx + this.nodeRing.size() : headerNodeIdx;
                Node header = this.nodeRing.get(headerNodeIdx);
                PartitionGroup newGrp = this.getPartitionGroup(new RaftNode(header, raftId));
                this.localGroups.add(newGrp);
            }
            this.globalGroups = this.calculateGlobalGroups(this.nodeRing);
            Map<RaftNode, List<Integer>> raftNodeListMap = this.slotBalancer.retrieveSlots(target);
            result.addNewSlotOwners(raftNodeListMap);
            this.nodeRemovalResult = result;
        }
    }

    @Override
    public NodeRemovalResult getNodeRemovalResult() {
        return this.nodeRemovalResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PartitionGroup> getGlobalGroups() {
        List<Node> list = this.nodeRing;
        synchronized (list) {
            if (this.globalGroups == null) {
                this.globalGroups = this.calculateGlobalGroups(this.nodeRing);
            }
            return this.globalGroups;
        }
    }

    public boolean judgeHoldSlot(Node node, int slot) {
        return this.getPartitionGroup(this.slotNodes[slot]).contains(node);
    }

    @Override
    public List<PartitionGroup> calculateGlobalGroups(List<Node> nodeRing) {
        ArrayList<PartitionGroup> result = new ArrayList<PartitionGroup>();
        for (Node node : nodeRing) {
            for (int i = 0; i < this.multiRaftFactor; ++i) {
                result.add(this.getPartitionGroup(new RaftNode(node, i), nodeRing));
            }
        }
        return result;
    }

    @Override
    public long getLastMetaLogIndex() {
        return this.lastMetaLogIndex;
    }

    @Override
    public void setLastMetaLogIndex(long lastMetaLogIndex) {
        if (logger.isDebugEnabled()) {
            logger.debug("Set last meta log index of partition table to {}", (Object)lastMetaLogIndex);
        }
        this.lastMetaLogIndex = Math.max(this.lastMetaLogIndex, lastMetaLogIndex);
    }

    public RaftNode[] getSlotNodes() {
        return this.slotNodes;
    }
}

