/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.member;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.cluster.ClusterIoTDB;
import org.apache.iotdb.cluster.client.ClientCategory;
import org.apache.iotdb.cluster.client.ClientManager;
import org.apache.iotdb.cluster.client.async.AsyncMetaClient;
import org.apache.iotdb.cluster.client.sync.SyncClientAdaptor;
import org.apache.iotdb.cluster.client.sync.SyncMetaClient;
import org.apache.iotdb.cluster.config.ClusterConstant;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.coordinator.Coordinator;
import org.apache.iotdb.cluster.exception.AddSelfException;
import org.apache.iotdb.cluster.exception.CheckConsistencyException;
import org.apache.iotdb.cluster.exception.ConfigInconsistentException;
import org.apache.iotdb.cluster.exception.EmptyIntervalException;
import org.apache.iotdb.cluster.exception.LogExecutionException;
import org.apache.iotdb.cluster.exception.PartitionTableUnavailableException;
import org.apache.iotdb.cluster.exception.SnapshotInstallationException;
import org.apache.iotdb.cluster.exception.StartUpCheckFailureException;
import org.apache.iotdb.cluster.log.applier.MetaLogApplier;
import org.apache.iotdb.cluster.log.logtypes.AddNodeLog;
import org.apache.iotdb.cluster.log.logtypes.EmptyContentLog;
import org.apache.iotdb.cluster.log.logtypes.RemoveNodeLog;
import org.apache.iotdb.cluster.log.manage.MetaSingleSnapshotLogManager;
import org.apache.iotdb.cluster.log.manage.RaftLogManager;
import org.apache.iotdb.cluster.log.snapshot.MetaSimpleSnapshot;
import org.apache.iotdb.cluster.partition.NodeAdditionResult;
import org.apache.iotdb.cluster.partition.NodeRemovalResult;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.partition.PartitionTable;
import org.apache.iotdb.cluster.partition.slot.SlotPartitionTable;
import org.apache.iotdb.cluster.query.ClusterPlanRouter;
import org.apache.iotdb.cluster.rpc.thrift.AddNodeResponse;
import org.apache.iotdb.cluster.rpc.thrift.CheckStatusResponse;
import org.apache.iotdb.cluster.rpc.thrift.ElectionRequest;
import org.apache.iotdb.cluster.rpc.thrift.HeartBeatRequest;
import org.apache.iotdb.cluster.rpc.thrift.HeartBeatResponse;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftNode;
import org.apache.iotdb.cluster.rpc.thrift.SendSnapshotRequest;
import org.apache.iotdb.cluster.rpc.thrift.StartUpStatus;
import org.apache.iotdb.cluster.rpc.thrift.TSMetaService;
import org.apache.iotdb.cluster.server.NodeCharacter;
import org.apache.iotdb.cluster.server.handlers.caller.GenericHandler;
import org.apache.iotdb.cluster.server.handlers.caller.NodeStatusHandler;
import org.apache.iotdb.cluster.server.heartbeat.MetaHeartbeatThread;
import org.apache.iotdb.cluster.server.member.DataGroupMember;
import org.apache.iotdb.cluster.server.member.MetaGroupMemberMBean;
import org.apache.iotdb.cluster.server.member.RaftMember;
import org.apache.iotdb.cluster.server.monitor.NodeReport;
import org.apache.iotdb.cluster.server.monitor.NodeStatusManager;
import org.apache.iotdb.cluster.server.monitor.Timer;
import org.apache.iotdb.cluster.server.service.DataGroupEngine;
import org.apache.iotdb.cluster.utils.ClusterUtils;
import org.apache.iotdb.cluster.utils.PartitionUtils;
import org.apache.iotdb.cluster.utils.StatusUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.exception.IoTDBException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.service.ServiceType;
import org.apache.iotdb.db.utils.TimeValuePairUtils;
import org.apache.iotdb.service.rpc.thrift.EndPoint;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaGroupMember
extends RaftMember
implements IService,
MetaGroupMemberMBean {
    private static final String mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.cluster.service", "type", "MetaGroupEngine");
    static final String NODE_IDENTIFIER_FILE_NAME = IoTDBDescriptor.getInstance().getConfig().getSystemDir() + File.separator + "node_identifier";
    static final String PARTITION_FILE_NAME = IoTDBDescriptor.getInstance().getConfig().getSystemDir() + File.separator + "partitions";
    private static final String TEMP_SUFFIX = ".tmp";
    private static final Logger logger = LoggerFactory.getLogger(MetaGroupMember.class);
    private static final int DEFAULT_JOIN_RETRY = 10;
    private final Set<Node> blindNodes = new HashSet<Node>();
    private final Set<Node> idConflictNodes = new HashSet<Node>();
    private Map<Integer, Node> idNodeMap = null;
    private PartitionTable partitionTable;
    private ClusterPlanRouter router;
    private StartUpStatus startUpStatus;
    private Coordinator coordinator;
    boolean ready = false;

    public void setCoordinator(Coordinator coordinator) {
        this.coordinator = coordinator;
    }

    public Coordinator getCoordinator() {
        return this.coordinator;
    }

    public ClusterPlanRouter getRouter() {
        return this.router;
    }

    @Override
    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    public MetaGroupMember() {
    }

    public MetaGroupMember(TProtocolFactory factory, Node thisNode, Coordinator coordinator) {
        super("Meta", new ClientManager(ClusterDescriptor.getInstance().getConfig().isUseAsyncServer(), ClientManager.Type.MetaGroupClient));
        this.allNodes = new PartitionGroup();
        this.initPeerMap();
        MetaLogApplier metaLogApplier = new MetaLogApplier(this);
        this.logManager = new MetaSingleSnapshotLogManager(metaLogApplier, this);
        this.term.set(this.logManager.getHardState().getCurrentTerm());
        this.voteFor = this.logManager.getHardState().getVoteFor();
        this.setThisNode(thisNode);
        this.loadIdentifier();
        this.allNodes.add(thisNode);
        this.startUpStatus = this.getNewStartUpStatus();
        this.coordinator = coordinator;
        coordinator.linkMetaGroupMember(this);
        this.loadPartitionTable();
    }

    public boolean closePartition(String storageGroupName, long partitionId, boolean isSeq) {
        RaftNode raftNode = this.partitionTable.routeToHeaderByTime(storageGroupName, partitionId * StorageEngine.getTimePartitionInterval());
        DataGroupMember localDataMember = this.getLocalDataMember(raftNode);
        if (localDataMember == null || localDataMember.getCharacter() != NodeCharacter.LEADER) {
            return false;
        }
        return localDataMember.closePartition(storageGroupName, partitionId, isSeq);
    }

    DataGroupEngine getDataGroupEngine() {
        return ClusterIoTDB.getInstance().getDataGroupEngine();
    }

    @Override
    public void start() {
        if (this.heartBeatService != null) {
            return;
        }
        this.addSeedNodes();
        NodeStatusManager.getINSTANCE().setMetaGroupMember(this);
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        logger.info("{}: stopped", (Object)this.name);
    }

    public ServiceType getID() {
        return ServiceType.CLUSTER_META_ENGINE;
    }

    protected void addSeedNodes() {
        if (this.allNodes.size() > 1) {
            return;
        }
        List<String> seedUrls = this.config.getSeedNodeUrls();
        for (String seedUrl : seedUrls) {
            Node node = ClusterUtils.parseNode(seedUrl);
            if (node == null || node.getInternalIp().equals(this.thisNode.internalIp) && node.getMetaPort() == this.thisNode.getMetaPort() || this.allNodes.contains(node)) continue;
            this.allNodes.add(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyAddNode(AddNodeLog addNodeLog) {
        long startTime = System.currentTimeMillis();
        Node newNode = addNodeLog.getNewNode();
        PartitionGroup partitionGroup = this.allNodes;
        synchronized (partitionGroup) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: adding a new node {} into {}", new Object[]{this.name, newNode, this.allNodes});
            }
            if (!this.allNodes.contains(newNode)) {
                this.registerNodeIdentifier(newNode, newNode.getNodeIdentifier());
                this.allNodes.add(newNode);
            }
            this.savePartitionTable();
            NodeAdditionResult result = this.partitionTable.getNodeAdditionResult(newNode);
            this.getDataGroupEngine().addNode(newNode, result);
            if (logger.isDebugEnabled()) {
                logger.debug("{}: success to add a new node {} into {}", new Object[]{this.name, newNode, this.allNodes});
            }
        }
        logger.info("{}: execute adding node {} cost {} ms", new Object[]{this.name, newNode, System.currentTimeMillis() - startTime});
    }

    public void buildCluster() throws ConfigInconsistentException, StartUpCheckFailureException {
        this.checkSeedNodesStatus();
        this.threadTaskInit();
        if (this.allNodes.size() == 1) {
            if (this.partitionTable == null) {
                this.partitionTable = new SlotPartitionTable(this.allNodes, this.thisNode);
                logger.info("Partition table is set up");
            }
            this.initIdNodeMap();
            this.router = new ClusterPlanRouter(this.partitionTable);
            this.coordinator.setRouter(this.router);
            this.rebuildDataGroups();
            this.ready = true;
        }
    }

    private void threadTaskInit() {
        this.heartBeatService.submit(new MetaHeartbeatThread(this));
    }

    public void joinCluster() throws ConfigInconsistentException, StartUpCheckFailureException {
        if (this.allNodes.size() == 1) {
            logger.error("Seed nodes not provided, cannot join cluster");
            throw new ConfigInconsistentException();
        }
        int retry = 10;
        while (retry > 0) {
            Node node = (Node)this.allNodes.get(this.random.nextInt(this.allNodes.size()));
            if (node.equals(this.thisNode)) continue;
            logger.info("start joining the cluster with the help of {}", (Object)node);
            try {
                if (this.joinCluster(node, this.startUpStatus)) {
                    logger.info("Joined a cluster, starting the heartbeat thread");
                    this.setCharacter(NodeCharacter.FOLLOWER);
                    this.setLastHeartbeatReceivedTime(System.currentTimeMillis());
                    this.threadTaskInit();
                    return;
                }
                Thread.sleep(ClusterDescriptor.getInstance().getConfig().getJoinClusterTimeOutMs());
            }
            catch (TException e) {
                logger.warn("Cannot join the cluster from {}, because:", (Object)node, (Object)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("Unexpected interruption when waiting to join a cluster", (Throwable)e);
            }
            --retry;
        }
        logger.error("Cannot join the cluster after {} retries", (Object)10);
        throw new StartUpCheckFailureException();
    }

    public StartUpStatus getNewStartUpStatus() {
        StartUpStatus newStartUpStatus = new StartUpStatus();
        newStartUpStatus.setPartitionInterval(IoTDBDescriptor.getInstance().getConfig().getPartitionInterval());
        newStartUpStatus.setHashSalt(2333);
        newStartUpStatus.setReplicationNumber(ClusterDescriptor.getInstance().getConfig().getReplicationNum());
        newStartUpStatus.setClusterName(ClusterDescriptor.getInstance().getConfig().getClusterName());
        newStartUpStatus.setMultiRaftFactor(ClusterDescriptor.getInstance().getConfig().getMultiRaftFactor());
        List<String> seedUrls = ClusterDescriptor.getInstance().getConfig().getSeedNodeUrls();
        ArrayList<Node> seedNodeList = new ArrayList<Node>();
        for (String seedUrl : seedUrls) {
            seedNodeList.add(ClusterUtils.parseNode(seedUrl));
        }
        newStartUpStatus.setSeedNodeList(seedNodeList);
        return newStartUpStatus;
    }

    private boolean joinCluster(Node node, StartUpStatus startUpStatus) throws TException, InterruptedException, ConfigInconsistentException {
        AddNodeResponse resp;
        Object client;
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            client = (AsyncMetaClient)this.getAsyncClient(node);
            if (client == null) {
                return false;
            }
            resp = SyncClientAdaptor.addNode(client, this.thisNode, startUpStatus);
        } else {
            client = (SyncMetaClient)this.getSyncClient(node);
            if (client == null) {
                return false;
            }
            try {
                resp = client.addNode(this.thisNode, startUpStatus);
            }
            catch (TException e) {
                ((SyncMetaClient)((Object)client)).close();
                throw e;
            }
            finally {
                ((SyncMetaClient)((Object)client)).returnSelf();
            }
        }
        if (resp == null) {
            logger.warn("Join cluster request timed out");
        } else {
            if ((long)resp.getRespNum() == -1L) {
                logger.info("Node {} admitted this node into the cluster", (Object)node);
                ByteBuffer partitionTableBuffer = resp.partitionTableBytes;
                this.acceptVerifiedPartitionTable(partitionTableBuffer, true);
                return true;
            }
            if ((long)resp.getRespNum() == -5L) {
                logger.info("The identifier {} conflicts the existing ones, regenerate a new one", (Object)this.thisNode.getNodeIdentifier());
                this.setNodeIdentifier(this.genNodeIdentifier());
            } else if ((long)resp.getRespNum() == -9L) {
                this.handleConfigInconsistency(resp);
            } else if ((long)resp.getRespNum() == -10L) {
                logger.warn("The data migration of the previous membership change operation is not finished. Please try again later");
            } else {
                logger.warn("Joining the cluster is rejected by {} for response {}", (Object)node, (Object)resp.getRespNum());
            }
        }
        return false;
    }

    private void handleConfigInconsistency(AddNodeResponse resp) throws ConfigInconsistentException {
        CheckStatusResponse checkStatusResponse = resp.getCheckStatusResponse();
        String parameters = (checkStatusResponse.isPartitionalIntervalEquals() ? "" : ", partition interval") + (checkStatusResponse.isHashSaltEquals() ? "" : ", hash salt") + (checkStatusResponse.isReplicationNumEquals() ? "" : ", replication number") + (checkStatusResponse.isSeedNodeEquals() ? "" : ", seedNodes") + (checkStatusResponse.isClusterNameEquals() ? "" : ", clusterName") + (checkStatusResponse.isMultiRaftFactorEquals() ? "" : ", multiRaftFactor");
        logger.error("The start up configuration{} conflicts the cluster. Please reset the configurations. ", (Object)parameters.substring(1));
        throw new ConfigInconsistentException();
    }

    @Override
    long checkElectorLogProgress(ElectionRequest electionRequest) {
        Node elector = electionRequest.getElector();
        if (this.partitionTable != null && !this.allNodes.contains(elector)) {
            logger.info("{}: the elector {} is not in the data group {}, so reject this election.", new Object[]{this.name, this.getPartitionGroup(), elector});
            return -11L;
        }
        return super.checkElectorLogProgress(electionRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void processValidHeartbeatReq(HeartBeatRequest request, HeartBeatResponse response) {
        if (request.isRequireIdentifier()) {
            if (request.isRegenerateIdentifier()) {
                this.setNodeIdentifier(this.genNodeIdentifier());
            }
            logger.debug("Send identifier {} to the leader", (Object)this.thisNode.getNodeIdentifier());
            response.setFollowerIdentifier(this.thisNode.getNodeIdentifier());
        }
        if (this.partitionTable == null) {
            if (request.isSetPartitionTableBytes()) {
                MetaGroupMember metaGroupMember = this;
                synchronized (metaGroupMember) {
                    if (this.partitionTable == null) {
                        ByteBuffer byteBuffer = request.partitionTableBytes;
                        this.acceptVerifiedPartitionTable(byteBuffer, true);
                    }
                }
            } else {
                logger.debug("Request cluster nodes from the leader");
                response.setRequirePartitionTable(true);
            }
        }
        if (!this.ready) {
            if (response.isSetFollowerIdentifier()) {
                return;
            }
            if (response.isSetRequirePartitionTable()) {
                return;
            }
            if (request.getTerm() == this.term.get() && request.getCommitLogIndex() == this.getLogManager().getCommitLogIndex()) {
                logger.info("Meta Group is ready");
                this.rebuildDataGroups();
                this.ready = true;
            }
        }
    }

    protected synchronized void acceptPartitionTable(ByteBuffer partitionTableBuffer, boolean needSerialization) {
        SlotPartitionTable newTable = new SlotPartitionTable(this.thisNode);
        newTable.deserialize(partitionTableBuffer);
        if (this.partitionTable != null) {
            long currIndex = this.partitionTable.getLastMetaLogIndex();
            long incomingIndex = newTable.getLastMetaLogIndex();
            logger.info("Current partition table index {}, new partition table index {}", (Object)currIndex, (Object)incomingIndex);
            if (currIndex >= incomingIndex) {
                return;
            }
        }
        this.partitionTable = newTable;
        if (needSerialization) {
            this.savePartitionTable();
        }
        this.router = new ClusterPlanRouter(newTable);
        this.coordinator.setRouter(this.router);
        this.updateNodeList(newTable.getAllNodes());
    }

    public synchronized void acceptVerifiedPartitionTable(ByteBuffer partitionTableBuffer, boolean needSerialization) {
        logger.info("new Partition Table is received.");
        this.acceptPartitionTable(partitionTableBuffer, needSerialization);
        this.rebuildDataGroups();
        logger.info("The Meta Engine is ready");
        this.ready = true;
    }

    private void updateNodeList(Collection<Node> nodes) {
        this.allNodes = new PartitionGroup(nodes);
        this.initPeerMap();
        logger.info("All nodes in the partition table: {}", (Object)this.allNodes);
        this.initIdNodeMap();
        for (Node n : this.allNodes) {
            this.idNodeMap.put(n.getNodeIdentifier(), n);
        }
    }

    @Override
    public void processValidHeartbeatResp(HeartBeatResponse response, Node receiver) {
        if (response.isSetFollowerIdentifier()) {
            this.registerNodeIdentifier(response.getFollower(), response.getFollowerIdentifier());
            this.buildMetaEngineServiceIfNotReady();
        }
        if (response.isRequirePartitionTable()) {
            this.addBlindNode(receiver);
        }
    }

    public void buildMetaEngineServiceIfNotReady() {
        if (!this.ready && this.allNodesIdKnown()) {
            this.allNodes = new PartitionGroup(this.idNodeMap.values());
            if (this.partitionTable == null) {
                this.partitionTable = new SlotPartitionTable(this.allNodes, this.thisNode);
                logger.info("Partition table is set up");
            }
            this.router = new ClusterPlanRouter(this.partitionTable);
            this.coordinator.setRouter(this.router);
            this.rebuildDataGroups();
            logger.info("The Meta Engine is ready");
            this.ready = true;
        }
    }

    private void addBlindNode(Node node) {
        logger.debug("Node {} requires the node list (partition table)", (Object)node);
        this.blindNodes.add(node);
    }

    public boolean isNodeBlind(Node node) {
        return this.blindNodes.contains(node);
    }

    public void removeBlindNode(Node node) {
        this.blindNodes.remove(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNodeIdentifier(Node node, int identifier) {
        Map<Integer, Node> map = this.idNodeMap;
        synchronized (map) {
            Node conflictNode = this.idNodeMap.get(identifier);
            if (conflictNode != null && !conflictNode.equals(node)) {
                this.idConflictNodes.add(node);
                return;
            }
            node.setNodeIdentifier(identifier);
            logger.info("Node {} registered with id {}", (Object)node, (Object)identifier);
            this.idNodeMap.put(identifier, node);
            this.idConflictNodes.remove(node);
        }
    }

    private void initIdNodeMap() {
        this.idNodeMap = new HashMap<Integer, Node>();
        this.idNodeMap.put(this.thisNode.getNodeIdentifier(), this.thisNode);
    }

    private boolean allNodesIdKnown() {
        return this.idNodeMap != null && this.idNodeMap.size() == this.allNodes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void rebuildDataGroups() {
        logger.info("Starting sub-servers...");
        PartitionTable partitionTable = this.partitionTable;
        synchronized (partitionTable) {
            try {
                this.getDataGroupEngine().buildDataGroupMembers(this.partitionTable);
                this.sendHandshake();
            }
            catch (Exception e) {
                logger.error("Build partition table failed: ", (Throwable)e);
                this.stop();
                return;
            }
        }
        logger.info("Sub-servers started.");
    }

    public void sendHandshake() {
        for (Node node : this.allNodes) {
            if (ClusterUtils.nodeEqual(node, this.thisNode)) continue;
            this.sendHandshakeForOneNode(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendHandshakeForOneNode(Node node) {
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            AsyncMetaClient asyncClient = (AsyncMetaClient)this.getAsyncClient(node);
            if (asyncClient != null) {
                try {
                    asyncClient.handshake(this.thisNode, new GenericHandler(node, null));
                }
                catch (TException e) {
                    logger.error("failed send handshake to node: {}", (Object)node, (Object)e);
                }
            } else {
                logger.error("send handshake fail as get empty async client");
            }
        } else {
            SyncMetaClient syncClient = (SyncMetaClient)this.getSyncClient(node);
            if (syncClient != null) {
                try {
                    syncClient.handshake(this.thisNode);
                }
                catch (TException e) {
                    syncClient.close();
                    logger.error("failed send handshake to node: {}", (Object)node, (Object)e);
                }
                finally {
                    syncClient.returnSelf();
                }
            } else {
                logger.error("send handshake fail as get empty sync client");
            }
        }
    }

    public AddNodeResponse addNode(Node node, StartUpStatus startUpStatus) throws AddSelfException, LogExecutionException, InterruptedException, CheckConsistencyException {
        AddNodeResponse response = new AddNodeResponse();
        if (this.partitionTable == null) {
            logger.info("Cannot add node now because the partition table is not set");
            response.setRespNum(-4);
            return response;
        }
        logger.info("A node {} wants to join this cluster", (Object)node);
        if (node.equals(this.thisNode)) {
            throw new AddSelfException();
        }
        this.waitLeader();
        if (this.processAddNodeLocally(node, startUpStatus, response)) {
            return response;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processAddNodeLocally(Node newNode, StartUpStatus startUpStatus, AddNodeResponse response) throws LogExecutionException, InterruptedException, CheckConsistencyException {
        if (this.character != NodeCharacter.LEADER) {
            return false;
        }
        if (!this.waitDataMigrationEnd()) {
            response.setRespNum(-10);
            return true;
        }
        for (Node node : this.partitionTable.getAllNodes()) {
            if (!node.internalIp.equals(newNode.internalIp) || newNode.dataPort != node.dataPort || newNode.metaPort != node.metaPort || newNode.clientPort != node.clientPort) continue;
            newNode.nodeIdentifier = node.nodeIdentifier;
            break;
        }
        if (this.allNodes.contains(newNode)) {
            logger.debug("Node {} is already in the cluster", (Object)newNode);
            response.setRespNum(-1);
            PartitionTable partitionTable = this.partitionTable;
            synchronized (partitionTable) {
                response.setPartitionTableBytes(this.partitionTable.serialize());
            }
            return true;
        }
        Node idConflictNode = this.idNodeMap.get(newNode.getNodeIdentifier());
        if (idConflictNode != null) {
            logger.debug("{}'s id conflicts with {}", (Object)newNode, (Object)idConflictNode);
            response.setRespNum(-5);
            return true;
        }
        if (!this.checkNodeConfig(startUpStatus, response)) {
            return true;
        }
        AddNodeLog addNodeLog = new AddNodeLog();
        RaftLogManager raftLogManager = this.logManager;
        synchronized (raftLogManager) {
            SlotPartitionTable table = new SlotPartitionTable(this.thisNode);
            table.deserialize(this.partitionTable.serialize());
            table.addNode(newNode);
            table.setLastMetaLogIndex(this.logManager.getLastLogIndex() + 1L);
            addNodeLog.setPartitionTable(table.serialize());
            addNodeLog.setCurrLogTerm(this.getTerm().get());
            addNodeLog.setCurrLogIndex(this.logManager.getLastLogIndex() + 1L);
            addNodeLog.setMetaLogIndex(this.logManager.getLastLogIndex() + 1L);
            addNodeLog.setNewNode(newNode);
            this.logManager.append(addNodeLog);
        }
        int retryTime = 0;
        block16: while (true) {
            logger.info("{}: Send the join request of {} to other nodes, retry time: {}", new Object[]{this.name, newNode, retryTime});
            RaftMember.AppendLogResult result = this.sendLogToFollowers(addNodeLog);
            switch (result) {
                case OK: {
                    this.commitLog(addNodeLog);
                    logger.info("{}: Join request of {} is accepted", (Object)this.name, (Object)newNode);
                    PartitionTable partitionTable = this.partitionTable;
                    synchronized (partitionTable) {
                        response.setPartitionTableBytes(this.partitionTable.serialize());
                    }
                    response.setRespNum(-1);
                    logger.info("{}: Sending join response of {}", (Object)this.name, (Object)newNode);
                    return true;
                }
                case TIME_OUT: {
                    logger.debug("{}: log {} timed out, retrying...", (Object)this.name, (Object)addNodeLog);
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    logger.info("{}: Join request of {} timed out", (Object)this.name, (Object)newNode);
                    ++retryTime;
                    continue block16;
                }
            }
            break;
        }
        return false;
    }

    private boolean waitDataMigrationEnd() throws InterruptedException, CheckConsistencyException {
        int retryTime = 0;
        while (true) {
            Map<PartitionGroup, Integer> res;
            if ((res = this.collectAllPartitionMigrationStatus()) != null && res.isEmpty()) {
                return true;
            }
            if (++retryTime == 5) break;
            Thread.sleep(10L);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEmptyContentLog() {
        EmptyContentLog log = new EmptyContentLog();
        RaftLogManager raftLogManager = this.logManager;
        synchronized (raftLogManager) {
            log.setCurrLogTerm(this.getTerm().get());
            log.setCurrLogIndex(this.logManager.getLastLogIndex() + 1L);
            this.logManager.append(log);
        }
        int retryTime = 0;
        block11: while (true) {
            logger.debug("{} Send empty content log to other nodes, retry time: {}", (Object)this.name, (Object)retryTime);
            RaftMember.AppendLogResult result = this.sendLogToFollowers(log);
            switch (result) {
                case OK: {
                    try {
                        this.commitLog(log);
                    }
                    catch (LogExecutionException e) {
                        logger.error("{}: Fail to execute empty content log", (Object)this.name, (Object)e);
                    }
                    return;
                }
                case TIME_OUT: {
                    logger.debug("{}: add empty content log timed out, retry.", (Object)this.name);
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    ++retryTime;
                    continue block11;
                }
            }
            break;
        }
    }

    private boolean checkNodeConfig(StartUpStatus remoteStartUpStatus, AddNodeResponse response) {
        long remotePartitionInterval = remoteStartUpStatus.getPartitionInterval();
        int remoteHashSalt = remoteStartUpStatus.getHashSalt();
        int remoteReplicationNum = remoteStartUpStatus.getReplicationNumber();
        int remoteMultiRaftFactor = remoteStartUpStatus.getMultiRaftFactor();
        String remoteClusterName = remoteStartUpStatus.getClusterName();
        List remoteSeedNodeList = remoteStartUpStatus.getSeedNodeList();
        long localPartitionInterval = IoTDBDescriptor.getInstance().getConfig().getPartitionInterval();
        int localHashSalt = 2333;
        int localReplicationNum = this.config.getReplicationNum();
        String localClusterName = this.config.getClusterName();
        int localMultiRaftFactor = this.config.getMultiRaftFactor();
        boolean partitionIntervalEquals = true;
        boolean multiRaftFactorEquals = true;
        boolean hashSaltEquals = true;
        boolean replicationNumEquals = true;
        boolean seedNodeEquals = true;
        boolean clusterNameEquals = true;
        if (localPartitionInterval != remotePartitionInterval) {
            partitionIntervalEquals = false;
            logger.info("Remote partition interval conflicts with the leader's. Leader: {}, remote: {}", (Object)localPartitionInterval, (Object)remotePartitionInterval);
        }
        if (localMultiRaftFactor != remoteMultiRaftFactor) {
            multiRaftFactorEquals = false;
            logger.info("Remote multi-raft factor conflicts with the leader's. Leader: {}, remote: {}", (Object)localMultiRaftFactor, (Object)remoteMultiRaftFactor);
        }
        if (localHashSalt != remoteHashSalt) {
            hashSaltEquals = false;
            logger.info("Remote hash salt conflicts with the leader's. Leader: {}, remote: {}", (Object)localHashSalt, (Object)remoteHashSalt);
        }
        if (localReplicationNum != remoteReplicationNum) {
            replicationNumEquals = false;
            logger.info("Remote replication number conflicts with the leader's. Leader: {}, remote: {}", (Object)localReplicationNum, (Object)remoteReplicationNum);
        }
        if (!Objects.equals(localClusterName, remoteClusterName)) {
            clusterNameEquals = false;
            logger.info("Remote cluster name conflicts with the leader's. Leader: {}, remote: {}", (Object)localClusterName, (Object)remoteClusterName);
        }
        if (!ClusterUtils.checkSeedNodes(true, this.allNodes, remoteSeedNodeList)) {
            seedNodeEquals = false;
            if (logger.isInfoEnabled()) {
                logger.info("Remote seed node list conflicts with the leader's. Leader: {}, remote: {}", (Object)Arrays.toString(this.allNodes.toArray(new Node[0])), (Object)remoteSeedNodeList);
            }
        }
        if (!(partitionIntervalEquals && hashSaltEquals && replicationNumEquals && seedNodeEquals && clusterNameEquals && multiRaftFactorEquals)) {
            response.setRespNum(-9);
            response.setCheckStatusResponse(new CheckStatusResponse(partitionIntervalEquals, hashSaltEquals, replicationNumEquals, seedNodeEquals, clusterNameEquals, multiRaftFactorEquals));
            return false;
        }
        return true;
    }

    private void checkSeedNodesStatus() throws ConfigInconsistentException, StartUpCheckFailureException {
        if (this.getAllNodes().size() == 1) {
            return;
        }
        boolean canEstablishCluster = false;
        long startTime = System.currentTimeMillis();
        AtomicInteger consistentNum = new AtomicInteger(1);
        AtomicInteger inconsistentNum = new AtomicInteger(0);
        while (!canEstablishCluster) {
            consistentNum.set(1);
            inconsistentNum.set(0);
            this.checkSeedNodesStatusOnce(consistentNum, inconsistentNum);
            logger.debug("Status check result: consistent nodes: {}, inconsistent nodes: {}, total nodes: {}", new Object[]{consistentNum.get(), inconsistentNum.get(), this.getAllNodes().size()});
            canEstablishCluster = ClusterUtils.analyseStartUpCheckResult(consistentNum.get(), inconsistentNum.get(), this.getAllNodes().size());
            if (System.currentTimeMillis() - startTime > 300000L) {
                throw new StartUpCheckFailureException();
            }
            if (canEstablishCluster) continue;
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("Unexpected interruption when waiting for next start up check", (Throwable)e);
            }
        }
    }

    private void checkSeedNodesStatusOnce(AtomicInteger consistentNum, AtomicInteger inconsistentNum) {
        ScheduledThreadPoolExecutor pool = new ScheduledThreadPoolExecutor(this.getAllNodes().size() - 1);
        for (Node seedNode : this.getAllNodes()) {
            Node thisNode;
            if (seedNode.equals(thisNode = this.getThisNode())) continue;
            pool.submit(() -> {
                logger.debug("Checking status with {}", (Object)seedNode);
                CheckStatusResponse response = null;
                try {
                    response = this.checkStatus(seedNode);
                }
                catch (Exception e) {
                    logger.warn("Exception during status check", (Throwable)e);
                }
                logger.debug("CheckStatusResponse from {}: {}", (Object)seedNode, (Object)response);
                if (response != null) {
                    ClusterUtils.examineCheckStatusResponse(response, consistentNum, inconsistentNum, seedNode);
                } else {
                    logger.warn("Start up exception. Cannot connect to node {}. Try again in next turn.", (Object)seedNode);
                }
            });
        }
        pool.shutdown();
        try {
            if (!pool.awaitTermination(5L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("Unexpected interruption when waiting for start up checks", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CheckStatusResponse checkStatus(Node seedNode) {
        block11: {
            if (this.config.isUseAsyncServer()) {
                AsyncMetaClient client = (AsyncMetaClient)this.getAsyncClient(seedNode);
                if (client == null) {
                    return null;
                }
                try {
                    return SyncClientAdaptor.checkStatus(client, this.getStartUpStatus());
                }
                catch (TException e) {
                    logger.warn("Error occurs when check status on node : {}", (Object)seedNode);
                    break block11;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.warn("Current thread is interrupted.");
                    break block11;
                }
            }
            SyncMetaClient client = (SyncMetaClient)this.getSyncClient(seedNode, false);
            if (client == null) {
                return null;
            }
            try {
                CheckStatusResponse e = client.checkStatus(this.getStartUpStatus());
                return e;
            }
            catch (TException e) {
                client.close();
                logger.warn("Error occurs when check status on node : {}", (Object)seedNode);
            }
            finally {
                client.returnSelf();
            }
        }
        return null;
    }

    public Set<Node> getIdConflictNodes() {
        return this.idConflictNodes;
    }

    @Override
    public void onElectionWins() {
        if (this.idNodeMap == null) {
            this.initIdNodeMap();
        }
    }

    private void loadPartitionTable() {
        File partitionFile = new File(PARTITION_FILE_NAME);
        if (!partitionFile.exists() && !this.recoverPartitionTableFile()) {
            logger.info("No partition table file found");
            return;
        }
        this.initIdNodeMap();
        try (DataInputStream inputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(partitionFile)));){
            int size = inputStream.readInt();
            byte[] tableBuffer = new byte[size];
            int readCnt = inputStream.read(tableBuffer);
            if (readCnt < size) {
                throw new IOException(String.format("Expected partition table size: %s, actual read: %s", size, readCnt));
            }
            ByteBuffer wrap = ByteBuffer.wrap(tableBuffer);
            logger.info("Load Partition Table locally.");
            this.acceptPartitionTable(wrap, false);
            logger.info("Load {} nodes: {}", (Object)this.allNodes.size(), (Object)this.allNodes);
        }
        catch (IOException e) {
            logger.error("Cannot load the partition table", (Throwable)e);
        }
    }

    private boolean recoverPartitionTableFile() {
        File tempFile = new File(PARTITION_FILE_NAME + TEMP_SUFFIX);
        if (!tempFile.exists()) {
            return false;
        }
        File partitionFile = new File(PARTITION_FILE_NAME);
        return tempFile.renameTo(partitionFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void savePartitionTable() {
        File tempFile = new File(PARTITION_FILE_NAME + TEMP_SUFFIX);
        tempFile.getParentFile().mkdirs();
        File oldFile = new File(PARTITION_FILE_NAME);
        try (DataOutputStream outputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(tempFile)));){
            PartitionTable partitionTable = this.partitionTable;
            synchronized (partitionTable) {
                byte[] tableBuffer = this.partitionTable.serialize().array();
                outputStream.writeInt(tableBuffer.length);
                outputStream.write(tableBuffer);
                outputStream.flush();
            }
        }
        catch (IOException e) {
            logger.error("Cannot save the partition table", (Throwable)e);
        }
        if (oldFile.exists()) {
            try {
                Files.delete(Paths.get(oldFile.getAbsolutePath(), new String[0]));
            }
            catch (IOException e) {
                logger.warn("Old partition table file is not successfully deleted", (Throwable)e);
            }
        }
        if (!tempFile.renameTo(oldFile)) {
            logger.warn("New partition table file is not successfully renamed");
        }
        logger.info("Partition table is saved");
    }

    private void loadIdentifier() {
        if (this.thisNode.isSetNodeIdentifier()) {
            return;
        }
        File file = new File(NODE_IDENTIFIER_FILE_NAME);
        Integer nodeId = null;
        if (file.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                nodeId = Integer.parseInt(reader.readLine());
                logger.info("Recovered node identifier {}", (Object)nodeId);
            }
            catch (Exception e) {
                logger.warn("Cannot read the identifier from file, generating a new one", (Throwable)e);
            }
        }
        if (nodeId != null) {
            this.setNodeIdentifier(nodeId);
            return;
        }
        this.setNodeIdentifier(this.genNodeIdentifier());
    }

    private int genNodeIdentifier() {
        return Objects.hash(this.thisNode.getInternalIp(), this.thisNode.getMetaPort(), System.currentTimeMillis());
    }

    private void setNodeIdentifier(int identifier) {
        logger.info("The identifier of this node has been set to {}", (Object)identifier);
        this.thisNode.setNodeIdentifier(identifier);
        File idFile = new File(NODE_IDENTIFIER_FILE_NAME);
        idFile.getParentFile().mkdirs();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(idFile));){
            writer.write(String.valueOf(identifier));
        }
        catch (IOException e) {
            logger.error("Cannot save the node identifier", (Throwable)e);
        }
    }

    public PartitionTable getPartitionTable() {
        return this.partitionTable;
    }

    public void receiveSnapshot(SendSnapshotRequest request) throws SnapshotInstallationException {
        MetaSimpleSnapshot snapshot = new MetaSimpleSnapshot();
        snapshot.deserialize(request.snapshotBytes);
        snapshot.getDefaultInstaller(this).install(snapshot, -1, false);
    }

    @Override
    public TSStatus executeNonQueryPlan(PhysicalPlan plan) {
        TSStatus result;
        long startTime = Timer.Statistic.META_GROUP_MEMBER_EXECUTE_NON_QUERY.getOperationStartTime();
        if (PartitionUtils.isGlobalMetaPlan(plan)) {
            logger.debug("receive a global meta plan {}", (Object)plan);
            result = this.processNonPartitionedMetaPlan(plan);
        } else {
            logger.warn("receive a plan {} could not be processed in local", (Object)plan);
            result = StatusUtils.UNSUPPORTED_OPERATION;
        }
        Timer.Statistic.META_GROUP_MEMBER_EXECUTE_NON_QUERY.calOperationCostTimeFromStart(startTime);
        return result;
    }

    @Override
    ClientCategory getClientCategory() {
        return ClientCategory.META;
    }

    @Override
    public String getMBeanName() {
        return mbeanName;
    }

    public TSStatus processNonPartitionedMetaPlan(PhysicalPlan plan) {
        TSStatus result;
        TSStatus status;
        if (this.character == NodeCharacter.LEADER) {
            status = this.processPlanLocally(plan);
            if (status != null) {
                return status;
            }
        } else if (!ClusterConstant.EMPTY_NODE.equals((Node)this.leader.get()) && !StatusUtils.NO_LEADER.equals(result = this.forwardPlan(plan, (Node)this.leader.get(), null))) {
            result = StatusUtils.getStatus(result, new EndPoint(((Node)this.leader.get()).getInternalIp(), ((Node)this.leader.get()).getClientPort()));
            return result;
        }
        this.waitLeader();
        if (this.character == NodeCharacter.LEADER && (status = this.processPlanLocally(plan)) != null) {
            return status;
        }
        result = this.forwardPlan(plan, (Node)this.leader.get(), null);
        if (!StatusUtils.NO_LEADER.equals(result)) {
            result.setRedirectNode(new EndPoint(((Node)this.leader.get()).getClientIp(), ((Node)this.leader.get()).getClientPort()));
        }
        return result;
    }

    public List<PartitionGroup> routeFilter(Filter filter, PartialPath path) throws StorageEngineException, EmptyIntervalException {
        TimeValuePairUtils.Intervals intervals = TimeValuePairUtils.extractTimeInterval((Filter)filter);
        if (intervals.isEmpty()) {
            throw new EmptyIntervalException(filter);
        }
        return this.routeIntervals(intervals, path);
    }

    public List<PartitionGroup> routeIntervals(TimeValuePairUtils.Intervals intervals, PartialPath path) throws StorageEngineException {
        PartialPath storageGroupName;
        ArrayList<PartitionGroup> partitionGroups = new ArrayList<PartitionGroup>();
        try {
            storageGroupName = IoTDB.metaManager.getBelongedStorageGroup(path);
        }
        catch (MetadataException e) {
            throw new StorageEngineException((IoTDBException)e);
        }
        if (!StorageEngine.isEnablePartition()) {
            PartitionGroup partitionGroup = this.partitionTable.route(storageGroupName.getFullPath(), 0L);
            partitionGroups.add(partitionGroup);
            return partitionGroups;
        }
        long firstLB = intervals.getLowerBound(0);
        long lastUB = intervals.getUpperBound(intervals.getIntervalSize() - 1);
        if (firstLB == Long.MIN_VALUE || lastUB == Long.MAX_VALUE) {
            partitionGroups.addAll(this.partitionTable.getGlobalGroups());
        } else {
            HashSet<RaftNode> groupHeaders = new HashSet<RaftNode>();
            for (int i = 0; i < intervals.getIntervalSize(); ++i) {
                PartitionUtils.getIntervalHeaders(storageGroupName.getFullPath(), intervals.getLowerBound(i), intervals.getUpperBound(i), this.partitionTable, groupHeaders);
            }
            for (RaftNode groupHeader : groupHeaders) {
                partitionGroups.add(this.partitionTable.getPartitionGroup(groupHeader));
            }
        }
        return partitionGroups;
    }

    public Map<Node, Integer> getAllNodeStatus() {
        if (this.getPartitionTable() == null) {
            return null;
        }
        HashMap<Node, Integer> nodeStatus = new HashMap<Node, Integer>();
        Iterator<Object> iterator = this.allNodes.iterator();
        while (iterator.hasNext()) {
            Node node;
            nodeStatus.put(node, this.thisNode.equals(node = (Node)iterator.next()) ? 0 : 1);
        }
        try {
            if (this.config.isUseAsyncServer()) {
                this.getNodeStatusAsync(nodeStatus);
            } else {
                this.getNodeStatusSync(nodeStatus);
            }
        }
        catch (TException e) {
            logger.warn("Cannot get the status of all nodes", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("Cannot get the status of all nodes", (Throwable)e);
        }
        for (Node node : this.partitionTable.getAllNodes()) {
            nodeStatus.putIfAbsent(node, 2);
        }
        for (Node node : this.allNodes) {
            if (this.partitionTable.getAllNodes().contains(node)) continue;
            nodeStatus.put(node, 3);
        }
        return nodeStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getNodeStatusAsync(Map<Node, Integer> nodeStatus) throws TException, InterruptedException {
        NodeStatusHandler nodeStatusHandler = new NodeStatusHandler(nodeStatus);
        Map<Node, Integer> map = nodeStatus;
        synchronized (map) {
            for (Node node : this.allNodes) {
                TSMetaService.AsyncClient client = (TSMetaService.AsyncClient)this.getAsyncClient(node);
                if (node.equals(this.thisNode) || client == null) continue;
                client.checkAlive((AsyncMethodCallback)nodeStatusHandler);
            }
            nodeStatus.wait(1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getNodeStatusSync(Map<Node, Integer> nodeStatus) {
        NodeStatusHandler nodeStatusHandler = new NodeStatusHandler(nodeStatus);
        for (Node node : this.allNodes) {
            SyncMetaClient client = (SyncMetaClient)this.getSyncClient(node);
            if (node.equals(this.thisNode) || client == null) continue;
            Node response = null;
            try {
                response = client.checkAlive();
            }
            catch (TException e) {
                client.close();
            }
            finally {
                client.returnSelf();
            }
            nodeStatusHandler.onComplete(response);
        }
    }

    public Map<PartitionGroup, Integer> collectMigrationStatus(Node node) {
        try {
            if (this.config.isUseAsyncServer()) {
                return this.collectMigrationStatusAsync(node);
            }
            return this.collectMigrationStatusSync(node);
        }
        catch (TException e) {
            logger.error("{}: Cannot get the status of node {}", new Object[]{this.name, node, e});
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("{}: Cannot get the status of node {}", new Object[]{this.name, node, e});
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<PartitionGroup, Integer> collectMigrationStatusAsync(Node node) throws TException, InterruptedException {
        AtomicReference resultRef = new AtomicReference();
        GenericHandler migrationStatusHandler = new GenericHandler(node, resultRef);
        AsyncMetaClient client = (AsyncMetaClient)this.getAsyncClient(node);
        if (client == null) {
            return null;
        }
        client.collectMigrationStatus(migrationStatusHandler);
        AtomicReference atomicReference = resultRef;
        synchronized (atomicReference) {
            if (resultRef.get() == null) {
                resultRef.wait(ClusterConstant.getConnectionTimeoutInMS());
            }
        }
        return ClusterUtils.deserializeMigrationStatus((ByteBuffer)resultRef.get());
    }

    private Map<PartitionGroup, Integer> collectMigrationStatusSync(Node node) throws TException {
        SyncMetaClient client = (SyncMetaClient)this.getSyncClient(node);
        if (client == null) {
            return null;
        }
        try {
            Map<PartitionGroup, Integer> map = ClusterUtils.deserializeMigrationStatus(client.collectMigrationStatus());
            return map;
        }
        catch (TException e) {
            client.close();
            throw e;
        }
        finally {
            client.returnSelf();
        }
    }

    public void setPartitionTable(PartitionTable partitionTable) {
        this.partitionTable = partitionTable;
        this.router = new ClusterPlanRouter(partitionTable);
        this.coordinator.setRouter(this.router);
        DataGroupEngine dClusterServer = this.getDataGroupEngine();
        if (dClusterServer != null) {
            dClusterServer.setPartitionTable(partitionTable);
        }
    }

    public long removeNode(Node node) throws PartitionTableUnavailableException, LogExecutionException, InterruptedException, CheckConsistencyException {
        if (this.partitionTable == null) {
            logger.info("Cannot add node now because the partition table is not set");
            throw new PartitionTableUnavailableException(this.thisNode);
        }
        this.waitLeader();
        return this.processRemoveNodeLocally(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long processRemoveNodeLocally(Node node) throws LogExecutionException, InterruptedException, CheckConsistencyException {
        if (this.character != NodeCharacter.LEADER) {
            return Long.MIN_VALUE;
        }
        if (this.allNodes.size() <= this.config.getReplicationNum()) {
            return -8L;
        }
        if (!this.waitDataMigrationEnd()) {
            return -10L;
        }
        Node target = null;
        PartitionGroup partitionGroup = this.allNodes;
        synchronized (partitionGroup) {
            for (Node n : this.allNodes) {
                if (!n.internalIp.equals(node.internalIp) || n.metaPort != node.metaPort) continue;
                target = n;
                break;
            }
        }
        if (target == null) {
            logger.debug("Node {} is not in the cluster", (Object)node);
            return -3L;
        }
        RemoveNodeLog removeNodeLog = new RemoveNodeLog();
        RaftLogManager raftLogManager = this.logManager;
        synchronized (raftLogManager) {
            SlotPartitionTable table = new SlotPartitionTable((SlotPartitionTable)this.partitionTable);
            table.removeNode(target);
            table.setLastMetaLogIndex(this.logManager.getLastLogIndex() + 1L);
            removeNodeLog.setPartitionTable(table.serialize());
            removeNodeLog.setCurrLogTerm(this.getTerm().get());
            removeNodeLog.setCurrLogIndex(this.logManager.getLastLogIndex() + 1L);
            removeNodeLog.setMetaLogIndex(this.logManager.getLastLogIndex() + 1L);
            removeNodeLog.setRemovedNode(target);
            this.logManager.append(removeNodeLog);
        }
        int retryTime = 0;
        block13: while (true) {
            logger.info("{}: Send the node removal request of {} to other nodes, retry time: {}", new Object[]{this.name, target, retryTime});
            RaftMember.AppendLogResult result = this.sendLogToFollowers(removeNodeLog);
            switch (result) {
                case OK: {
                    this.commitLog(removeNodeLog);
                    logger.info("{}: Removal request of {} is accepted", (Object)this.name, (Object)target);
                    return -1L;
                }
                case TIME_OUT: {
                    logger.info("{}: Removal request of {} timed out", (Object)this.name, (Object)target);
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    ++retryTime;
                    continue block13;
                }
            }
            break;
        }
        return Long.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyRemoveNode(RemoveNodeLog removeNodeLog) {
        long startTime = System.currentTimeMillis();
        Node oldNode = removeNodeLog.getRemovedNode();
        PartitionGroup partitionGroup = this.allNodes;
        synchronized (partitionGroup) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Removing a node {} from {}", new Object[]{this.name, oldNode, this.allNodes});
            }
            if (this.allNodes.contains(oldNode)) {
                this.allNodes.remove(oldNode);
                this.idNodeMap.remove(oldNode.nodeIdentifier);
            }
            this.savePartitionTable();
            NodeRemovalResult result = this.partitionTable.getNodeRemovalResult();
            this.getDataGroupEngine().removeNode(oldNode, result);
            if (oldNode.equals((Node)this.leader.get()) && !oldNode.equals(this.thisNode)) {
                Object object = this.term;
                synchronized (object) {
                    this.setCharacter(NodeCharacter.ELECTOR);
                    this.setLeader(null);
                }
                object = this.getHeartBeatWaitObject();
                synchronized (object) {
                    this.getHeartBeatWaitObject().notifyAll();
                }
            }
            if (oldNode.equals(this.thisNode)) {
                new Thread(() -> {
                    try {
                        Thread.sleep(ClusterConstant.getHeartbeatIntervalMs());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    super.stop();
                    this.getDataGroupEngine().stop();
                    logger.info("{} has been removed from the cluster", (Object)this.name);
                }).start();
            } else if (this.thisNode.equals((Node)this.leader.get())) {
                this.getAppendLogThreadPool().submit(() -> this.exileNode(removeNodeLog));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Success to remove a node {} from {}", new Object[]{this.name, oldNode, this.allNodes});
            }
            logger.info("{}: execute removing node {} cost {} ms", new Object[]{this.name, oldNode, System.currentTimeMillis() - startTime});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exileNode(RemoveNodeLog removeNodeLog) {
        logger.debug("Exile node {}: start.", (Object)removeNodeLog.getRemovedNode());
        Node node = removeNodeLog.getRemovedNode();
        if (this.config.isUseAsyncServer()) {
            AsyncMetaClient asyncMetaClient = (AsyncMetaClient)this.getAsyncClient(node);
            if (asyncMetaClient != null) {
                try {
                    asyncMetaClient.exile(removeNodeLog.serialize(), new GenericHandler(node, null));
                }
                catch (TException e) {
                    logger.warn("Cannot inform {} its removal", (Object)node, (Object)e);
                }
            } else {
                logger.error("exile node fail for node: {} as empty client", (Object)node);
            }
        } else {
            SyncMetaClient client = (SyncMetaClient)this.getSyncClient(node);
            if (client == null) {
                return;
            }
            try {
                client.exile(removeNodeLog.serialize());
            }
            catch (TException e) {
                client.close();
                logger.warn("Cannot inform {} its removal", (Object)node, (Object)e);
            }
            finally {
                client.returnSelf();
            }
        }
    }

    public NodeReport.MetaMemberReport genMemberReport() {
        long prevLastLogIndex = this.lastReportedLogIndex;
        this.lastReportedLogIndex = this.logManager.getLastLogIndex();
        return new NodeReport.MetaMemberReport(this.character, (Node)this.leader.get(), this.term.get(), this.logManager.getLastLogTerm(), this.lastReportedLogIndex, this.logManager.getCommitLogIndex(), this.logManager.getCommitLogTerm(), this.readOnly, this.lastHeartbeatReceivedTime, prevLastLogIndex, this.logManager.getMaxHaveAppliedCommitIndex());
    }

    public Map<PartitionGroup, Integer> collectAllPartitionMigrationStatus() throws CheckConsistencyException {
        this.syncLeader(null);
        HashMap<PartitionGroup, Integer> res = new HashMap<PartitionGroup, Integer>();
        for (Node node : this.allNodes) {
            Map<PartitionGroup, Integer> oneNodeRes;
            if (logger.isDebugEnabled()) {
                logger.debug("{}: start to get migration status of {}", (Object)this.name, (Object)node);
            }
            if ((oneNodeRes = node.equals(this.thisNode) ? this.collectMigrationStatus() : this.collectMigrationStatus(node)) == null) {
                return null;
            }
            for (Map.Entry<PartitionGroup, Integer> entry : oneNodeRes.entrySet()) {
                res.put(entry.getKey(), Math.max(res.getOrDefault(entry.getKey(), 0), entry.getValue()));
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PartitionGroup, Integer> collectMigrationStatus() {
        logger.info("{}: start to collect migration status locally.", (Object)this.name);
        HashMap<PartitionGroup, Integer> groupSlotMap = new HashMap<PartitionGroup, Integer>();
        if (this.getPartitionTable() == null) {
            return groupSlotMap;
        }
        Map<RaftNode, DataGroupMember> headerMap = this.getDataGroupEngine().getHeaderGroupMap();
        this.syncLocalApply(this.getPartitionTable().getLastMetaLogIndex(), false);
        Map<RaftNode, DataGroupMember> map = headerMap;
        synchronized (map) {
            for (DataGroupMember dataMember : headerMap.values()) {
                int num = dataMember.getSlotManager().getSlotNumInDataMigration();
                if (num <= 0) continue;
                groupSlotMap.put(dataMember.getPartitionGroup(), num);
            }
        }
        return groupSlotMap;
    }

    @Override
    public void setAllNodes(PartitionGroup allNodes) {
        super.setAllNodes(new PartitionGroup(allNodes));
        this.initPeerMap();
        this.idNodeMap = new HashMap<Integer, Node>();
        for (Node node : allNodes) {
            this.idNodeMap.put(node.getNodeIdentifier(), node);
        }
    }

    public DataGroupMember getLocalDataMember(RaftNode header, Object request) {
        return this.getDataGroupEngine().getDataMember(header, null, request);
    }

    public DataGroupMember getLocalDataMember(RaftNode raftNode) {
        return this.getDataGroupEngine().getDataMember(raftNode, null, "Internal call");
    }

    @Override
    public void closeLogManager() {
        super.closeLogManager();
        if (this.getDataGroupEngine() != null) {
            this.getDataGroupEngine().closeLogManagers();
        }
    }

    public StartUpStatus getStartUpStatus() {
        return this.startUpStatus;
    }

    public void setRouter(ClusterPlanRouter router) {
        this.router = router;
    }

    public void handleHandshake(Node sender) {
        NodeStatusManager.getINSTANCE().activate(sender);
    }

    @Override
    public String getAllNodesAsString() {
        return this.getAllNodes().toString();
    }

    @Override
    public String getPartitionTableAsString() {
        return this.partitionTable.toString();
    }

    @Override
    public String getBlindNodesAsString() {
        return this.blindNodes.toString();
    }

    @Override
    public String getIdNodeMapAsString() {
        return this.idNodeMap.toString();
    }
}

