/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final Logger logger = LoggerFactory.getLogger(IOUtils.class);

    private IOUtils() {
    }

    public static ByteBuffer readFile(String filePath, long offset, int length) throws IOException {
        boolean fileExhausted;
        ByteBuffer result;
        File file = new File(filePath);
        if (!file.exists()) {
            return ByteBuffer.allocate(0);
        }
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
            IOUtils.skipExactly(bufferedInputStream, offset);
            byte[] bytes = new byte[length];
            result = ByteBuffer.wrap(bytes);
            int len = bufferedInputStream.read(bytes);
            result.limit(Math.max(len, 0));
            fileExhausted = bufferedInputStream.available() <= 0;
        }
        if (fileExhausted) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                logger.warn("Cannot delete an exhausted file {}", (Object)filePath, (Object)e);
            }
        }
        return result;
    }

    private static void skipExactly(InputStream stream, long byteToSkip) throws IOException {
        while (byteToSkip > 0L) {
            byteToSkip -= stream.skip(byteToSkip);
        }
    }

    public static Throwable getRootCause(Throwable e) {
        Throwable curr = e;
        while (curr.getCause() != null) {
            curr = curr.getCause();
        }
        return curr;
    }
}

