/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.utils;

import java.util.List;
import java.util.Set;
import org.apache.iotdb.cluster.partition.PartitionTable;
import org.apache.iotdb.cluster.rpc.thrift.RaftNode;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.qp.physical.sys.AppendTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.AuthorPlan;
import org.apache.iotdb.db.qp.physical.sys.ClearCachePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateFunctionPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateSnapshotPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.DataAuthPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DropFunctionPlan;
import org.apache.iotdb.db.qp.physical.sys.FlushPlan;
import org.apache.iotdb.db.qp.physical.sys.KillQueryPlan;
import org.apache.iotdb.db.qp.physical.sys.LoadConfigurationPlan;
import org.apache.iotdb.db.qp.physical.sys.LoadDataPlan;
import org.apache.iotdb.db.qp.physical.sys.MergePlan;
import org.apache.iotdb.db.qp.physical.sys.OperateFilePlan;
import org.apache.iotdb.db.qp.physical.sys.PruneTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.SetSystemModePlan;
import org.apache.iotdb.db.qp.physical.sys.SetTTLPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTTLPlan;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.utils.Murmur128Hash;

public class PartitionUtils {
    private PartitionUtils() {
    }

    public static boolean isLocalNonQueryPlan(PhysicalPlan plan) {
        return plan instanceof LoadDataPlan || plan instanceof OperateFilePlan || plan instanceof KillQueryPlan || plan instanceof LoadConfigurationPlan && ((LoadConfigurationPlan)plan).getLoadConfigurationPlanType().equals((Object)LoadConfigurationPlan.LoadConfigurationPlanType.LOCAL);
    }

    public static boolean isGlobalMetaPlan(PhysicalPlan plan) {
        return plan instanceof SetStorageGroupPlan || plan instanceof SetTTLPlan || plan instanceof ShowTTLPlan || plan instanceof LoadConfigurationPlan && ((LoadConfigurationPlan)plan).getLoadConfigurationPlanType().equals((Object)LoadConfigurationPlan.LoadConfigurationPlanType.GLOBAL) || plan instanceof AuthorPlan || plan instanceof DeleteStorageGroupPlan || plan instanceof DataAuthPlan || plan instanceof CreateTemplatePlan || plan instanceof AppendTemplatePlan || plan instanceof PruneTemplatePlan || plan instanceof CreateFunctionPlan || plan instanceof DropFunctionPlan || plan instanceof CreateSnapshotPlan || plan instanceof SetSystemModePlan;
    }

    public static boolean isGlobalDataPlan(PhysicalPlan plan) {
        return plan instanceof DeletePlan || plan instanceof DeleteTimeSeriesPlan || plan instanceof MergePlan || plan instanceof FlushPlan || plan instanceof SetTemplatePlan || plan instanceof ClearCachePlan;
    }

    public static int calculateStorageGroupSlotByTime(String storageGroupName, long timestamp, int slotNum) {
        long partitionNum = StorageEngine.getTimePartition((long)timestamp);
        return PartitionUtils.calculateStorageGroupSlotByPartition(storageGroupName, partitionNum, slotNum);
    }

    private static int calculateStorageGroupSlotByPartition(String storageGroupName, long partitionNum, int slotNum) {
        int hash = Murmur128Hash.hash((String)storageGroupName, (long)partitionNum, (int)2333);
        return Math.abs(hash % slotNum);
    }

    public static InsertTabletPlan copy(InsertTabletPlan plan, long[] times, Object[] values, BitMap[] bitMaps) {
        InsertTabletPlan newPlan = new InsertTabletPlan(plan.getDevicePath(), plan.getMeasurements());
        newPlan.setDataTypes(plan.getDataTypes());
        newPlan.setColumns(values);
        newPlan.setBitMaps(bitMaps);
        newPlan.setTimes(times);
        newPlan.setRowCount(times.length);
        newPlan.setMeasurementMNodes(plan.getMeasurementMNodes());
        return newPlan;
    }

    public static void reordering(InsertTabletPlan plan, TSStatus[] status, TSStatus[] subStatus) {
        List range = plan.getRange();
        int destLoc = 0;
        for (int i = 0; i < range.size(); i += 2) {
            int start = (Integer)range.get(i);
            int end = (Integer)range.get(i + 1);
            System.arraycopy(subStatus, destLoc, status, start, end - start);
            destLoc += end - start;
        }
    }

    public static void getIntervalHeaders(String storageGroupName, long timeLowerBound, long timeUpperBound, PartitionTable partitionTable, Set<RaftNode> result) {
        long partitionInterval = StorageEngine.getTimePartitionInterval();
        for (long currPartitionStart = timeLowerBound / partitionInterval * partitionInterval; currPartitionStart <= timeUpperBound; currPartitionStart += partitionInterval) {
            result.add(partitionTable.routeToHeaderByTime(storageGroupName, currPartitionStart));
        }
    }
}

